package com.bokesoft.yes.excel.cmd.normal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.bokesoft.yigo.common.def.OperationState;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ImportDictionaryHander;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.util.ExcelUtils;

public class ImportExcelWithFormula implements IImport {
	/** 表单标识*/
	private String formKey = null;
	/** 上下文环境 */
	private DefaultContext context;
	/** 数据源配置对象 */
	private MetaDataObject metaDataObject;
	/** Excel数据对象 */
	private Workbook workbook;
	/** 导入后事件 */
	private String postImportServiceName;
	/** 源Document*/
	private Document document = null;
	/** 记录导入的字段*/
	private HashMap<String, List<String>> importFields = null;
	/** 记录第一张sheet的tablekey*/
	private String firstTableKey = null;
	
	public ImportExcelWithFormula(String formKey, DefaultContext context, MetaDataObject metaDataObject, Workbook workbook, Document document, boolean clearOriginalData, String postImportServiceName) {
		this.formKey = formKey;
		this.context = context;
		this.workbook = workbook;
		this.metaDataObject = metaDataObject;
		this.postImportServiceName = postImportServiceName;
		this.document = document;
		
		_init();
	}

	// 模板信息和批量导入的保持一致
	private void _init() {
		Sheet sheet = null;
		String tableKey = null;
		MetaTable metaTable = null;

		importFields = new HashMap<String, List<String>>();

		boolean bFirst = true;
		int count = workbook.getNumberOfSheets();
		for (int i = 0; i < count; ++i) {
			sheet = workbook.getSheetAt(i);
			tableKey = sheet.getSheetName();

			metaTable = metaDataObject.getTable(tableKey);
			if (metaTable == null) {
				continue;
			}

			int colIndex = 0;
			if (bFirst) {
				firstTableKey = tableKey;
				colIndex = 1;
				bFirst = false;
			}
			
			ArrayList<String> list = new ArrayList<String>();
			while (true) {
				String fieldKey = ExcelUtil.getCellValue(sheet, 0, colIndex).toString();
				if (fieldKey.isEmpty()) {
					break;
				}
				list.add(fieldKey);
				colIndex++;
			}

			importFields.put(tableKey, list);
		}
	}

	@Override
	public Object importData() throws Throwable {
		String tableKey = null;
		
		Sheet sheet = null;
		MetaTable metaTable = null;
		
		Iterator<String> it = importFields.keySet().iterator();
		while (it.hasNext()) {
			tableKey = it.next();

			metaTable = metaDataObject.getTable(tableKey);

			sheet = ExcelUtil.getSheet(workbook, tableKey);
			switch (metaTable.getTableMode()) {
			case TableMode.HEAD:
				fillHeadData(sheet, document, tableKey);
				break;
			case TableMode.DETAIL:
				fillDetailData(sheet, document, tableKey);
				break;
			}
		}
		
		if (postImportServiceName != null && !postImportServiceName.isEmpty()) {
			@SuppressWarnings("unchecked")
			IServiceProcess<IServiceContext> process = (IServiceProcess<IServiceContext>) ReflectHelper.newInstance(context.getVE(), postImportServiceName);
			if (process != null) {
				DefaultContext newContext = new DefaultContext(context);
				newContext.setDocument(document);
				newContext.setDataObject(metaDataObject);
				process.process(newContext);
			}
		}
		//计算默认值公式
		ExcelUtils.calcDefaultFormula(document, importFields, context);
		
		JSONObject docuemntJson = document.toJSON();
		JSONObject importFieldsJson = new JSONObject(); 
		for (String key : importFields.keySet()) {
			JSONArray listArray = new JSONArray();
			importFieldsJson.put(key, listArray);
			
			List<String> list = importFields.get(key);
			for (String str : list) {
				listArray.put(str);
			}
		}
		
		MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);
		
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("document", docuemntJson);
//		jsonObject.put("importFields", importFieldsJson);
		jsonObject.put("IgnoreKeys", MetaUtil.getIgnoreKeys(metaForm, importFields));
		
		return jsonObject;
	}

	private void fillHeadData(Sheet sheet, Document document, String tableKey) throws Throwable {
		MetaTable metaTable = metaDataObject.getMetaTable(tableKey);
		DataTable dataTable = document.get(tableKey);
		dataTable.first();
		fillImportField(metaTable, dataTable, sheet, 2, importFields.get(tableKey));
	}
	
	private void fillDetailData(Sheet sheet, Document document, String tableKey) throws Throwable {
		MetaTable metaTable = metaDataObject.getMetaTable(tableKey);
		DataTable dataTable = document.get(tableKey);
		
		boolean isEmpty = false;
		
		int rowIndex = 2;
		while (true) {
			DocumentUtil.newRow(metaTable, dataTable);
			isEmpty = fillImportField(metaTable, dataTable, sheet, rowIndex, importFields.get(tableKey));
			if (isEmpty) {
				dataTable.delete();
				break;
			}
			rowIndex++;
		}
	}
	
	// 填充导入的字段,并判断是否空行
	private boolean fillImportField(MetaTable metaTable, DataTable dataTable, Sheet sheet, int rowIndex, List<String> fields) throws Throwable {
		boolean isEmpty = true;
		boolean bFirstTable = firstTableKey.equals(metaTable.getKey());
		for (int colIndex = 0; colIndex < fields.size(); colIndex++) {
			String columnKey = fields.get(colIndex);
			String[] columnKeys = columnKey.split(ImportDictionaryHander.SEPARATOR);
			
			Object value = ExcelUtil.getCellValue(sheet, rowIndex, bFirstTable ? colIndex + 1 : colIndex);
			if (TypeConvertor.toString(value).isEmpty()) {
				continue;
			} 
			isEmpty = false;
			value = transformValue(metaTable, columnKey, value);
			dataTable.setObject(columnKeys[0], value);
		}
		
		return isEmpty;
	}

	// 从Excel中获取导入的值，根据字段类型做转换
	private Object transformValue(MetaTable metaTable, String fieldKey, Object value) throws Throwable {
		String[] fields = fieldKey.split(ImportDictionaryHander.SEPARATOR);
		String columnKey = fields[0];
		if (fields.length > 1) {
			String itemKey = fields[1];
			
			IDictCacheProxy dictCache = context.getDictCache();
			MetaDataObject dictDataObject = context.getVE().getMetaFactory().getDataObject(itemKey);
			List<MetaColumn> displayColumns = dictDataObject.getDisplayColumns();
			for (MetaColumn metaColumn : displayColumns) {
				Item item = dictCache.locate(itemKey, metaColumn.getKey(), value.toString(), null, null, DictStateMask.All, OperationState.Default);
				if (item != null) {
					value = item.getID();
					break;
				}
			}
//			
//			IDictCacheProxy dictCache = (IDictCacheProxy) context.getVE().getDictCache();
//			Item item = dictCache.locate(itemKey, "Code", value.toString().toUpperCase(), null, null, DictStateMask.All);
//			value = item == null ? 0 : item.getID();
		}

		// 根据数DataType转型
		MetaColumn column = metaTable.get(columnKey);
		int dataType = column.getDataType();
		value = TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(dataType), value);

		return value;
	}
}
