package com.bokesoft.yes.excel.cmd.normal;

import java.util.HashMap;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ImportBillHandler;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.util.ExcelUtils;

public class ImportDictionaryWithDoc implements IImport ,DictChecker{

	private Workbook workbook = null;

	private ImportBillHandler handler = null;
	// 上下文关系
	private DefaultContext context = null;
	// 保存前处理事件
	private String postServiceName = null;

	private boolean isRepeatCode = false;
	// 是否清楚旧数据
	private boolean clearOriginalData = false;
	
	public ImportDictionaryWithDoc(DefaultContext context, Workbook workbook, String postServiceName,boolean clearOriginalData) throws Throwable {
		this.context = context;
		// 将字节流转换为work
		this.workbook = workbook;
		this.postServiceName = postServiceName;
		this.clearOriginalData = clearOriginalData;
		handler = new ImportBillHandler(context, workbook);
	}

	public Object importData() throws Throwable {
		MetaDataObject metaDataObject = handler.getDataObject();
		Sheet mainSheet = handler.getMainSheet();

		int sheetCount = workbook.getNumberOfSheets();
		String codeKey = null;
		// 第一行为隐藏行，第二行为标题行，数据从第三行开始
		int rowIndex = 2;
		String tableKey = mainSheet.getSheetName();
		// 记录明细表已导入的行数
		HashMap<String, Integer> sheetRow = new HashMap<String, Integer>();
			//String tableKey = mainSheet.getSheetName();
		MetaTable metaTable = metaDataObject.getTable(tableKey);
		if(metaTable == null) {
			LogSvr.getInstance().info("导入excel未配置主表: " + tableKey);
			return true;
		}
		while (true) {
			
			codeKey = ExcelUtil.getCellValue(mainSheet, rowIndex, 1).toString();
			if (codeKey.isEmpty()) {
				break;
			}
			
			
			Document document = DocumentUtil.newDocument(metaDataObject);
			document.setNew();
			
			DataTable dataTable = document.get(tableKey);
			
			//数据库现存数据的所有Code,判断现导入的字典的Code是否在数据库中已存在。
			String sql = "select * from "+metaDataObject.getMainTable().getBindingDBTableName() +" where Code =?";
			DataTable query = context.getDBManager().execPrepareQuery(sql, codeKey);
			
			isRepeatCode = query != null && query.size()>0;
			if (isRepeatCode()){
				Long OID = query.getLong(0, SystemField.OID_SYS_KEY);
				
				//预设置document以及DataTable下行的OID，行属性在修改状态下不会预设这些值。
				document.setOID(OID);
				document.put(tableKey, query);
				dataTable = document.get(tableKey);

				if(clearOriginalData){
					this.clearOriginalData(sheetCount, OID);
				}
			}	
			
			//填充数据
			if (metaTable.getTableMode() == TableMode.DETAIL) {
				DocumentUtil.newRow(metaTable, dataTable);
			} else {
				dataTable.first();
			}
			
				
			handler.fillImportField(metaTable, dataTable, mainSheet, rowIndex);
			
			for(int sheetIndex = 1; sheetIndex < sheetCount; sheetIndex++) {
				fillTableData(workbook.getSheetAt(sheetIndex), metaDataObject, document, sheetRow,codeKey);
			}
			
			DefaultContext newContext = new DefaultContext(context);
			newContext.setFormKey(context.getFormKey());
				
			// 参考SingleImportExcel这么写
			if (postServiceName != null && !postServiceName.isEmpty()) {
				@SuppressWarnings("unchecked")
				IServiceProcess<IServiceContext> process = (IServiceProcess<IServiceContext>) ReflectHelper.newInstance(context.getVE(), postServiceName);
				if (process != null) {
					newContext.setDocument(document);
					newContext.setDataObject(metaDataObject);
					process.process(newContext);
				}
			}
			
			if (isRepeatCode()){
				//计算默认值公式
				ExcelUtils.calcDefaultFormula(document, handler.getImportFields(), context);
			}
				
			SaveData saveData = new SaveData(metaDataObject, null, document);
			saveData.save(newContext);
			
			++rowIndex;
		}
		
		return true;
	}
	
	//清除原有数据，清除逻辑：
	//逻辑一：头表数据需要覆盖
	//逻辑二：如果导入数据的头表数据没有该字段，则不覆盖
	//逻辑三：如果打入数据的头表数据字段为空，也需要覆盖
	//逻辑四：删除所有该条数据的所有子明细
	private void clearOriginalData(int sheetCount, Long OID) throws Throwable{
		//清除原有的明细属性
		for(int sheetIndex = 1; sheetIndex < sheetCount; sheetIndex++) {
			String tableKey = workbook.getSheetAt(sheetIndex).getSheetName();
			IDBManager dbManager = context.getDBManager();
			String deleteSql = "DELETE FROM " + dbManager.keyWordEscape(tableKey) + " WHERE SOID=?";
			System.err.println(deleteSql);
			dbManager.execPrepareUpdate(deleteSql, OID);
		}
	}
	
	private void fillTableData(Sheet sheet, MetaDataObject metaDataObject, Document document, HashMap<String, Integer> sheetRow,String codeKey) throws Throwable {
		String tableKey = sheet.getSheetName();
		MetaTable metaTable = metaDataObject.getTable(tableKey);
		if (metaTable == null) {
			return;
		}
		
		int rowIndex = 2;
		String primayKey = codeKey;
		if (sheetRow.containsKey(tableKey)) {
			rowIndex = sheetRow.get(tableKey);
		}
		
		DataTable dataTable = document.get(tableKey);
		dataTable.first();
		
		while(true) {
			String curPrimayKey = handler.getPrimayKey(sheet, rowIndex, false); 
			if (!curPrimayKey.equalsIgnoreCase(primayKey)) {
				sheetRow.put(tableKey, rowIndex);
				break;
			}
			
			if (metaTable.getTableMode() == TableMode.DETAIL) {
				DocumentUtil.newRow(metaTable, dataTable);
			}
			
			handler.fillImportField(metaTable, dataTable, sheet, rowIndex);
			rowIndex++;
		}
	}

	@Override
	public boolean isRepeatCode() {
		// TODO Auto-generated method stub
		return isRepeatCode;
	}
}
