package com.bokesoft.yes.dts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.dts.data.DTSData;
import com.bokesoft.yes.dts.result.IResultProvider;
import com.bokesoft.yes.dts.result.ResultProvider;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;

public class Insert {
	/**
	 * 本地文档
	 */
	private Document localDocument;
	private Document document;
	private DTSData dtsData;
	private MetaDataObject metaDataObject;
	private DefaultContext context;
	
	public Insert(Document localDocument, Document document, DTSData dtsData, MetaDataObject metaDataObject, DefaultContext context) {
		super();
		this.localDocument = localDocument;
		this.document = document;
		this.dtsData = dtsData;
		this.metaDataObject = metaDataObject;
		this.context = context;
	}

	public Object insert() throws Throwable{
		
		if(localDocument != null) {
			/*每个本地表和接收表逐行对比*/
			for (MetaTable metaTable : metaDataObject.getTableCollection()){
				String key = metaTable.getKey();
				/*本地表*/
				DataTable table1 = localDocument.get(key);
				/*接收表*/
				DataTable table2 = document.get(key);
	
				/*对于是否删除未匹配，可能设置了所有表，也可能特别设置了某些表*/

				simpleMerge(table1, table2, metaTable);
			}
		}else {
			localDocument = document;
		}
		localDocument.setNew();

//		Iterator<DataTable> iterator = document.iterator();
//		while(iterator.hasNext()){
//			DataTable table = iterator.next();
//			setTableState(table, RowState.NEW);
//		}
		SaveData saveData = new SaveData(metaDataObject, null, localDocument);
		localDocument = saveData.save(context);
		/*启动流程*/
		if( dtsData.isStartInstance() == true){
			String processKey = dtsData.getProcessKey();
			if(processKey == null ){
				MetaProcessMap processMap = context.getVE().getMetaFactory().getMetaBPM().getMetaProcessMapCollection().getFormMapInfo(dtsData.getFormKey());
				if(processMap!=null)
					processKey = processMap.getProcessKey();		
			}
			if(processKey != null){
				if(context.getVE().getMetaFactory().getMetaBPM().getMetaBPMDeployInfoCollection().containsKey(processKey) == false)
					throw new DTSException(DTSException.INVALID_PROCESSKEY, "无效的processKey:" + processKey);	
				startInstance(context, dtsData.getFormKey(), processKey, localDocument.getOID());
			}
		}
		/*返回数据处理*/
		IResultProvider resultProvider = new ResultProvider();
		Object result = resultProvider.getResult(localDocument, dtsData.getReturnFields(), null);
		return result;
	}
	
	/**
	 * 批量修改表的行状态
	 * @param table 要修改行状态的表
	 * @param state 要批量改成的状态
	 */
	private static final void setTableState(DataTable table, int state){
		table.beforeFirst();
		while(table.next())
			table.setState(state);
	}
	
	private static void startInstance(DefaultContext defaultContext, String formKey, String processKey, long OID) throws Throwable{
		BPMContext context = new BPMContext(defaultContext);
		// 载入关联单据
		LoadFormData loadData = new LoadFormData(formKey, OID);
		Document doc = loadData.load(context, null);

		// 初始化上下文的元文件信息
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		context.setFormKey(formKey);
		context.setDataObject(metaForm.getDataSource().getDataObject());
		context.setDocument(doc);

		// 启动流程
		BPMInstanceFactory.startInstance(context, doc, processKey, true, formKey);

		// 保存数据
		context.getInstanceDataContainer().save();
	}
	
	/**
	 * 简单地合并两张表, 结果存在table1中。
	 * @param delete 是否删除table1原来的数据
	 * @param table1
	 * @param table2
	 * @return 新加入的数据行的bookmark数组
	 */
	private static final int[] simpleMerge(DataTable table1, DataTable table2, MetaTable metaTable) throws Throwable{
		/*处理table2的数据*/
		int size = table2.size();
		if(size == 0)
			return null;
		int[] array = new int[size];
		int index = 0;
		
		
		DataTableMetaData tgtMetaData = table1.getMetaData();
		ColumnInfo tgtCoInfo = null;
		Iterator<MetaColumn> it = null;
		String key = null;
		table2.beforeFirst();
		while ( table2.next() ) {
			if(metaTable.getTableMode() == TableMode.DETAIL) {
				DocumentUtil.newRow(metaTable, table1);
			}
			array[index++] = table1.getBookmark();
			it = metaTable.iterator();
			while( it.hasNext() ){
				key = it.next().getKey();
				if(systemFields.contains(key))
					continue;
				Object value = table2.getObject(key);
				if(value != null) {
					tgtCoInfo = tgtMetaData.getColumnInfo(key);
					if(tgtCoInfo != null){
						table1.setObject(key, TypeConvertor.toDataType(tgtCoInfo.getDataType(), table2.getObject(key)));
					}
				}
			}
			if( table2.getParentBookmark() != -1 ) {
				table1.setParentBookmark(table2.getParentBookmark());
			}
		}
		
		return array;
	}
	
	/**
	 * 把table2中index2行复制到table1的index1行, 原先行被清除，根据table1的格式
	 * @param table1
	 * @param index1
	 * @param table2
	 * @param index2
	 */
	private static final void copyRow(DataTable table1, int index1, DataTable table2, int index2, MetaTable metaTable){
		int colSize = table1.getMetaData().getColumnCount();
		table1.setPos(index1);
		for(int i = 0; i < colSize; i++ ){
			String key = table1.getMetaData().getColumnInfo(i).getColumnKey();
			//不拷贝系统字段
			//if(systemFields.contains(key))
			//	continue;
			Object value = table2.getObject(index2, key);
			//有值才拷贝
			if(value != null )
				table1.setObject(i, value);
			
		}
	}
	
	private static final ArrayList<String> systemFields = new ArrayList<String>(Arrays.asList(
			SystemField.OID_SYS_KEY, SystemField.SOID_SYS_KEY, SystemField.POID_SYS_KEY, 
			SystemField.VERID_SYS_KEY, SystemField.DVERID_SYS_KEY,
			SystemField.NO_SYS_KEY, SystemField.MAPKEY_SYS_KEY, SystemField.SRCOID_SYS_KEY, SystemField.SRCSOID_SYS_KEY, 
			SystemField.MAPCOUNT_SYS_KEY, SystemField.SLOCK_SYS_KEY, SystemField.SEQUENCE_SYS_KEY, 
			SystemField.HVER_SYS_KEY, SystemField.HVERM_SYS_KEY, SystemField.SVERID_SYS_KEY, SystemField.SUBMITTER_FIELD_KEY));
}
