package com.bokesoft.yes.mid.function;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import com.bokesoft.yes.mid.cmd.data.RollDataCmd;
import com.bokesoft.yes.mid.cmd.util.CmdUtil;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;

public class MidMigrationFunction extends BaseFunImplCluster {

	class RollDataImpl extends BaseMidFunctionImpl {
		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor) throws Throwable {
			String dataObjectKey = TypeConvertor.toString(args[0]);
			int endPeriod = 0;
			if (args.length > 1) {
				endPeriod = TypeConvertor.toInteger(args[1]);
			}
			Map<String, String> paras = null;
			if (args.length > 2) {
				String str = TypeConvertor.toString(args[2]);
				if (str != null && !str.isEmpty()) {
					paras = CmdUtil.split(str);
				}
			}
			Map<String, Object> group = null;
			if (paras != null) {
				group = new HashMap<String, Object>();
				Set<Entry<String, String>> entrySet = paras.entrySet();
				for (Entry<String, String> entry : entrySet) {
					String key = entry.getKey();
					String expValue = entry.getValue();
					Object value = context.getMidParser().eval(ScriptType.Formula, expValue);
					group.put(key, value);
				}
			}

			RollDataCmd cmd = new RollDataCmd(dataObjectKey, endPeriod, group);
			cmd.doCmd(context);
			return true;
		}

	}
	
	@Override
	public Object[][] getImplTable() {
		return new Object[][] { 
			{ "RollData", new RollDataImpl() }
		};
	}
}
