package com.bokesoft.yes.mid.function;

import com.bokesoft.yes.mid.datamap.calculate.MapMidUtil;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 数据映射的中间层公式
 * 
 * @author 刘翔翔
 *
 */
public class MidMapFunction extends BaseFunImplCluster {

	/**
	 * 执行数据映射
	 * <ul>
	 * <li>mapKey 数据映射的Key
	 * <li>sysTopic 系统主题
	 * </ul>
	 * 
	 * @author 刘翔翔
	 *
	 */
	class MapImpl extends BaseMidFunctionImpl {
		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor) throws Throwable {
			String mapKey = TypeConvertor.toString(args[0]);
			String sysTopic = "";
			if (args.length > 1){
				sysTopic = TypeConvertor.toString(args[1]);
			}
			if(sysTopic != null && sysTopic.length() > 0){
				context.setSysTopic(sysTopic);
			}
			return MapMidUtil.midMapData(context, mapKey);
		}

	}

	/**
	 * 对于数据的状态改变检查
	 * <ul>
	 * <li>statusKey 单据的状态
	 * </ul>
	 * 
	 * @author 刘翔翔
	 *
	 */
	class MapStatusCheckImpl extends BaseMidFunctionImpl {
		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor) throws Throwable {
			Document doc = context.getDocument();
			if (doc.isNew())
				return true;
			MetaDataObject metaDataObject = context.getDataObject();
			DataTable dataTable = doc.get(metaDataObject.getMainTableKey());
			
			IMetaFactory metaFactory = context.getVE().getMetaFactory();

			if (dataTable != null && dataTable.first()) {
				if (dataTable.getState() != RowState.MODIFIED)
					return true;
				String key = TypeConvertor.toString(args[0]);
				MetaStatus status = MetaUtil.getStatusNotNull(metaFactory,metaDataObject, key);
				Integer statusValue = status.getValue();
				Integer oldValue = (Integer) dataTable.getOriginalObject(SystemField.STATUS_SYS_KEY);
				Integer newValue = (Integer)dataTable.getObject(SystemField.STATUS_SYS_KEY);
				if (newValue < oldValue && newValue <= statusValue) {
					return false;
				}
			}
			return true;
		}

	}

	/**
	 * 删除数据的规则检查
	 * 
	 * @author 刘翔翔
	 *
	 */
	class MapDeleteCheckImpl extends BaseMidFunctionImpl {
		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor) throws Throwable {
			Document doc = context.getDocument();
			if (doc.isNew())
				return true;
			boolean delete=doc.isDelete();
			MetaDataObject metaDataObject = context.getDataObject();

			for (MetaTable table : metaDataObject.getTableCollection()) {
				String key = table.getKey();
				DataTable dataTable = doc.get(key);
				if (dataTable == null || !table.isPersist())
					continue;
				dataTable.beforeFirst();
				while (dataTable.next()) {
					if (delete || dataTable.getState() == RowState.DELETED) {
						Integer count = (Integer)dataTable.getObject(SystemField.MAPCOUNT_SYS_KEY);
						if (count != null && count > 0)
							throw MidCoreException.createException(context.getEnv(), MidCoreException.MAPED_DATA_NO_DELETE, (Long)dataTable.getObject(SystemField.OID_SYS_KEY));
					}
				}
			}
			return true;
		}

	}

	@Override
	public Object[][] getImplTable() {
		return new Object[][] { 
			{ "Map", new MapImpl() }, 
			{ "MapStatusCheck", new MapStatusCheckImpl() }, 
			{ "MapDeleteCheck", new MapDeleteCheckImpl() } };
	}

}
