/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.util;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.io.File;
import java.io.InputStream;

public class MetaResolverUtil {
    private static boolean checkRealPath(String parentPath, String filePath) {
        try {
            if (parentPath != null && !parentPath.isEmpty() && filePath != null && !filePath.isEmpty()) {
                File parentFile = new File(parentPath);
                File realFile = new File(filePath);
                if (parentFile.exists() && realFile.exists()) {
                    String parentRealPath = parentFile.getCanonicalPath().replaceAll("\\\\", "/");
                    String realRealPath = realFile.getCanonicalPath().replaceAll("\\\\", "/");
                    return realRealPath.contains(parentRealPath);
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static InputStream loadResourceInputStream(IMetaFactory metaFactory, String formKey, String filePath) throws Throwable {
        String projectKey = "";
        if (formKey != null && !formKey.isEmpty()) {
            MetaForm metaForm = metaFactory.getMetaForm(formKey);
            projectKey = metaForm.getProjectKey();
        }
        return MetaResolverUtil.loadResourceInputStreamByProject(metaFactory, projectKey, filePath);
    }

    public static InputStream loadResourceInputStreamByProject(IMetaFactory metaFactory, String project, String filePath) throws Throwable {
        String resourcePrefix = "/Resource";
        try {
            filePath = filePath.replaceAll("\\\\", "/");
            if (project != null && !project.isEmpty()) {
                IMetaResolverFactory metaResolverFactory = metaFactory.getMetaResolverFactory(project);
                IMetaResolver metaResolver = metaResolverFactory.newMetaResolver(resourcePrefix);
                InputStream inputStream = MetaResolverUtil.loadResourceInputStreamByResolver(metaResolver, filePath);
                if (inputStream == null) {
                    metaResolver = metaFactory.getMetaResolverFactory().newMetaResolver(resourcePrefix);
                    inputStream = MetaResolverUtil.loadResourceInputStreamByResolver(metaResolver, filePath);
                }
                return inputStream;
            }
            IMetaResolver metaResolver = metaFactory.getMetaResolverFactory().newMetaResolver(resourcePrefix);
            return MetaResolverUtil.loadResourceInputStreamByResolver(metaResolver, filePath);
        }
        catch (UnsupportedOperationException e) {
            return metaFactory.loadResource(filePath, project);
        }
    }

    private static InputStream loadResourceInputStreamByResolver(IMetaResolver metaResolver, String filePath) throws Throwable {
        String fileRealPath;
        String newFilePath = filePath.replaceAll("Resource/", "");
        String parentRealPath = metaResolver.getPath("");
        if (!MetaResolverUtil.checkRealPath(parentRealPath, fileRealPath = metaResolver.getPath(newFilePath))) {
            return null;
        }
        return metaResolver.read(newFilePath, -1);
    }
}

