/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.strings;

import com.bokesoft.yes.i18n.IStringMap;
import com.bokesoft.yes.i18n.XmlStringMapImpl;
import com.bokesoft.yes.meta.persist.dom.strings.MetaStringTableReader;
import com.bokesoft.yes.meta.persist.dom.strings.MetaStringTableSave;
import com.bokesoft.yigo.common.i18n.DefaultLocale;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class MetaStringTable
implements JSONSerializable,
Serializable {
    private Map<String, IStringMap> localeMap = new ConcurrentHashMap<String, IStringMap>();

    public boolean hasLangLoaded(String lang) {
        return this.localeMap.containsKey(lang);
    }

    public void clear() {
        this.localeMap.clear();
    }

    public String getString(ILocale locale, String group, String key) {
        if (locale == null) {
            locale = DefaultLocale.getDefaultLocale();
        }
        String text = null;
        String lang = locale.getLocale();
        IStringMap map = this.localeMap.get(lang);
        if (map == null) {
            return null;
        }
        text = map.getString(group, key);
        return text;
    }

    public String getString(String lang, String group, String key) {
        String text = null;
        IStringMap map = this.localeMap.get(lang);
        if (map == null) {
            return null;
        }
        text = map.getString(group, key);
        return text;
    }

    public void load(String lang, IMetaFactory metaFactory, String project, String formKey) {
        if (!this.localeMap.containsKey(lang)) {
            String resource = "i18n" + File.separator + "Form" + File.separator + formKey + "-" + lang + ".xml";
            IStringMap map = MetaStringTableReader.load(metaFactory, project, resource);
            this.localeMap.put(lang, map);
        }
    }

    public void load(String lang, InputStream in) {
        IStringMap map = MetaStringTableReader.load(in);
        this.localeMap.put(lang, map);
    }

    public boolean containsLang(String lang) {
        return this.localeMap.containsKey(lang);
    }

    public Map<String, IStringMap> getLocaleMap() {
        return this.localeMap;
    }

    public void save(String resource) {
        Set<Map.Entry<String, IStringMap>> set = this.localeMap.entrySet();
        Iterator<Map.Entry<String, IStringMap>> it = set.iterator();
        Map.Entry<String, IStringMap> entry = null;
        while (it.hasNext()) {
            entry = it.next();
            IStringMap value = entry.getValue();
            try {
                XmlStringMapImpl impl = (XmlStringMapImpl)value;
                MetaStringTableSave.save(impl.save(), resource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject o = new JSONObject();
        for (String lang : this.localeMap.keySet()) {
            IStringMap stringMap = this.localeMap.get(lang);
            o.put(lang, (Object)stringMap.toJSON());
        }
        return o;
    }

    public void fromJSON(JSONObject o) throws Throwable {
        Iterator keySet = o.keys();
        while (keySet.hasNext()) {
            String lang = (String)keySet.next();
            JSONObject obj = o.optJSONObject(lang);
            XmlStringMapImpl impl = new XmlStringMapImpl();
            impl.fromJSON(obj);
            this.localeMap.put(lang, (IStringMap)impl);
        }
    }
}

