/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.grid;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.grid.IMetaGridRowObject;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class MetaGridRowGroup
extends AbstractMetaObject
implements IMetaGridRowObject {
    private ArrayList<IMetaGridRowObject> objectArray = null;
    private int topRow = -1;
    private int bottomRow = -1;
    private String groupKey = null;
    private boolean leaf = false;
    private int headCount = 0;
    private int tailCount = 0;
    public static final String TAG_NAME = "RowGroup";

    public MetaGridRowGroup(String groupKey) {
        this.groupKey = groupKey;
        this.objectArray = new ArrayList();
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        return null;
    }

    @Override
    public int getObjectType() {
        return 1;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public void addObject(IMetaGridRowObject row) {
        this.objectArray.add(row);
    }

    public void addRow(MetaGridRow metaRow) {
        if (metaRow.isGroupHead()) {
            this.objectArray.add(this.headCount++, metaRow);
        } else {
            this.objectArray.add(metaRow);
        }
    }

    @Override
    public int getObjectCount() {
        return this.objectArray.size();
    }

    @Override
    public IMetaGridRowObject getObject(int index) {
        return this.objectArray.get(index);
    }

    public boolean contains(IMetaGridRowObject obj) {
        return this.objectArray.contains(obj);
    }

    public void remove(int index) {
        this.objectArray.remove(index);
    }

    public void addObject(int index, IMetaGridRowObject obj) {
        this.objectArray.add(index, obj);
    }

    public void setObject(int index, IMetaGridRowObject row) {
        this.objectArray.set(index, row);
    }

    public Iterator<IMetaGridRowObject> iterator() {
        return this.objectArray.iterator();
    }

    public void setTopRow(int topRow) {
        this.topRow = topRow;
    }

    public int getTopRow() {
        return this.topRow;
    }

    public void setBottomRow(int bottomRow) {
        this.bottomRow = bottomRow;
    }

    public int getBottomRow() {
        return this.bottomRow;
    }

    public boolean isInRange(int index) {
        return index >= this.topRow && index <= this.bottomRow;
    }

    @Override
    public void printDebugInfo(int level) {
        LogSvr.getInstance().info("group\t" + level + "");
        Iterator<IMetaGridRowObject> it = this.objectArray.iterator();
        IMetaGridRowObject rowObject = null;
        while (it.hasNext()) {
            rowObject = it.next();
            rowObject.printDebugInfo(level + 1);
        }
    }

    @Override
    public AbstractMetaObject clone() {
        MetaGridRowGroup rowGroup = (MetaGridRowGroup)this.newInstance();
        Iterator<IMetaGridRowObject> it = this.objectArray.iterator();
        AbstractMetaObject obj = null;
        while (it.hasNext()) {
            obj = (AbstractMetaObject)((Object)it.next());
            rowGroup.addObject((IMetaGridRowObject)((Object)obj.clone()));
        }
        return rowGroup;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaGridRowGroup(this.groupKey);
    }

    @Override
    public void getAll(int objectType, ArrayList<IMetaGridRowObject> list) {
        Iterator<IMetaGridRowObject> it = this.objectArray.iterator();
        IMetaGridRowObject rowObject = null;
        while (it.hasNext()) {
            rowObject = it.next();
            if (rowObject.getObjectType() == objectType) {
                list.add(rowObject);
            }
            rowObject.getAll(objectType, list);
        }
    }
}

