/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.flatcanvas.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.node.AbstractMetaFCNode;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCFont;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observer;
import org.w3c.dom.Element;

public class MetaFCText
extends AbstractMetaFCNode {
    public static final String TAG_NAME = "Text";
    private MetaFCFont font = null;
    private static final List<String> ATTRS_TEXT = Arrays.asList("x", "y", "text", "fill");

    public MetaFCText() {
        this.font = new MetaFCFont();
    }

    public MetaFCText(int x, int y) {
        this.setX(x);
        this.setY(y);
        this.font = new MetaFCFont();
    }

    public String getFill() {
        return StringUtil.isBlankOrNull((String)this.get("fill")) ? "#000000" : this.get("fill");
    }

    public String getFontName() {
        return this.font.getName();
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    public String getFontStyle() {
        return this.font.getStyle();
    }

    public String getFontWeight() {
        return this.font.get("font-weight");
    }

    public String getText() {
        return this.get("text");
    }

    public void setText(String text) {
        this.set("text", text);
    }

    @Override
    public void addAttrObserver(Observer observer) {
        super.addAttrObserver(observer);
        this.font.addAttrObserver(observer);
    }

    @Override
    protected void loadChild(Element elem) {
        if (elem.getElementsByTagName("Font") != null) {
            Element child = (Element)elem.getElementsByTagName("Font").item(0);
            this.font.loadFromElement(child);
        }
    }

    @Override
    public List<String> getPropItemKeys() {
        return ATTRS_TEXT;
    }

    @Override
    public List<AttributeItem> getPropItems() {
        ArrayList<AttributeItem> items = new ArrayList<AttributeItem>();
        List<AttributeItem> sectionPropItems = super.getPropItems();
        for (AttributeItem item : sectionPropItems) {
            items.add(item);
        }
        List<AttributeItem> fontPropItems = this.font.getPropItems();
        for (AttributeItem item : fontPropItems) {
            items.add(item);
        }
        return items;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected boolean isCollection() {
        return false;
    }

    @Override
    protected boolean saveChild(IContentHandler saveHandler, INode node) {
        return this.font.saveTo(saveHandler, node);
    }
}

