/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.exceltemplate;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumns;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRows;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MetaExcelSheet
extends AbstractMetaObject {
    public static final String TAG_NAME = "Sheet";
    private String name = "";
    private MetaExcelRows rows = null;
    private MetaExcelColumns columns = null;

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        this.addAll2(list, this.rows, this.columns);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        if (tagName.equalsIgnoreCase("Rows")) {
            this.rows = new MetaExcelRows();
            return this.rows;
        }
        if (tagName.equalsIgnoreCase("Columns")) {
            this.columns = new MetaExcelColumns();
            return this.columns;
        }
        throw new MetaException(1, "No action defined for " + tagName);
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaExcelSheet();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaExcelRows getRows() {
        return this.rows;
    }

    public void setRows(MetaExcelRows rows) {
        this.rows = rows;
    }

    public void setColumns(MetaExcelColumns columns) {
        this.columns = columns;
    }

    public MetaExcelColumns getColumns() {
        return this.columns;
    }

    public List<String> getTableKeyList() {
        String tableKey = null;
        ArrayList<String> tableKeys = new ArrayList<String>();
        for (MetaExcelRow row : this.getRows()) {
            tableKey = row.getTableKey();
            if (!StringUtil.isBlankOrNull((String)tableKey) && !tableKeys.contains(tableKey)) {
                tableKeys.add(tableKey);
                continue;
            }
            for (MetaExcelCell cell : row.getList()) {
                tableKey = cell.getTableKey();
                if (StringUtil.isBlankOrNull((String)tableKey) || tableKeys.contains(tableKey)) continue;
                tableKeys.add(tableKey);
            }
        }
        return tableKeys;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaExcelSheet newExcelSheet = new MetaExcelSheet();
        newExcelSheet.setName(this.name);
        newExcelSheet.setRows(this.rows == null ? null : (MetaExcelRows)this.rows.clone());
        newExcelSheet.setColumns(this.columns == null ? null : (MetaExcelColumns)this.columns.clone());
        return newExcelSheet;
    }

    public void clear() {
        if (this.rows != null) {
            this.rows.clear();
        }
        if (this.columns != null) {
            this.columns.clear();
        }
    }
}

