/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.datamap;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.datamap.calculate.MetaMapParas;
import com.bokesoft.yigo.meta.datamap.diagram.MetaFeedbackCollection;
import com.bokesoft.yigo.meta.datamap.error.MetaDataMapErrorInfoCollection;
import com.bokesoft.yigo.meta.datamap.relatedatamap.MetaRelateDataMapCollection;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTableCollection;
import com.bokesoft.yigo.meta.datamap.split.MetaSplit;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetField;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTable;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import java.util.LinkedList;

public class MetaMap
extends KeyPairMetaObject {
    public static final String TAG_NAME = "Map";
    private String key = "";
    private String caption = "";
    private String description = "";
    private String srcDataObjectKey = "";
    private String tgtDataObjectKey = "";
    private Boolean mapRelationValue = true;
    private String remainderPushValue = "";
    private String maxPushValue = "";
    private String minPushValue = "";
    private Boolean allowSurplus = false;
    private Boolean allowRemainderPush = true;
    private String mapCondition = "";
    private MetaBaseScript postProcess = null;
    private MetaRelateDataMapCollection relateDataMapCollection = null;
    private MetaSourceTableCollection sourceTableCollection = null;
    private MetaTargetTableCollection targetTableCollection = null;
    private MetaFeedbackCollection feedbackCollection = null;
    private MetaMapParas dataMapParas = null;
    private MetaSplit mapSplit = null;
    private Boolean pullDataOnly = false;
    private Boolean markMapCount = true;
    private IMetaProject project = null;
    private MetaDataMapErrorInfoCollection errorInfoCollection = null;

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        this.addAll(list, new AbstractMetaObject[]{this.postProcess, this.relateDataMapCollection, this.sourceTableCollection, this.targetTableCollection, this.feedbackCollection, this.mapSplit, this.errorInfoCollection});
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject child = null;
        if ("SourceTableCollection".equals(tagName)) {
            child = this.sourceTableCollection = new MetaSourceTableCollection();
        } else if ("TargetTableCollection".equals(tagName)) {
            this.targetTableCollection = new MetaTargetTableCollection();
            child = this.targetTableCollection;
        } else if ("FeedbackCollection".equals(tagName)) {
            this.feedbackCollection = new MetaFeedbackCollection();
            child = this.feedbackCollection;
        } else if ("RelateDataMapCollection".equals(tagName)) {
            this.relateDataMapCollection = new MetaRelateDataMapCollection();
            child = this.relateDataMapCollection;
        } else if ("Split".equals(tagName)) {
            this.mapSplit = new MetaSplit();
            child = this.mapSplit;
        } else if ("PostProcess".equals(tagName)) {
            this.postProcess = new MetaBaseScript("PostProcess");
            child = this.postProcess;
        } else if ("ErrorInfoCollection".equals(tagName)) {
            this.errorInfoCollection = new MetaDataMapErrorInfoCollection();
            child = this.errorInfoCollection;
        }
        if (child != null) {
            child.preProcessMetaObject(env, doc, node, flag, runType);
        }
        return child;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaMap newMetaMap = new MetaMap();
        newMetaMap.setKey(this.key);
        newMetaMap.setCaption(this.caption);
        newMetaMap.setDescription(this.description);
        newMetaMap.setSrcDataObjectKey(this.srcDataObjectKey);
        newMetaMap.setTgtDataObjectKey(this.tgtDataObjectKey);
        newMetaMap.setMapRelationValue(this.mapRelationValue);
        newMetaMap.setMaxPushValue(this.maxPushValue);
        newMetaMap.setMinPushValue(this.minPushValue);
        newMetaMap.setAllowSurplus(this.allowSurplus);
        newMetaMap.setRemainderPushValue(this.remainderPushValue);
        newMetaMap.setAllowRemainderPush(this.allowRemainderPush);
        newMetaMap.setMapCondition(this.mapCondition);
        newMetaMap.setRelateDataMapCollection(this.relateDataMapCollection == null ? null : (MetaRelateDataMapCollection)this.relateDataMapCollection.clone());
        newMetaMap.setSourceTableCollection(this.sourceTableCollection == null ? null : (MetaSourceTableCollection)this.sourceTableCollection.clone());
        newMetaMap.setTargetTableCollection(this.targetTableCollection == null ? null : (MetaTargetTableCollection)this.targetTableCollection.clone());
        newMetaMap.setFeedbackCollection(this.feedbackCollection == null ? null : (MetaFeedbackCollection)this.feedbackCollection.clone());
        newMetaMap.setSplit(this.mapSplit == null ? null : (MetaSplit)this.mapSplit.clone());
        newMetaMap.setPostProcess(this.postProcess);
        newMetaMap.setErrorInfoCollection(this.errorInfoCollection == null ? null : (MetaDataMapErrorInfoCollection)this.errorInfoCollection.clone());
        return newMetaMap;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaMap();
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSrcDataObjectKey() {
        return this.srcDataObjectKey;
    }

    public void setSrcDataObjectKey(String srcDataObjectKey) {
        this.srcDataObjectKey = srcDataObjectKey;
    }

    public String getTgtDataObjectKey() {
        return this.tgtDataObjectKey;
    }

    public void setTgtDataObjectKey(String tgtDataObjectKey) {
        this.tgtDataObjectKey = tgtDataObjectKey;
    }

    public String getMaxPushValue() {
        return this.maxPushValue;
    }

    public void setMaxPushValue(String maxPushValue) {
        this.maxPushValue = maxPushValue;
    }

    public MetaSourceTableCollection getSourceTableCollection() {
        return this.sourceTableCollection;
    }

    public void setSourceTableCollection(MetaSourceTableCollection sourceTableCollection) {
        this.sourceTableCollection = sourceTableCollection;
    }

    public void setTargetTableCollection(MetaTargetTableCollection targetTableCollection) {
        this.targetTableCollection = targetTableCollection;
    }

    public MetaTargetTableCollection getTargetTableCollection() {
        return this.targetTableCollection;
    }

    public MetaFeedbackCollection getFeedbackCollection() {
        return this.feedbackCollection;
    }

    public void setFeedbackCollection(MetaFeedbackCollection feedbackCollection) {
        this.feedbackCollection = feedbackCollection;
    }

    public MetaSplit getSplit() {
        return this.mapSplit;
    }

    public void setSplit(MetaSplit metaSplit) {
        this.mapSplit = metaSplit;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaMapParas getDataMapParas(IMetaFactory factory) throws Throwable {
        if (this.dataMapParas == null) {
            MetaMap metaMap = this;
            synchronized (metaMap) {
                if (this.dataMapParas == null) {
                    this.dataMapParas = new MetaMapParas(this, factory);
                }
            }
        }
        return this.dataMapParas;
    }

    public boolean isMapTargetField(String tableKey, String columnKey) throws Throwable {
        MetaTargetTable targetTable = (MetaTargetTable)this.targetTableCollection.get(tableKey);
        if (targetTable == null) {
            return false;
        }
        for (MetaTargetField field : targetTable) {
            if (!field.getDefinition().equals(columnKey) && !(field.getDefinition() + "_CF").equals(columnKey)) continue;
            return true;
        }
        return false;
    }

    public boolean midMap() {
        return this.postProcess != null && this.postProcess.getContent().length() > 0;
    }

    public MetaSourceTable getSourceTable(String key) {
        return (MetaSourceTable)this.sourceTableCollection.get(key);
    }

    public String getMinPushValue() {
        return this.minPushValue;
    }

    public void setMinPushValue(String minPushValue) {
        this.minPushValue = minPushValue;
    }

    public Boolean isMarkMapCount() {
        return this.markMapCount;
    }

    public void setMarkMapCount(Boolean markMapCount) {
        this.markMapCount = markMapCount;
    }

    public Boolean isPullDataOnly() {
        return this.pullDataOnly;
    }

    public void setPullDataOnly(Boolean pullDataOnly) {
        this.pullDataOnly = pullDataOnly;
    }

    public Boolean getAllowSurplus() {
        return this.allowSurplus;
    }

    public MetaRelateDataMapCollection getRelateDataMapColletion() {
        return this.relateDataMapCollection;
    }

    public void setRelateDataMapCollection(MetaRelateDataMapCollection relateDataMapCollection) {
        this.relateDataMapCollection = relateDataMapCollection;
    }

    public void setAllowSurplus(Boolean allowSurplus) {
        this.allowSurplus = allowSurplus;
    }

    public String getMapCondition() {
        return this.mapCondition;
    }

    public void setMapCondition(String mapCondition) {
        this.mapCondition = mapCondition;
    }

    public MetaBaseScript getPostProcess() {
        return this.postProcess;
    }

    public void setPostProcess(MetaBaseScript postProcess) {
        this.postProcess = postProcess;
    }

    public String getRemainderPushValue() {
        return this.remainderPushValue;
    }

    public void setRemainderPushValue(String remainderPushValue) {
        this.remainderPushValue = remainderPushValue;
    }

    public Boolean getAllowRemainderPush() {
        return this.allowRemainderPush;
    }

    public void setAllowRemainderPush(Boolean allowRemainderPush) {
        this.allowRemainderPush = allowRemainderPush;
    }

    public Boolean getMapRelationValue() {
        return this.mapRelationValue;
    }

    public void setMapRelationValue(Boolean mapRelationValue) {
        this.mapRelationValue = mapRelationValue;
    }

    public IMetaProject getProject() {
        return this.project;
    }

    public void setProject(IMetaProject project) {
        this.project = project;
    }

    public MetaDataMapErrorInfoCollection getErrorInfoCollection() {
        return this.errorInfoCollection;
    }

    public void setErrorInfoCollection(MetaDataMapErrorInfoCollection errorInfoCollection) {
        this.errorInfoCollection = errorInfoCollection;
    }
}

