/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.base;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class GenericNoKeyCollection<T extends AbstractMetaObject>
extends AbstractMetaObject
implements Iterable<T> {
    protected List<T> elementArray = new CopyOnWriteArrayList<T>();

    public boolean empty() {
        return this.elementArray.isEmpty();
    }

    public void add(T element) {
        this.elementArray.add(element);
    }

    public void remove(T element) {
        this.elementArray.remove(element);
    }

    public void remove(int index) {
        this.elementArray.remove(index);
    }

    public void removeAll(Collection<T> elements) {
        this.elementArray.removeAll(elements);
    }

    public int size() {
        if (this.elementArray == null) {
            return 0;
        }
        return this.elementArray.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public T get(int index) {
        return (T)((AbstractMetaObject)this.elementArray.get(index));
    }

    public int indexOf(T t) {
        if (this.elementArray == null) {
            return -1;
        }
        return this.elementArray.indexOf(t);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elementArray.iterator();
    }

    public void add(int index, T element) {
        this.elementArray.add(index, element);
    }

    public T set(int index, T element) {
        return (T)((AbstractMetaObject)this.elementArray.set(index, element));
    }

    public void addAll(int index, Collection<? extends T> c) {
        this.elementArray.addAll(index, c);
    }

    public void remove(int from, int to) {
        for (int i = to; i >= from; --i) {
            this.elementArray.remove(i);
        }
    }

    public void clear() {
        this.elementArray.clear();
    }

    @Override
    public void traversalCollectionObjects(IMetaEnv env, Object doc, Object node, Object flag, int runType) throws MetaException {
        Iterator<T> itElement = this.elementArray.iterator();
        AbstractMetaObject element = null;
        while (itElement.hasNext()) {
            element = (AbstractMetaObject)itElement.next();
            if (element.isAutoGen()) continue;
            Object childNode = env.prepare(element, node);
            element.traversal(env, doc, childNode, flag, runType);
        }
    }

    @Override
    public AbstractMetaObject clone() {
        GenericNoKeyCollection newObject = (GenericNoKeyCollection)this.newInstance();
        Iterator<T> itElement = this.elementArray.iterator();
        AbstractMetaObject element = null;
        while (itElement.hasNext()) {
            element = (AbstractMetaObject)itElement.next();
            newObject.add(element.clone());
        }
        return newObject;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        Iterator<T> itElement = this.elementArray.iterator();
        AbstractMetaObject element = null;
        while (itElement.hasNext()) {
            element = (AbstractMetaObject)itElement.next();
            element.doPostProcess(flag, callback);
        }
    }

    @Override
    public void forEach(Consumer<? super T> action) {
    }

    @Override
    public Spliterator<T> spliterator() {
        return null;
    }

    public void sort(Comparator<T> c) {
        this.elementArray.sort(c);
    }

    public List<T> getList() {
        return this.elementArray;
    }
}

