/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.process;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class MetaFormExtendProcess {
    private IMetaFactory metaFactory;
    private MetaForm metaForm;
    private MetaForm extForm;
    private StringHashMap<MetaComponent> comsMap = null;

    public MetaFormExtendProcess(IMetaFactory metaFactory, MetaForm metaForm) {
        this.metaFactory = metaFactory;
        this.metaForm = metaForm;
        this.comsMap = StringHashMap.newInstance();
    }

    private void buildMap() {
        MetaBody metaBody = this.metaForm.getMetaBody();
        Stack<Object> stack = new Stack<Object>();
        int size = metaBody.size();
        for (int i = 0; i < size; ++i) {
            stack.push(metaBody.get(i));
        }
        MetaComponent com = null;
        while (!stack.isEmpty()) {
            com = (MetaComponent)stack.pop();
            this.comsMap.put((Object)com.getKey(), (Object)com);
            int size2 = com.getComponentCount();
            for (int i = 0; i < size2; ++i) {
                stack.add(com.getComponent(i));
            }
        }
    }

    public void process() throws Throwable {
        String extend = this.metaForm.getExtend();
        if (extend == null || extend.isEmpty()) {
            return;
        }
        this.buildMap();
        this.extForm = this.metaFactory.getMetaForm(extend);
        this.processNewExtField();
        this.processComponents();
        this.processMacroCollection();
        this.processQueryCollection();
        this.processParaCollection();
        this.processScriptCollection();
        this.processUICheckCollection();
        this.metaForm.merge(this.extForm);
    }

    public void process(MetaForm parentForm) throws Throwable {
        this.buildMap();
        this.extForm = parentForm;
        this.processNewExtField();
        this.processComponents();
        this.processMacroCollection();
        this.processQueryCollection();
        this.processParaCollection();
        this.processScriptCollection();
        this.processUICheckCollection();
        this.metaForm.merge(this.extForm);
    }

    private void processComponents() throws Exception {
        List<MetaComponent> extComs = this.extForm.getAllComponents();
        Iterator<MetaComponent> it = extComs.iterator();
        MetaComponent metaCom = null;
        MetaComponent extCom = null;
        MetaComponent cloneCom = null;
        MetaBlock block = this.metaForm.getPrimaryBlock();
        MetaPanel root = (MetaPanel)block.getRoot();
        block4: while (it.hasNext()) {
            extCom = it.next();
            metaCom = (MetaComponent)this.comsMap.get((Object)extCom.getKey());
            if (metaCom != null) {
                if (metaCom.getControlType() != extCom.getControlType()) {
                    throw new MetaException(81, SimpleStringFormat.format((String)StringTable.getString(null, "", "ControlTypeDoesNotMatch"), (Object[])new Object[]{this.metaForm.getKey()}));
                }
                switch (metaCom.getControlType()) {
                    case 217: {
                        this.processGrid((MetaGrid)metaCom, (MetaGrid)extCom);
                        continue block4;
                    }
                    case 216: {
                        this.processListView((MetaListView)metaCom, (MetaListView)extCom);
                        continue block4;
                    }
                }
                metaCom.merge(extCom);
                continue;
            }
            if (extCom.isPanel() || extCom instanceof MetaSubDetail && ((MetaSubDetail)extCom).getRoot() instanceof MetaGrid || extCom instanceof MetaSubDetail && ((MetaSubDetail)extCom).getRoot() instanceof MetaGridLayoutPanel || this.metaForm.getAllUIComponents().containsKey(extCom.getKey())) continue;
            cloneCom = (MetaComponent)extCom.depthClone();
            cloneCom.setExtend(true);
            cloneCom.setVisible("false");
            root.addComponent(cloneCom);
        }
    }

    private void processNewExtField() {
        List<MetaComponent> metaComs = this.metaForm.getAllComponents();
        this.comsMap.forEach((key, metaCom) -> {
            if (!(this.extForm.componentByKey((String)key) != null || metaCom.isPanel() || metaCom instanceof MetaSubDetail && ((MetaSubDetail)metaCom).getRoot() instanceof MetaGrid || metaCom instanceof MetaSubDetail && ((MetaSubDetail)metaCom).getRoot() instanceof MetaGridLayoutPanel)) {
                metaCom.setNewExtField(true);
            }
        });
    }

    private void processListView(MetaListView metaListView, MetaListView extListView) {
        metaListView.merge(extListView);
        MetaListViewColumnCollection lvc = metaListView.getColumnCollection();
        MetaListViewColumnCollection elvc = extListView.getColumnCollection();
        Iterator it = lvc.iterator();
        MetaListViewColumn lvColumn = null;
        MetaListViewColumn extColumn = null;
        while (it.hasNext()) {
            lvColumn = (MetaListViewColumn)it.next();
            extColumn = (MetaListViewColumn)elvc.get(lvColumn.getKey());
            if (extColumn != null) {
                lvColumn.merge(extColumn);
                continue;
            }
            lvColumn.merge(new MetaListViewColumn());
        }
    }

    private void processGrid(MetaGrid metaGrid, MetaGrid extGrid) {
        metaGrid.merge(extGrid);
    }

    private void processMacroCollection() {
        MetaMacroCollection mac1 = this.metaForm.getMacroCollection();
        MetaMacroCollection mac2 = this.extForm.getMacroCollection();
        MetaMacroCollection mac3 = null;
        if (mac2 != null) {
            if (mac1 != null) {
                Iterator it = mac2.iterator();
                MetaMacro macro = null;
                MetaMacro macro1 = null;
                while (it.hasNext()) {
                    macro = (MetaMacro)it.next();
                    macro1 = (MetaMacro)mac1.get(macro.getKey());
                    if (macro1 != null) {
                        macro1.merge(macro);
                        continue;
                    }
                    mac1.add((MetaMacro)macro.clone());
                }
                mac3 = mac1;
            } else {
                mac3 = (MetaMacroCollection)mac2.clone();
            }
            this.metaForm.setMacroCollection(mac3);
        }
    }

    private void processQueryCollection() {
        MetaQueryCollection qc1 = this.metaForm.getQueryCollection();
        MetaQueryCollection qc2 = this.extForm.getQueryCollection();
        MetaQueryCollection qc = null;
        if (qc2 != null) {
            if (qc1 != null) {
                Iterator it = qc2.iterator();
                MetaQuery query = null;
                MetaQuery query2 = null;
                while (it.hasNext()) {
                    query = (MetaQuery)it.next();
                    query2 = (MetaQuery)qc1.get(query.getKey());
                    if (query2 != null) {
                        query2.merge(query);
                        continue;
                    }
                    qc1.add((MetaQuery)query.clone());
                }
                qc = qc1;
            } else {
                qc = (MetaQueryCollection)qc2.clone();
            }
            this.metaForm.setQueryCollection(qc);
        }
    }

    private void processParaCollection() throws Throwable {
        MetaFormParaCollection pc1 = this.metaForm.getFormParaCollection();
        MetaFormParaCollection pc2 = this.extForm.getFormParaCollection();
        MetaFormParaCollection pc3 = null;
        if (pc2 != null) {
            if (pc1 != null) {
                Iterator it = pc2.iterator();
                MetaFormPara p1 = null;
                MetaFormPara p2 = null;
                while (it.hasNext()) {
                    p1 = (MetaFormPara)it.next();
                    p2 = pc1.get(p1.getKey());
                    if (p2 != null) {
                        p2.merge(p1);
                        continue;
                    }
                    pc1.add((MetaFormPara)p1.clone());
                }
                pc3 = pc1;
            } else {
                pc3 = (MetaFormParaCollection)pc2.clone();
            }
            this.metaForm.setFormParaCollection(pc3);
        }
    }

    private void processScriptCollection() throws Throwable {
        MetaScriptCollection sc1 = this.metaForm.getScriptCollection();
        MetaScriptCollection sc2 = this.extForm.getScriptCollection();
        MetaScript sc = null;
        if (sc2 != null) {
            MetaScript load = sc2.getLoad();
            MetaScript save = sc2.getSave();
            if (sc1 != null) {
                if (load != null) {
                    sc = sc1.getLoad();
                    if (sc != null) {
                        sc.merge(load);
                    } else {
                        sc1.setLoad((MetaScript)load.clone());
                    }
                }
                if (save != null) {
                    sc = sc1.getSave();
                    if (sc != null) {
                        sc.merge(save);
                    } else {
                        sc1.setSave((MetaScript)save.clone());
                    }
                }
            } else {
                this.metaForm.setScriptCollection((MetaScriptCollection)sc2.clone());
            }
        }
    }

    private void processUICheckCollection() throws Throwable {
        MetaUICheckRuleCollection co2;
        MetaUICheckRuleCollection co = this.metaForm.getUICheckRuleCollection();
        if (co == null && (co2 = this.extForm.getUICheckRuleCollection()) != null) {
            this.metaForm.setUICheckRuleCollection((MetaUICheckRuleCollection)co2.clone());
        }
    }
}

