/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.parse;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Element;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Ignorer;
import com.bokesoft.yes.meta.persist.dom.xml.parse.PrivateUtil;
import java.util.ArrayList;
import java.util.List;

public class Util {
    public static int getBeginIndex(String xml) {
        return Ignorer.getXmlBeginIndex(xml);
    }

    public static String deleteXmlHead(String xml) {
        if (xml == null) {
            return null;
        }
        int c = Util.getBeginIndex(xml);
        if (c > 0) {
            return xml.substring(c);
        }
        return xml;
    }

    public static List<Element> getElements(String xml) {
        if (xml == null) {
            return null;
        }
        xml = Util.deleteXmlHead(xml);
        ArrayList<Element> list = new ArrayList<Element>();
        int ix = 0;
        int maxIndex = xml.length();
        while (ix < maxIndex) {
            Element ele = Util.getNextElement(xml, ix);
            list.add(ele);
            ix = ele.endIndex + 1;
        }
        return list;
    }

    public static Element getNextElement(String xml, int bg) {
        for (int i = bg; i < xml.length(); ++i) {
            char c = xml.charAt(i);
            if (c != '<') continue;
            if (i != bg) {
                Element ele = new Element();
                ele.bgIndex = bg;
                ele.type = 1;
                ele.text = xml.substring(bg, i);
                ele.endIndex = i - 1;
                return ele;
            }
            if (StringUtil.isString((String)xml, (String)"</", (int)i)) {
                return PrivateUtil.getEndTag(xml, i);
            }
            if (StringUtil.isString((String)xml, (String)"<!--", (int)i)) {
                return PrivateUtil.getComment(xml, i);
            }
            if (StringUtil.isString((String)xml, (String)"<![CDATA[", (int)i)) {
                return PrivateUtil.getCDATA(xml, i);
            }
            if (StringUtil.isString((String)xml, (String)"<!DOCTYPE", (int)i)) {
                return PrivateUtil.getDTD(xml, i);
            }
            return PrivateUtil.getStartTag(xml, i);
        }
        Element ele = new Element();
        ele.bgIndex = bg;
        ele.type = 1;
        ele.endIndex = xml.length() - 1;
        ele.text = xml.substring(bg);
        return ele;
    }

    public String deleteNotUse(String xml) {
        return xml;
    }
}

