/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.ex.XmlSyntaxException;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CDataNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CommentNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.DTDNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TextNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Element;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Util;
import java.util.ArrayList;
import java.util.List;

public class XmlParser {
    private static boolean useComment = true;

    public static void setUseComment(boolean bool) {
        useComment = bool;
    }

    public static XmlTree parse(String xml) {
        return XmlParser.parse(xml, false);
    }

    public static XmlTree parse(String xml, boolean trimText) {
        Element endEle;
        List<Element> list = Util.getElements(xml);
        if (list == null || list.size() == 0) {
            return null;
        }
        int idx = -1;
        ArrayList<AbstractNode> listPreComment = new ArrayList<AbstractNode>();
        ArrayList<AbstractNode> listLastComment = new ArrayList<AbstractNode>();
        for (int i = 0; i < list.size(); ++i) {
            Element e = list.get(i);
            if (e.type == 4) continue;
            if (e.type == 2) {
                listPreComment.add(new CommentNode(e.text));
                continue;
            }
            if (e.type == 1) {
                if (StringUtil.isEmptyStr((String)e.text)) continue;
                throw new XmlSyntaxException("\u6807\u7b7e\u5f00\u59cb\u4e4b\u524d\u4e0d\u80fd\u6709\u6587\u672c[" + e.text.trim() + "]");
            }
            if (e.type == 0) {
                idx = i;
                break;
            }
            throw new XmlSyntaxException("\u6807\u7b7e\u5f00\u59cb\u4e4b\u524d\u4e0d\u80fd\u6709CDATA[" + e.text.trim() + "]");
        }
        if (idx == -1) {
            return null;
        }
        XmlTree tree = new XmlTree();
        TagNode node = new TagNode();
        tree.setRoot(node);
        Element ele = list.get(idx);
        node.setTagName(ele.tagName);
        if (ele.attrs != null) {
            node.setAttributes(ele.attrs);
        }
        if ((endEle = XmlParser.getEndTagElement(list, idx, ele, node, trimText)) == null) {
            throw new XmlSyntaxException("root: <" + ele.tagName + "> \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684endTag");
        }
        for (int i = endEle.indexInTheList + 1; i < list.size(); ++i) {
            Element e = list.get(i);
            if (e.type == 2) {
                listLastComment.add(new CommentNode(e.text));
            }
            if (e.type == 0) {
                throw new XmlSyntaxException("root: </" + ele.tagName + "> \u6839\u6807\u7b7e\u7684\u540e\u9762\u4e0d\u80fd\u518d\u6709\u6570\u636e<" + e.tagName + ">");
            }
            if (e.type == 3) {
                throw new XmlSyntaxException("root: </" + ele.tagName + "> \u6839\u6807\u7b7e\u7684\u540e\u9762\u4e0d\u80fd\u518d\u6709\u6570\u636eCDATA[" + e.text + "]");
            }
            if (e.type != 1 || StringUtil.isEmptyStr((String)e.text)) continue;
            throw new XmlSyntaxException("root: </" + ele.tagName + "> \u6839\u6807\u7b7e\u7684\u540e\u9762\u4e0d\u80fd\u518d\u6709\u6570\u636etext[" + e.text.trim() + "]");
        }
        tree.addPreComment(listPreComment);
        tree.addLastComment(listLastComment);
        tree.updateMap();
        return tree;
    }

    private static Element getEndTagElement(List<Element> list, int bg, Element ele, TagNode node, boolean trimText) {
        if (ele.tagType == 3) {
            ele.indexInTheList = bg;
            return ele;
        }
        if (ele.tagType == 2) {
            throw new XmlSyntaxException("\u7ed3\u5c3e\u6807\u7b7e</" + ele.tagName + "> \u4e4b\u524d\u6ca1\u6709\u5f00\u59cb\u6807\u7b7e");
        }
        for (int i = bg + 1; i < list.size(); ++i) {
            Element tem = list.get(i);
            if (tem.type == 1 || tem.type == 2 || tem.type == 3) {
                if (tem.type == 2 && !useComment) continue;
                if (trimText) {
                    String txt = tem.text.trim();
                    if (txt.length() <= 0) continue;
                    node.addNode(XmlParser.makeNotTagNode(txt, tem.type));
                    continue;
                }
                node.addNode(XmlParser.makeNotTagNode(tem.text, tem.type));
                continue;
            }
            if (tem.tagType == 3) {
                node.addNode(XmlParser.makeTagNode(tem));
                continue;
            }
            if (tem.tagType == 2) {
                if (tem.tagName.equals(ele.tagName)) {
                    tem.indexInTheList = i;
                    return tem;
                }
                throw new XmlSyntaxException("endTag </" + tem.tagName + " \u4e4b\u524d\u6ca1\u6709\u5f00\u59cb\u8282\u70b9");
            }
            TagNode newNode = XmlParser.makeTagNode(tem);
            node.addNode(newNode);
            Element newEd = XmlParser.getEndTagElement(list, i, tem, newNode, trimText);
            if (newEd == null) {
                throw new XmlSyntaxException("Tag <" + tem.tagName + "> \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684endTag");
            }
            i = newEd.indexInTheList;
        }
        return null;
    }

    private static TagNode makeTagNode(Element ele) {
        TagNode node = new TagNode();
        node.setTagName(ele.tagName);
        if (ele.attrs != null) {
            node.setAttributes(ele.attrs);
        }
        return node;
    }

    private static AbstractNode makeNotTagNode(String text, int elemType) {
        if (1 == elemType) {
            return new TextNode(text);
        }
        if (2 == elemType) {
            return new CommentNode(text);
        }
        if (3 == elemType) {
            return new CDataNode(text);
        }
        if (4 == elemType) {
            return new DTDNode(text);
        }
        throw new XmlSyntaxException("\u8282\u70b9\u7c7b\u578b:" + elemType + " \u4e0d\u5b58\u5728\uff01");
    }
}

