/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetaUserSVGFileScanLoad
extends BaseMetaScanLoad {
    private int runType = 1;
    private HashMapIgnoreCase<File> userSVGFileMap = null;
    private Map<String, File> map = null;

    public MetaUserSVGFileScanLoad(HashMapIgnoreCase<File> userSVGFileMap, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
        super(resolver, metaProject, DomMetaConstants.FLATCANVAS_USER_FOLD, context);
        this.userSVGFileMap = userSVGFileMap;
        this.runType = runType;
        this.map = new ConcurrentHashMap<String, File>();
    }

    protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMapProfile profile) {
    }

    @Override
    protected void postLoad() throws Throwable {
        super.postLoad();
        this.merge();
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        try {
            File file = new File(this.resolver.getPath(filePath));
            this.map.put(fileName.toLowerCase(), file);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogSvr.getInstance().error(this.resolver.getPath(filePath), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected String getFileFilter() {
        return ".svg";
    }

    public int getRunType() {
        return this.runType;
    }

    private void merge() {
        if (this.map.isEmpty()) {
            return;
        }
        try {
            this.userSVGFileMap.putAll(this.map);
        }
        finally {
            this.map.clear();
        }
    }

    public HashMapIgnoreCase<File> getMetaUserSVGFileMap() {
        this.merge();
        return this.userSVGFileMap;
    }
}

