/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaBPMElementAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineSize;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaSwimlineAction
extends MetaBPMElementAction<MetaSwimline> {
    @Override
    public void load(Document doc, Element node, MetaSwimline meta, int runType) {
        super.load(doc, node, meta, runType);
        meta.setCaption(DomHelper.readAttr((Element)node, (String)"Caption", (String)""));
        meta.setDirection(DomHelper.readAttr((Element)node, (String)"Direction", (String)"Vertical"));
        String positionStr = DomHelper.readAttr((Element)node, (String)"Position", (String)"");
        if (positionStr == null || positionStr.isEmpty()) {
            meta.setPosition(null);
        } else {
            int dotIndex = positionStr.indexOf(",");
            int colonIndex = positionStr.lastIndexOf(":");
            int x = Integer.parseInt(positionStr.substring(2, dotIndex));
            int y = Integer.parseInt(positionStr.substring(colonIndex + 1));
            MetaSwimlinePosition position = new MetaSwimlinePosition(x, y);
            meta.setPosition(position);
        }
        String sizeStr = DomHelper.readAttr((Element)node, (String)"Size", (String)"");
        if (sizeStr == null || sizeStr.isEmpty()) {
            meta.setSize(null);
        } else {
            int dotIndex = sizeStr.indexOf(",");
            int colonIndex = sizeStr.lastIndexOf(":");
            int width = Integer.parseInt(sizeStr.substring(6, dotIndex));
            int height = Integer.parseInt(sizeStr.substring(colonIndex + 1));
            MetaSwimlineSize size = new MetaSwimlineSize(height, width);
            meta.setSize(size);
        }
    }

    @Override
    public void save(Document doc, Element node, MetaSwimline meta, int runType) {
        super.save(doc, node, meta, runType);
        DomHelper.writeAttr((Element)node, (String)"Caption", (String)meta.getCaption(), (String)"");
        DomHelper.writeAttr((Element)node, (String)"Direction", (String)meta.getDirection(), (String)"Vertical");
        MetaSwimlinePosition position = meta.getPosition();
        int x = position == null ? 0 : position.getX();
        int y = position == null ? 0 : position.getY();
        StringBuilder sbPosition = new StringBuilder();
        if (position == null || x == 0 && y == 0) {
            sbPosition.append("");
        } else {
            sbPosition.append("X:").append(x).append(",Y:").append(y);
        }
        DomHelper.writeAttr((Element)node, (String)"Position", (String)sbPosition.toString(), (String)"");
        MetaSwimlineSize size = meta.getSize();
        int width = size == null ? 0 : size.getWidth();
        int height = size == null ? 0 : size.getHeight();
        StringBuilder sbSize = new StringBuilder();
        if (size == null || width == 0 && height == 0) {
            sbSize.append("");
        } else {
            sbSize.append("Width:").append(width).append(",Height:").append(height);
        }
        DomHelper.writeAttr((Element)node, (String)"Size", (String)sbSize.toString(), (String)"");
    }
}

