/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.dataobject;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumnCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import java.util.ArrayList;

public class SchemaCreator {
    private MetaDataObject dataObject = null;

    public SchemaCreator(MetaDataObject dataObject) {
        this.dataObject = dataObject;
    }

    public String getKeysMigrationMainTableName() {
        int secondaryType = this.dataObject.getSecondaryType();
        MetaTable mainTable = this.dataObject.getMainTable();
        if (mainTable == null) {
            return null;
        }
        if (secondaryType == 6 && this.dataObject.getMigrationUpdateStrategy() == 5) {
            return mainTable.getBindingDBTableName();
        }
        return null;
    }

    public MetaDataObject getKeysMigrationDataObject() {
        int secondaryType = this.dataObject.getSecondaryType();
        MetaTable mainTable = this.dataObject.getMainTable();
        if (mainTable == null) {
            return null;
        }
        if (secondaryType == 6 && this.dataObject.getMigrationUpdateStrategy() == 5) {
            return this.dataObject;
        }
        return null;
    }

    public ArrayList<MetaSchemaTable> getSchemeTableList() {
        MetaTable mainMetaTable;
        int secondaryType = this.dataObject.getSecondaryType();
        ArrayList<MetaSchemaTable> tableList = new ArrayList<MetaSchemaTable>();
        MetaTable mainTable = this.dataObject.getMainTable();
        if (secondaryType == 6) {
            if (mainTable != null) {
                if (this.dataObject.getMigrationUpdateStrategy() != 5) {
                    MetaTable deltaTable;
                    tableList.add(SchemaCreator.newSchemeTable(mainTable, true, false, this.dataObject.isAutoGen()));
                    MetaTable lpTable = this.dataObject.getMigrationLastPointTable();
                    if (lpTable != null) {
                        tableList.add(SchemaCreator.newSchemeTable(lpTable, true, false, this.dataObject.isAutoGen()));
                    }
                    if ((deltaTable = this.dataObject.getMigrationDeltaTable()) != null) {
                        tableList.add(SchemaCreator.newSchemeTable(deltaTable, false, false, this.dataObject.isAutoGen()));
                    }
                } else {
                    MetaTable keysPreTable;
                    MetaTable mainTableNewPreTable;
                    MetaTable lpTable;
                    MetaTable mainTableNewTable;
                    MetaTable incrTable;
                    MetaTable keysTable = this.dataObject.getErpMigrationKeysTable();
                    if (null != keysTable) {
                        tableList.add(SchemaCreator.newSchemeTable(keysTable, true, false, this.dataObject.isAutoGen()));
                    }
                    if (null != (incrTable = this.dataObject.getErpMigrationIncrTable())) {
                        tableList.add(SchemaCreator.newSchemeTable(incrTable, false, false, this.dataObject.isAutoGen()));
                    }
                    if (null != (mainTableNewTable = this.dataObject.getErpMigrationNewTable())) {
                        tableList.add(SchemaCreator.newSchemeTable(mainTableNewTable, false, false, this.dataObject.isAutoGen()));
                    }
                    if ((lpTable = this.dataObject.getMigrationLastPointTable()) != null) {
                        tableList.add(SchemaCreator.newSchemeTable(lpTable, false, false, this.dataObject.isAutoGen()));
                    }
                    if (null != (mainTableNewPreTable = this.dataObject.getErpMigrationNewPreTable())) {
                        tableList.add(SchemaCreator.newSchemeTable(mainTableNewPreTable, false, false, this.dataObject.isAutoGen()));
                    }
                    if (null != (keysPreTable = this.dataObject.getErpMigrationKeysPreTable())) {
                        tableList.add(SchemaCreator.newSchemeTable(keysPreTable, true, false, this.dataObject.isAutoGen()));
                    }
                }
            }
            return tableList;
        }
        boolean hisTable = this.dataObject.getHistory() != null && this.dataObject.getHistory().isSupport() != false;
        boolean uniqueSOID = secondaryType == 2;
        for (MetaTable table : this.dataObject.getTableCollection()) {
            if (!table.isPersist().booleanValue()) continue;
            tableList.add(SchemaCreator.newSchemeTable(table, false, uniqueSOID && table.isHead() && mainTable == table, this.dataObject.isAutoGen()));
            if (!hisTable) continue;
            tableList.add(SchemaCreator.newHistoryTable(table));
        }
        if ((secondaryType == 3 || secondaryType == 5) && (mainMetaTable = this.dataObject.getMainTable()) != null) {
            tableList.add(SchemaCreator.newRRTable(mainMetaTable));
            tableList.add(SchemaCreator.newORTable(mainMetaTable));
        }
        return tableList;
    }

    public ArrayList<MetaSchemaTable> getDictSchemeTableList() {
        MetaTable mainMetaTable;
        int secondaryType = this.dataObject.getSecondaryType();
        ArrayList<MetaSchemaTable> tableList = new ArrayList<MetaSchemaTable>();
        if ((secondaryType == 3 || secondaryType == 5) && (mainMetaTable = this.dataObject.getMainTable()) != null) {
            tableList.add(SchemaCreator.newRRTable(mainMetaTable));
            tableList.add(SchemaCreator.newORTable(mainMetaTable));
        }
        return tableList;
    }

    static MetaSchemaTable newSchemeTable(MetaTable metaTable, boolean migration, boolean uniqueSOID, boolean autoGen) {
        MetaIndex index;
        MetaColumn SrcLangOID;
        MetaColumn Code;
        MetaColumn SrcSOID;
        MetaColumn SrcOID;
        MetaSchemaTable table = new MetaSchemaTable();
        table.setMigration(migration);
        table.setAutoGen(autoGen);
        table.setKey(metaTable.getBindingDBTableName());
        table.setPrimaryKey(metaTable.getPrimaryKey());
        table.setCaption(metaTable.getCaption());
        MetaSchemaColumnCollection columnCollection = table.getColumnCollection();
        MetaIndexCollection schemaIndexCollection = table.getIndexCollection();
        MetaIndexCollection indexCollection = metaTable.getIndexCollection();
        if (indexCollection != null && indexCollection.size() > 0) {
            for (MetaIndex index2 : indexCollection) {
                schemaIndexCollection.add(index2);
            }
        }
        String indexPrefix = metaTable.getIndexPrefix4Create();
        ArrayList<String> migrationList = new ArrayList<String>();
        MetaSchemaColumn OIDColumn = null;
        boolean existPK = false;
        boolean existOIDPK = false;
        for (MetaColumn column : metaTable) {
            if (column.isHidden().booleanValue() || !column.isPersist().booleanValue()) continue;
            MetaSchemaColumn schemaColumn = new MetaSchemaColumn();
            schemaColumn.setKey(column.getBindingDBColumnName());
            schemaColumn.setCaption(column.getCaption());
            schemaColumn.setDataType(column.getDataType());
            schemaColumn.setPrecision(column.getPrecision());
            schemaColumn.setScale(column.getScale());
            schemaColumn.setLength(column.getLength());
            schemaColumn.setPK(column.isPrimaryKey());
            schemaColumn.setAutoGen(column.isAutoGen());
            schemaColumn.setDefaultValue(column.getDefaultValue());
            schemaColumn.setCaseSensitive(column.isCaseSensitive());
            if (column.isPrimaryKey().booleanValue()) {
                existPK = true;
            }
            if ("OID".equalsIgnoreCase(column.getKey())) {
                OIDColumn = schemaColumn;
                if (column.isPrimaryKey().booleanValue()) {
                    existOIDPK = true;
                }
            }
            columnCollection.add(schemaColumn);
            if (!column.isGroup()) continue;
            migrationList.add(column.getBindingDBColumnName());
        }
        if (!existPK && OIDColumn != null) {
            OIDColumn.setPK(true);
        }
        if (!autoGen && !migration && existPK && !existOIDPK && OIDColumn != null) {
            MetaIndex index3 = new MetaIndex();
            index3.setUnique(true);
            index3.setKey(indexPrefix + "_OID");
            index3.setColumns(OIDColumn.getKey());
            schemaIndexCollection.add(index3);
        }
        MetaColumn SOID = metaTable.getSOIDColumn();
        if (!migration && SOID != null) {
            MetaIndex index4 = new MetaIndex();
            index4.setUnique(uniqueSOID);
            index4.setKey(indexPrefix + "_SOID");
            index4.setColumns(SOID.getBindingDBColumnName());
            schemaIndexCollection.add(index4);
        }
        if ((SrcOID = metaTable.getSrcOIDColumn()) != null) {
            MetaIndex index5 = new MetaIndex();
            index5.setKey(indexPrefix + "_SRCO");
            index5.setColumns(SrcOID.getBindingDBColumnName());
            schemaIndexCollection.add(index5);
        }
        if ((SrcSOID = metaTable.getSrcSOIDColumn()) != null) {
            MetaIndex index6 = new MetaIndex();
            index6.setKey(indexPrefix + "_SRCS");
            index6.setColumns(SrcSOID.getBindingDBColumnName());
            schemaIndexCollection.add(index6);
        }
        if ((Code = metaTable.getCODE()) != null && (StringUtil.isBlankOrNull((String)Code.getDBColumnName()) || Code.getKey().equalsIgnoreCase(Code.getDBColumnName())) && metaTable.getSourceType() == 0 && metaTable.getTableMode() == 0) {
            MetaIndex index7 = new MetaIndex();
            index7.setUnique(true);
            index7.setKey(indexPrefix + "_CODE");
            index7.setColumns(Code.getBindingDBColumnName());
            schemaIndexCollection.add(index7);
        }
        if ((SrcLangOID = metaTable.getSrcLangOID()) != null && metaTable.getKey().endsWith("_T")) {
            index = new MetaIndex();
            index.setUnique(false);
            index.setKey(indexPrefix + "_SrcLangOID");
            index.setColumns(SrcLangOID.getBindingDBColumnName());
            schemaIndexCollection.add(index);
        }
        if (migration) {
            if (migrationList.isEmpty()) {
                throw new MetaException(37, SimpleStringFormat.format((String)StringTable.getString(null, "", "MigrationGroupNotDefined"), (Object[])new Object[]{metaTable.getKey()}));
            }
            index = new MetaIndex();
            index.setKey(indexPrefix + "_MIGR");
            StringBuffer sb = new StringBuffer((String)migrationList.get(0));
            if (migrationList.size() > 16) {
                for (int i = 1; i < 15; ++i) {
                    sb.append(",").append((String)migrationList.get(i));
                }
                sb.append(",").append("GroupCountField");
            } else {
                for (int i = 1; i < migrationList.size(); ++i) {
                    sb.append(",");
                    sb.append((String)migrationList.get(i));
                }
            }
            index.setColumns(sb.toString());
            index.setUnique(true);
            schemaIndexCollection.add(index);
        }
        MetaSchemaColumn slockColumn = new MetaSchemaColumn();
        slockColumn.setKey("Slock");
        slockColumn.setDataType(1001);
        columnCollection.add(slockColumn);
        return table;
    }

    static MetaSchemaTable newHistoryTable(MetaTable metaTable) {
        MetaSchemaTable table = new MetaSchemaTable();
        table.setKey(metaTable.getHistoryTableName());
        String primaryKey = metaTable.getPrimaryKey();
        if (primaryKey != null && !primaryKey.isEmpty()) {
            table.setPrimaryKey(primaryKey + "_HIS");
        }
        table.setCaption(metaTable.getCaption());
        MetaSchemaColumnCollection columnCollection = table.getColumnCollection();
        MetaIndexCollection indexCollection = table.getIndexCollection();
        String indexPrefix = metaTable.getIndexPrefix4Create();
        for (MetaColumn column : metaTable) {
            if ("VERID".equalsIgnoreCase(column.getDBColumnName())) continue;
            MetaSchemaColumn schemaColumn = new MetaSchemaColumn();
            schemaColumn.setKey(column.getBindingDBColumnName());
            schemaColumn.setCaption(column.getCaption());
            schemaColumn.setDataType(column.getDataType());
            schemaColumn.setPrecision(column.getPrecision());
            schemaColumn.setScale(column.getScale());
            schemaColumn.setLength(column.getLength());
            schemaColumn.setAutoGen(column.isAutoGen());
            columnCollection.add(schemaColumn);
        }
        MetaSchemaColumn slockColumn = new MetaSchemaColumn();
        slockColumn.setKey("Slock");
        slockColumn.setDataType(1001);
        columnCollection.add(slockColumn);
        MetaSchemaColumn verColumn = new MetaSchemaColumn();
        verColumn.setKey("HVER");
        verColumn.setDataType(1001);
        columnCollection.add(verColumn);
        MetaSchemaColumn verColumn4m = new MetaSchemaColumn();
        verColumn4m.setKey("HVERM");
        verColumn4m.setDataType(1001);
        columnCollection.add(verColumn4m);
        MetaColumn SOIDColumn = metaTable.getSOIDColumn();
        if (SOIDColumn != null) {
            MetaIndex index = new MetaIndex();
            index.setKey(indexPrefix + "HIS_SOID_HVER");
            index.setColumns(SOIDColumn.getBindingDBColumnName() + ",HVER");
            indexCollection.add(index);
        }
        return table;
    }

    static MetaSchemaTable newRRTable(MetaTable metaTable) {
        String rrTableName = metaTable.getBindingDBTableName() + "_RR";
        MetaSchemaTable rrTable = new MetaSchemaTable();
        rrTable.setKey(rrTableName);
        String primaryKey = metaTable.getPrimaryKey();
        if (primaryKey != null && !primaryKey.isEmpty()) {
            rrTable.setPrimaryKey(primaryKey + "_RR");
        }
        MetaSchemaColumnCollection rrColumnCollection = new MetaSchemaColumnCollection();
        rrTable.setColumnCollection(rrColumnCollection);
        MetaSchemaColumn column = new MetaSchemaColumn();
        column.setKey("RoleID");
        column.setDataType(1010);
        column.setPK(true);
        rrColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("FormKey");
        column.setDataType(1002);
        column.setLength(128);
        rrColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("DictID");
        column.setDataType(1010);
        column.setPK(true);
        rrColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("HasRights");
        column.setDataType(1001);
        rrColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("HasRead");
        column.setDataType(1001);
        rrColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("HasWrite");
        column.setDataType(1001);
        rrColumnCollection.add(column);
        return rrTable;
    }

    static MetaSchemaTable newORTable(MetaTable metaTable) {
        String orTableName = metaTable.getBindingDBTableName() + "_OR";
        MetaSchemaTable orTable = new MetaSchemaTable();
        orTable.setKey(orTableName);
        String primaryKey = metaTable.getPrimaryKey();
        if (primaryKey != null && !primaryKey.isEmpty()) {
            orTable.setPrimaryKey(primaryKey + "_OR");
        }
        MetaSchemaColumnCollection orColumnCollection = new MetaSchemaColumnCollection();
        orTable.setColumnCollection(orColumnCollection);
        MetaSchemaColumn column = new MetaSchemaColumn();
        column.setKey("OperatorID");
        column.setDataType(1010);
        column.setPK(true);
        orColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("FormKey");
        column.setDataType(1002);
        column.setLength(128);
        orColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("DictID");
        column.setDataType(1010);
        column.setPK(true);
        orColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("HasRights");
        column.setDataType(1001);
        orColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("HasRead");
        column.setDataType(1001);
        orColumnCollection.add(column);
        column = new MetaSchemaColumn();
        column.setKey("HasWrite");
        column.setDataType(1001);
        orColumnCollection.add(column);
        return orTable;
    }

    public MetaSchemaTable getFormRightsTable() {
        if (this.dataObject == null) {
            return null;
        }
        MetaTable mainTable = this.dataObject.getMainTable();
        if (mainTable == null) {
            return null;
        }
        String frTableKey = mainTable.getBindingDBTableName() + "_FR";
        MetaSchemaTable frTable = new MetaSchemaTable();
        frTable.setKey(frTableKey);
        MetaSchemaColumnCollection columnCollection = new MetaSchemaColumnCollection();
        frTable.setColumnCollection(columnCollection);
        MetaSchemaColumn column = new MetaSchemaColumn();
        column.setKey("OID");
        column.setDataType(1010);
        column.setPK(true);
        columnCollection.add(column);
        column.setAutoGen(this.dataObject.isAutoGen());
        column = new MetaSchemaColumn();
        column.setKey("SOID");
        column.setDataType(1010);
        columnCollection.add(column);
        column.setAutoGen(this.dataObject.isAutoGen());
        column = new MetaSchemaColumn();
        column.setKey("OperatorID");
        column.setDataType(1010);
        columnCollection.add(column);
        column.setAutoGen(this.dataObject.isAutoGen());
        column = new MetaSchemaColumn();
        column.setKey("OptRights");
        column.setDataType(1011);
        columnCollection.add(column);
        column.setAutoGen(this.dataObject.isAutoGen());
        column = new MetaSchemaColumn();
        column.setKey("Enables");
        column.setDataType(1011);
        columnCollection.add(column);
        column.setAutoGen(this.dataObject.isAutoGen());
        column = new MetaSchemaColumn();
        column.setKey("unVisible");
        column.setDataType(1011);
        columnCollection.add(column);
        column.setAutoGen(this.dataObject.isAutoGen());
        column = new MetaSchemaColumn();
        column.setKey("RightsSite");
        column.setDataType(1011);
        columnCollection.add(column);
        column.setAutoGen(this.dataObject.isAutoGen());
        return frTable;
    }
}

