package com.bokesoft.yigo.meta.solution;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaProjectCollection类定义在应用中所有的多种属性的列表集合，可以通过这个对象增加、删除和遍历所有的工程信息列表。
 * @author 王元和
 * @see GenericKeyCollection
 */
public class MetaProjectCollection extends GenericKeyCollection<MetaProjectProfile> implements IElementMerge<MetaProjectCollection>{

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "ProjectCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( MetaProjectProfile.TAG_NAME.equals(tagName) ) {
			child = new MetaProjectProfile();
		}
		if ( child != null ) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaProjectProfile)child);
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public MetaProjectCollection toMerge(MetaProjectCollection obj) {
		if (obj != null) {
			Iterator<MetaProjectProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaProjectProfile metaProjectProfile = (MetaProjectProfile) iterator.next();
				add(metaProjectProfile);
			}
		}
		return this;
	}

}
