package com.bokesoft.yigo.meta.solution;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaLang extends KeyPairMetaObject{

	public static final String BaseLang_ZH = "zh-CN";
	public static final String BaseLang_EN = "en-US";

	private String key = "";

	private String description = "";

	// 默认多语言列宽倍数属性
	private String WidthMultiple = "1";

	/**
	 * 语种后缀，数据多语种时，数据库根据语种生成列的后缀
	 * 这边不使用key的原因是 -在oracle 下特殊字符， 需要用""包装列明，使用""后， 列明区分大小写，
	 * 会导致查询失败。
	 */
	private String suffix = "";

	/** 基类语言类型：zh-CN:中文，en-US:英文**/
	private String baseLang = BaseLang_ZH;

	/** 是否启用词条翻译 **/
	private Boolean enableTranslate = true;

	public static final String TAG_NAME = "Lang";

	@Override
	public String getKey() {
		return this.key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSuffix() {
		return suffix;
	}

	public void setSuffix(String suffix){
		this.suffix = suffix;
	}

	public String getBaseLang() {
		return baseLang;
	}

	public void setBaseLang(String baseLang) {
		this.baseLang = baseLang;
	}

	public Boolean isEnableTranslate() {
		return enableTranslate;
	}

	public void setEnableTranslate(Boolean enableTranslate) {
		this.enableTranslate = enableTranslate;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType)
			throws MetaException {

		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLang lang = new MetaLang();
		lang.setKey(key);
		lang.setDescription(description);
		lang.setSuffix(suffix);
		lang.setWidthMultiple(WidthMultiple);
		lang.setBaseLang(baseLang);
		lang.setEnableTranslate(enableTranslate);
		return lang;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLang();
	}

	public String getWidthMultiple() {
		return WidthMultiple;
	}

	public void setWidthMultiple(String WidthMultiple) {
		this.WidthMultiple = WidthMultiple;
	}
}

