package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaSystemTopics extends GenericKeyCollection<MetaSysTopic> {

	public static final String TAG_NAME = "SystemTopics";
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaSysTopic.TAG_NAME.equals(tagName) ) {
			MetaSysTopic sysTopic = new MetaSysTopic();
			sysTopic.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(sysTopic);
			resultMetaObject = sysTopic;
		}
		return resultMetaObject;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSystemTopics();
	}
}
