package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaSession定义会话超时设置
 * 
 * @author 王元和
 *
 */
public class MetaSession extends GenericNoKeyCollection<MetaSessionPara> {
	/** 超时时间,单位秒 */
	private Integer timeout = 3600;
	/** 移动端超时时间,单位秒*/
	private Integer mobileTimeout = 0;
	/** 是否启动用锁定标志 */
	private Boolean enableLock = false;
	/** 最大登录次数 */
	private Integer maxLoginCount = -1;
	/** 会话级参数的标识，只能提供一个，需要定制更多会话级参数的在定制登录界面时请使用二次开发自己约定的标识 */
	private String sessionParaKey = "";
	/** 会话级参数标题*/
	private String sessionParaTitle = "";
	/** 是否将会话级参数作为数据簇标识 */
	private Boolean sessionParaAsCluster = false;
	/** 会话级参数项目的提供者 */
	private String sessionParaItemsProvider = "";
	/** 会话级参数设置回调函数，登录时调用 */
	private String sessionParaProcess = "";
	/** 登陆校验提供者*/
	private String authenticateProvider = "";
	/** 自定义游客登陆校验类的路径 */
	private String guestAuthenticateProvider = "";	
	/** 账户锁定阀值(默认不锁定) */
	private Integer accountLockoutThreshold = 0;
	/** 账户锁定时间(单位秒,默认保持锁定)*/
	private Integer accountLockoutDuration = 0;
	/**用户锁定信息是否持久化*/
	private Boolean userLockInfoIsPersist = false;

	public MetaSession() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "Session";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaSessionPara.TAG_NAME)) {
			resultMetaObject = new MetaSessionPara();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaSessionPara) resultMetaObject);
		}
		return resultMetaObject;
	}

	/**
	 * 设置超时时间
	 * 
	 * @param timeout
	 *            超时时间
	 */
	public void setTimeout(Integer timeout) {
		this.timeout = timeout;
	}

	/**
	 * 取得超时时间
	 * 
	 * @return 超时时间
	 */
	public Integer getTimeout() {
		return this.timeout;
	}

	public Boolean getUserLockInfoIsPersist() {
		return userLockInfoIsPersist;
	}

	public void setUserLockInfoIsPersist(Boolean userLockInfoIsPersist) {
		this.userLockInfoIsPersist = userLockInfoIsPersist;
	}

	/**
	 * 处理后的移动端超时时间 
	 * @return 移动端超时时间
	 */
	public int getDelMobileTimeout() {
		return this.mobileTimeout > 0 ? this.mobileTimeout: this.timeout;
	}
	
	/**
	 * 取得移动端超时时间
	 * 
	 * @return 超时时间
	 */
	public Integer getMobileTimeout() {
		return mobileTimeout;
	}

	/**
	 * 设置移动端超时时间
	 * 
	 * @param mobileTimeout
	 *            超时时间
	 */
	public void setMobileTimeout(Integer mobileTimeout) {
		this.mobileTimeout = mobileTimeout;
	}

	/**
	 * 设置启用锁定标志
	 * 
	 * @param enableLock
	 *            启用锁定标志
	 */
	public void setEnableLock(Boolean enableLock) {
		this.enableLock = enableLock;
	}

	/**
	 * 取得启用锁定标志
	 * 
	 * @return 启用锁定标志
	 */
	public Boolean isEnableLock() {
		return this.enableLock;
	}

	/**
	 * 设置最大登录次数
	 * 
	 * @param maxLoginCount
	 *            次数
	 */
	public void setMaxLoginCount(Integer maxLoginCount) {
		this.maxLoginCount = maxLoginCount;
	}

	/**
	 * 取得最大登录次数
	 * 
	 * @return 次数
	 */
	public Integer getMaxLoginCount() {
		return this.maxLoginCount;
	}

	/**
	 * 设置会话级参数标识
	 * 
	 * @param sessionParaKey
	 *            标识
	 */
	public void setSessionParaKey(String sessionParaKey) {
		this.sessionParaKey = sessionParaKey;
	}

	/**
	 * 取得会话级参数标识
	 * 
	 * @return 标识
	 */
	public String getSessionParaKey() {
		return this.sessionParaKey;
	}
	
	/**
	 * 取得会话级参数标题
	 * @return 标题
	 */
	public String getSessionParaTitle() {
		return sessionParaTitle;
	}

	/**
	 * 设置会话级参数标题
	 * @param sessionParaTitle 标题
	 */
	public void setSessionParaTitle(String sessionParaTitle) {
		this.sessionParaTitle = sessionParaTitle;
	}

	/**
	 * 设置是否将会话参数作为数据簇标识
	 * 
	 * @param sessionParaAsCluster
	 *            标志
	 */
	public void setSessionParaAsCluster(Boolean sessionParaAsCluster) {
		this.sessionParaAsCluster = sessionParaAsCluster;
	}

	/**
	 * 取得是否将会话参数作为数据簇标志
	 * 
	 * @return 标志
	 */
	public Boolean isSessionParaAsCluster() {
		return this.sessionParaAsCluster;
	}

	/**
	 * 设置会话级参数集合提供者
	 * 
	 * @param sessionParaItemsProvider
	 *            会话参数集合提供者
	 */
	public void setSessionParaItemsProvider(String sessionParaItemsProvider) {
		this.sessionParaItemsProvider = sessionParaItemsProvider;
	}

	/**
	 * 取得会话级参数集合提供者
	 * 
	 * @return 会话参数集提供者
	 */
	public String getSessionParaItemsProvider() {
		return this.sessionParaItemsProvider;
	}

	/**
	 * 取得会话级参数设置回调函数
	 * 
	 * @return 回调函数
	 */
	public String getSessionParaProcess() {
		return sessionParaProcess;
	}

	/**
	 * 设置会话级参数设置回调函数
	 * 
	 * @param sessionParaProcess
	 *            回调函数
	 */
	public void setSessionParaProcess(String sessionParaProcess) {
		this.sessionParaProcess = sessionParaProcess;
	}
	
	/**
	 * 获取自定义登陆提供者
	 * @return
	 */
	public String getAuthenticateProvider() {
		return authenticateProvider;
	}

	/**
	 * 设置自定义登陆提供者
	 * @param authenticateProvider
	 */
	public void setAuthenticateProvider(String authenticateProvider) {
		this.authenticateProvider = authenticateProvider;
	}

	/**
	 * 获取账户锁定阀值
	 * @return
	 */
	public Integer getAccountLockoutThreshold() {
		return accountLockoutThreshold;
	}

	/**
	 * 设置账户锁定阀值
	 * @param accountLockoutThreshold
	 */
	public void setAccountLockoutThreshold(Integer accountLockoutThreshold) {
		this.accountLockoutThreshold = accountLockoutThreshold;
	}

	/**
	 * 获取账户锁定时间
	 * @return
	 */
	public Integer getAccountLockoutDuration() {
		return accountLockoutDuration;
	}

	/**
	 * 设置账户锁定时间
	 * @param accountLockoutDuration
	 */
	public void setAccountLockoutDuration(Integer accountLockoutDuration) {
		this.accountLockoutDuration = accountLockoutDuration;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSession newObject = new MetaSession();
		newObject.setTimeout(timeout);
		newObject.setMobileTimeout(mobileTimeout);
		newObject.setEnableLock(enableLock);
		newObject.setMaxLoginCount(maxLoginCount);
		newObject.setSessionParaKey(sessionParaKey);
		newObject.setSessionParaTitle(sessionParaTitle);
		newObject.setSessionParaItemsProvider(sessionParaItemsProvider);
		newObject.setSessionParaAsCluster(sessionParaAsCluster);
		newObject.setSessionParaProcess(sessionParaProcess);
		newObject.setAuthenticateProvider(authenticateProvider);
		newObject.setGuestAuthenticateProvider(guestAuthenticateProvider);
		newObject.setAccountLockoutDuration(accountLockoutDuration);
		newObject.setAccountLockoutThreshold(accountLockoutThreshold);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSession();
	}

	public String getGuestAuthenticateProvider() {
		return guestAuthenticateProvider;
	}

	public void setGuestAuthenticateProvider(String loginCheckProvider) {
		this.guestAuthenticateProvider = loginCheckProvider;
	}

}
