package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator.MetaAdministratorCollection;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

/**
 * 业务流程运行设置
 * 
 * @author 刘翔翔
 *
 */
public class MetaBPMSetting extends AbstractMetaObject {

	public static final String TAG_NAME = "BPMSetting";

	/** 是否在单据载入数据的过程中查询撤销工作项的信息 */
	private Boolean queryRetreatWorkitem = true;
	
	/** 撤销操作是选择回滚还是撤回，默认选择撤回，对应公式RevokeWorkitem()*/
	private Boolean chooseRollback = false;
	
	/** 是否启动数据对象自有权限记录*/
	private Boolean recordFormRights = false;

	/** 流程打开表单的反向模板定义*/
	private String templateKey = "";
	
	/** 撤销工作项通用名称 */
	private String retreatCaption = "";

	/** 是否单据载入数据的过程中查询当前用户工作项的信息 */
	private Boolean queryActiveWorkitem = false;

	/** 是否单据载入数据的过程中查询当前用户状态机工作项的信息 */
	private Boolean queryActiveStateWorkitem = true;
	
	/** 是否载入过程中查询流程直送信息*/
	private Boolean queryTransitTo = false;

	/** 为开始节点创建日志 */
	private Boolean createLog4BeginNode = false;
	
	/** 为流程结束创建日志*/
	private Boolean createLog4EndNode = false;

	/** 忽略表单状态*/
	private Boolean ignoreFormState = false;
	
	/** 自定义模板路径 */
	private String BPMTemplatePath = "";
	
	/** 自定义事件响应路径*/
	private String workFlowHookPath = "";
	
	/** 自定义流程图信息路径*/
	private String BPMGraphInfoPath = "";

	/** 系统任务动作定义*/
	private String BPMNodeAction = "";
	
	/** 自定义权限载入类*/
	private String rightsProvider = "";
	
	/** 自定义外部资源模型*/
	private String customExternalResourceModel = "";
	/** 全局外部资源计算*/
	private String defaultExtendProcess = "";
	/** 全局外部资源计算的参数*/
	private MetaSourceParaCollection metaSourceParaCollection = null;
	/** 是否优先使用全局外部资源计算*/
	private Boolean isUseDefaultExtendProcess = false;
	
	/** 系统主题*/
	private String sysTopic = "";
	
	/** 是否在添加代理时重新计算当前相关工作项*/
	private Boolean recalculateActiveWorkitem = false;
	/** 是否在存在代理时添加代理日志*/
	private Boolean addDelegateLog = false;
	
	/** 是否启用默认回收过期代理定时器*/
	private Boolean useDefaultRetreateDelegateTimer= true;
	
	/** 是否启用默认的执行超时事件的定时器*/
	private Boolean useDefaultExecTimeoutItemTimer = true;
	
	/** 代理规则定义*/
	private String DelegateCheck = "";
	
	private boolean deleteAuditLog = false;

	/** 批量审批的默认操作 */
	private MetaBaseScript defaultBatchStateAction = new MetaBaseScript(BPMConstants.DEFAULT_BATCH_STATE_ACTION);

	/** 状态机的默认操作 */
	private MetaBaseScript defaultStateAction = new MetaBaseScript(BPMConstants.DEFAULT_STATE_ACTION);

	/** 审批的默认操作 */
	private MetaBaseScript defaultAuditAction = new MetaBaseScript(BPMConstants.DEFAULT_AUDIT_ACTION);

	/** 任务的默认操作 */
	private MetaBaseScript defaultTaskAction = new MetaBaseScript(BPMConstants.DEFAULT_TASK_ACTION);

	/** 会签的默认操作 */
	private MetaBaseScript defaultCountersignAction = new MetaBaseScript(BPMConstants.DEFAULT_COUNTERSIGN_ACTION);
	
	/** 工作项创建事件*/
	private MetaBaseScript workitemCreateTriggerAction = new MetaBaseScript(BPMConstants.WORKITEM_CREATE_TRIGGER_ACTION);

	/** 流程迁移设置 */
	private MetaBPMMTable BPMMTable = new MetaBPMMTable();
	
	/** 全局管理者*/
	private MetaAdministratorCollection metaAdministratorCollection = null;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(defaultBatchStateAction);
		list.add(defaultStateAction);
		list.add(defaultAuditAction);
		list.add(defaultTaskAction);
		list.add(defaultCountersignAction);
		list.add(BPMMTable);
		list.add(metaSourceParaCollection);
		list.add(workitemCreateTriggerAction);
		list.add(metaAdministratorCollection);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (BPMConstants.DEFAULT_BATCH_STATE_ACTION.equals(tagName)) {
			resultMetaObject = this.defaultBatchStateAction;
		} else if (BPMConstants.DEFAULT_STATE_ACTION.equals(tagName)) {
			resultMetaObject = this.defaultStateAction;
		} else if (BPMConstants.DEFAULT_AUDIT_ACTION.equals(tagName)) {
			resultMetaObject = this.defaultAuditAction;
		} else if (BPMConstants.DEFAULT_TASK_ACTION.equals(tagName)) {
			resultMetaObject = this.defaultTaskAction;
		} else if (BPMConstants.DEFAULT_COUNTERSIGN_ACTION.equals(tagName)) {
			resultMetaObject = this.defaultCountersignAction;
		} else if (MetaBPMMTable.TAG_NAME.equals(tagName)) {
			if (this.BPMMTable == null) {
				this.BPMMTable = new MetaBPMMTable();
			}
			resultMetaObject = this.BPMMTable;
		} else if (tagName.equalsIgnoreCase(MetaSourceParaCollection.TAG_NAME)) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			resultMetaObject = metaSourceParaCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (BPMConstants.WORKITEM_CREATE_TRIGGER_ACTION.equals(tagName)) {
			resultMetaObject = this.workitemCreateTriggerAction;
		} else if (tagName.equalsIgnoreCase(MetaAdministratorCollection.TAG_NAME)) {
			metaAdministratorCollection = new MetaAdministratorCollection();
			resultMetaObject = metaAdministratorCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBPMSetting clone = new MetaBPMSetting();
		clone.setQueryActiveStateWorkitem(queryActiveStateWorkitem);
		clone.setQueryTransitTo(queryTransitTo);
		clone.setQueryActiveWorkitem(queryActiveWorkitem);
		clone.setQueryRetreatWorkitem(queryRetreatWorkitem);
		clone.setChooseRollback(chooseRollback);
		clone.setRecordFormRights(recordFormRights);
		clone.setTemplateKey(templateKey);
		clone.setBPMTemplatePath(BPMTemplatePath);
		clone.setWorkFlowHookPath(workFlowHookPath);
		clone.setBPMGraphInfoPath(BPMGraphInfoPath);
		clone.setBPMNodeAction(BPMNodeAction);
		clone.setDelegateCheck(DelegateCheck);
		clone.setAddDelegateLog(addDelegateLog);
		clone.setRightsProvider(rightsProvider);
		clone.setCustomExternalResourceModel(customExternalResourceModel);
		clone.setDefaultExtendProcess(defaultExtendProcess);
		clone.setUseDefaultExtendProcess(isUseDefaultExtendProcess);
		clone.setSysTopic(sysTopic);
		clone.setUseDefaultRetreateDelegateTimer(useDefaultRetreateDelegateTimer);
		clone.setUseDefaultExecTimeoutItemTimer(useDefaultExecTimeoutItemTimer);
		clone.setRecalculateActiveWorkitem(recalculateActiveWorkitem);
		clone.setRetreatCaption(retreatCaption);
		clone.setDefaultBatchStateAction((MetaBaseScript) defaultBatchStateAction.clone());
		clone.setDefaultStateAction((MetaBaseScript) defaultStateAction.clone());
		clone.setDefaultAuditAction((MetaBaseScript) defaultAuditAction.clone());
		clone.setDefaultTaskAction((MetaBaseScript) defaultTaskAction.clone());
		clone.setDefaultCountersignAction((MetaBaseScript) defaultCountersignAction.clone());
		clone.setMetaSourceParaCollection(metaSourceParaCollection == null ? null : (MetaSourceParaCollection)metaSourceParaCollection.clone());
		clone.setWorkitemCreateTriggerAction(null == workitemCreateTriggerAction ? null : (MetaBaseScript)workitemCreateTriggerAction.clone());
		clone.setMetaAdministratorCollection(null == metaAdministratorCollection ? null : (MetaAdministratorCollection)metaAdministratorCollection.clone());
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMSetting();
	}

	public Boolean getQueryRetreatWorkitem() {
		return queryRetreatWorkitem;
	}

	public void setQueryRetreatWorkitem(Boolean queryRetreatWorkitem) {
		this.queryRetreatWorkitem = queryRetreatWorkitem;
	}
	
	public Boolean isChooseRollback() {
		return chooseRollback;
	}

	public void setChooseRollback(Boolean chooseRollback) {
		this.chooseRollback = chooseRollback;
	}

	public Boolean getRecordFormRights() {
		return recordFormRights;
	}
	
	public void setRecordFormRights(Boolean recordFormRights) {
		this.recordFormRights = recordFormRights;
	}
	
	public String getTemplateKey() {
		return templateKey;
	}
	
	public void setTemplateKey(String templateKey) {
		this.templateKey = templateKey;
	}
	
	public String getRightsProvider() {
		return rightsProvider;
	}

	public void setRightsProvider(String rightsProvider) {
		this.rightsProvider = rightsProvider;
	}

	public String getRetreatCaption() {
		return retreatCaption;
	}

	public void setRetreatCaption(String retreatCaptiom) {
		this.retreatCaption = retreatCaptiom;
	}

	public Boolean getQueryActiveWorkitem() {
		return queryActiveWorkitem;
	}

	public void setQueryActiveWorkitem(Boolean queryActiveWorkitem) {
		this.queryActiveWorkitem = queryActiveWorkitem;
	}

	public Boolean getQueryActiveStateWorkitem() {
		return queryActiveStateWorkitem;
	}

	public void setQueryActiveStateWorkitem(Boolean queryActiveStateWorkitem) {
		this.queryActiveStateWorkitem = queryActiveStateWorkitem;
	}
	
	public Boolean getQueryTransitTo() {
		return queryTransitTo;
	}
	
	public void setQueryTransitTo(Boolean queryTransitTo) {
		this.queryTransitTo = queryTransitTo;
	}

	public Boolean getCreateLog4BeginNode() {
		return createLog4BeginNode;
	}

	public void setCreateLog4BeginNode(Boolean createLog4BeginNode) {
		this.createLog4BeginNode = createLog4BeginNode;
	}
	
	/**
	 * @return the createLog4EndNode
	 */
	public Boolean getCreateLog4EndNode() {
		return createLog4EndNode;
	}

	/**
	 * @param createLog4EndNode the createLog4EndNode to set
	 */
	public void setCreateLog4EndNode(Boolean createLog4EndNode) {
		this.createLog4EndNode = createLog4EndNode;
	}

	public Boolean getIgnoreFormState() {
		return ignoreFormState;
	}
	
	public void setIgnoreFormState(Boolean ignoreFormState) {
		this.ignoreFormState = ignoreFormState;
	}
	
	public boolean getDeleteAuditLog(){
		return this.deleteAuditLog;
	}
	
	public void setDeleteAuditLog(boolean deleteAuditLog) {
		this.deleteAuditLog = deleteAuditLog;
	}

	public String getBPMTemplatePath() {
		return BPMTemplatePath;
	}

	public void setBPMTemplatePath(String bPMTemplatePath) {
		BPMTemplatePath = bPMTemplatePath;
	}
	
	public String getWorkFlowHookPath() {
		return workFlowHookPath;
	}
	
	public void setWorkFlowHookPath(String workFlowHook) {
		this.workFlowHookPath = workFlowHook;
	}
	
	public String getBPMGraphInfoPath() {
		return BPMGraphInfoPath;
	}
	
	public void setBPMGraphInfoPath(String bPMGraphInfoPath) {
		BPMGraphInfoPath = bPMGraphInfoPath;
	}
	
	public void setCustomExternalResourceModel(String customExternalResourceModel) {
		this.customExternalResourceModel = customExternalResourceModel;
	}
	
	public String getCustomExternalResourceModel() {
		return customExternalResourceModel;
	}
	
	public void setDefaultExtendProcess(String defaultExtendProcess) {
		this.defaultExtendProcess = defaultExtendProcess;
	}
	
	public String getDefaultExtendProcess() {
		return defaultExtendProcess;
	}
	
	public void setMetaSourceParaCollection(MetaSourceParaCollection metaSourceParaCollection) {
		this.metaSourceParaCollection = metaSourceParaCollection;
	}
	
	public MetaSourceParaCollection getMetaSourceParaCollection() {
		return metaSourceParaCollection;
	}
	
	public void setUseDefaultExtendProcess(Boolean isUseDefaultExtendProcess) {
		this.isUseDefaultExtendProcess = isUseDefaultExtendProcess;
	}
	
	public Boolean isUseDefaultExtendProcess() {
		return isUseDefaultExtendProcess;
	}
	
	public void setSysTopic(String sysTopic){
		this.sysTopic = sysTopic;
	}
	
	public String getSysTopic(){
		return sysTopic;
	}
	
	public String getBPMNodeAction() {
		return BPMNodeAction;
	}
	
	public void setBPMNodeAction(String bPMNodeAction) {
		BPMNodeAction = bPMNodeAction;
	}
	
	public Boolean isRecalculateActiveWorkitem() {
		return recalculateActiveWorkitem;
	}

	public void setRecalculateActiveWorkitem(Boolean recalculateActiveWorkitem) {
		this.recalculateActiveWorkitem = recalculateActiveWorkitem;
	}
	
	public String getDelegateCheck() {
		return DelegateCheck;
	}
	
	public void setDelegateCheck(String delegateCheck) {
		DelegateCheck = delegateCheck;
	}

	public MetaBaseScript getDefaultBatchStateAction() {
		return defaultBatchStateAction;
	}

	public void setDefaultBatchStateAction(MetaBaseScript defaultBatchStateAction) {
		this.defaultBatchStateAction = defaultBatchStateAction;
	}

	public MetaBaseScript getDefaultStateAction() {
		return defaultStateAction;
	}

	public void setDefaultStateAction(MetaBaseScript defaultStateAction) {
		this.defaultStateAction = defaultStateAction;
	}

	public MetaBaseScript getDefaultAuditAction() {
		return defaultAuditAction;
	}

	public void setDefaultAuditAction(MetaBaseScript defaultAuditAction) {
		this.defaultAuditAction = defaultAuditAction;
	}

	public MetaBaseScript getDefaultTaskAction() {
		return defaultTaskAction;
	}

	public void setDefaultTaskAction(MetaBaseScript defaultTaskAction) {
		this.defaultTaskAction = defaultTaskAction;
	}

	public MetaBaseScript getDefaultCountersignAction() {
		return defaultCountersignAction;
	}

	public Boolean isAddDelegateLog() {
		return addDelegateLog;
	}

	public void setAddDelegateLog(Boolean addDelegateLog) {
		this.addDelegateLog = addDelegateLog;
	}

	public Boolean isUseDefaultRetreateDelegateTimer() {
		return useDefaultRetreateDelegateTimer;
	}

	public void setUseDefaultRetreateDelegateTimer(Boolean useDefaultRetreateDelegateTimer) {
		this.useDefaultRetreateDelegateTimer = useDefaultRetreateDelegateTimer;
	}

	public Boolean isUseDefaultExecTimeoutItemTimer() {
		return useDefaultExecTimeoutItemTimer;
	}

	public void setUseDefaultExecTimeoutItemTimer(Boolean useDefaultExecTimeoutItemTimer) {
		this.useDefaultExecTimeoutItemTimer = useDefaultExecTimeoutItemTimer;
	}

	public void setDefaultCountersignAction(MetaBaseScript defaultCountersignAction) {
		this.defaultCountersignAction = defaultCountersignAction;
	}

	public MetaBPMMTable getBPMMTable() {
		return BPMMTable;
	}

	public MetaBPMMTable getBPMMTable(IMetaFactory metaFactory) throws Throwable {
		if (BPMMTable == null) {
			BPMMTable = new MetaBPMMTable();
		}
		BPMMTable.init(metaFactory);
		return BPMMTable;
	}

	public void setBPMMTable(MetaBPMMTable bPMMTable) {
		BPMMTable = bPMMTable;
	}
	
	public MetaBaseScript getWorkitemCreateTriggerAction() {
		return workitemCreateTriggerAction;
	}

	public void setWorkitemCreateTriggerAction(MetaBaseScript workitemCreateTriggerAction) {
		this.workitemCreateTriggerAction = workitemCreateTriggerAction;
	}

	public MetaAdministratorCollection getMetaAdministratorCollection() {
		return metaAdministratorCollection;
	}

	public void setMetaAdministratorCollection(MetaAdministratorCollection metaAdministratorCollection) {
		this.metaAdministratorCollection = metaAdministratorCollection;
	}
	
}
