package com.bokesoft.yigo.meta.rights;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaFormRightsCollection extends GenericNoKeyCollection<MetaFormDefinition> implements IElementMerge<MetaFormRightsCollection>{
	
	public static final String TAG_NAME = "FormRightsCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if( MetaFormDefinition.TAG_NAME.equals(tagName) ) {
			MetaFormDefinition formDefinition = new MetaFormDefinition();
			this.add(formDefinition);
			resultMetaObject = formDefinition;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFormRightsCollection();
	}
	
	/**
	 * 是否包含给定的表单定义
	 * @param formKey 表单标识
	 * @return 如果formKey指定的定义存在则返回true，否则返回false
	 */
	public boolean contains(String formKey) {
		for( MetaFormDefinition formDefinition : this ) {
			if( formDefinition.getFormKey().equals(formKey) ) {
				return true;
			}
		}
		return false;
	}

	@Override
	public MetaFormRightsCollection toMerge(MetaFormRightsCollection obj) {
		if (obj != null) {
			Iterator<MetaFormDefinition> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaFormDefinition metaFormDefinition = (MetaFormDefinition) iterator.next();
				add(metaFormDefinition);
			}
		}
		return this;
	}

}
