package com.bokesoft.yigo.meta.report;

/**
 * ReportCellContentType定义报表中的单元格的内容类型
 * @author 王元和
 * @since YES 1.0
 *
 */
public class ReportCellContentType {
	/** 文本 */
	public static final int Text = 0;
	public static final String STR_Text = "Text";
	
	/** 图像 */
	public static final int Image = 1;
	public static final String STR_Image = "Image";
	
	/** 图表 */
	public static final int Chart = 2;
	public static final String STR_Chart = "Chart";
	
	public static int parse(String s) {
		int type = -1;
		if ( STR_Text.equalsIgnoreCase(s) ) {
			type = Text;
		} else if ( STR_Image.equalsIgnoreCase(s) ) {
			type = Image;
		} else if ( STR_Chart.equalsIgnoreCase(s) ) {
			type = Chart;
		}
		return type;
	}
	
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = null;
		switch ( type ) {
		case Text:
			s = STR_Text;
			break;
		case Image:
			s = STR_Image;
			break;
		case Chart:
			s = STR_Chart;
			break;
		}
		return s;
	}
	
	public static String getListString() {
		return "文本" + "," + Text + ";" + "图片" + "," + Image + ";" + "图表" + "," + Image;
	}
}
