package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaReportDataTable定义打印报表中的数据表
 * @author wangyh
 *
 */
public class MetaReportDataTable extends
		GenericKeyCollectionWithKey<MetaReportDataField> {
	public static final String TAG_NAME = "Table";

	/** 数据表的标识 */
	private String key = "";
	/** 数据表的名称 */
	private String caption = "";
	/** 数据表的描述 */
	private String description = "";
	/** 关联数据表的标识 */
	private String dbTableKey = "";
	/** 数据表的查询语句 */
	private String stateument = "";
	/** 数据表的过滤条件 */
	private String filter = "";
	/** 数据表的来源类型 */
	private Integer sourceType = TableSourceType.UNKNOWN;

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaReportDataField.TAG_NAME.equals(tagName) ) {
			MetaReportDataField field = new MetaReportDataField();
			field.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(field);
			resultMetaObject = field;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置数据表的标识
	 * @param key 数据表的标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置数据表的名称
	 * @param caption 数据表的名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得数据表的名称
	 * @return 数据表的名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置数据表的描述
	 * @param description 数据表的描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 取得数据表的描述
	 * @return 数据表的描述
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * 设置关联数据表的标识
	 * @param dbTableKey 关联数据表的标识
	 */
	public void setDBTableKey(String dbTableKey) {
		this.dbTableKey = dbTableKey;
	}
	
	/**
	 * 取得关联数据表的标识
	 * @return 关联数据表的标识
	 */
	public String getDBTableKey() {
		return this.dbTableKey;
	}

	/**
	 * 设置数据表的查询语句
	 * @param stateument 数据表的查询语句
	 */
	public void setStateument(String stateument) {
		this.stateument = stateument;
	}
	
	/**
	 * 取得数据表的查询语句
	 * @return 数据表的查询语句
	 */
	public String getStateument() {
		return stateument;
	}

	/**
	 * 设置数据表的过滤条件
	 * @param filter 数据表的过滤条件
	 */
	public void setFilter(String filter) {
		this.filter = filter;
	}
	
	/**
	 * 取得数据表的过滤条件
	 * @return 数据表的过滤条件
	 */
	public String getFilter() {
		return this.filter;
	}

	/**
	 * 设置数据表的来源类型
	 * @param sourceType 数据表的来源类型
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 取得数据表的来源类型
	 * @return 数据表的来源类型
	 */
	public Integer getSourceType() {
		return this.sourceType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportDataTable();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportDataTable newTable = (MetaReportDataTable) super.clone();
		newTable.setKey(key);
		newTable.setCaption(caption);
		newTable.setDescription(description);
		newTable.setDBTableKey(dbTableKey);
		newTable.setStateument(stateument);
		newTable.setFilter(filter);
		newTable.setSourceType(sourceType);
		return newTable;
	}
	
	
}
