package com.bokesoft.yigo.meta.path.relation;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.path.MetaRelationCollection;
import com.bokesoft.yigo.meta.path.MetaRelationNode;
import com.bokesoft.yigo.meta.path.MetaRelationParentNode;

public class MetaRelationNodeB extends MetaRelationParentNode {

	/** 包含的线集合 */
	private MetaRelationSet lineset;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(lineset);
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaobject = null;
		if (MetaRelationSet.TAG_NAME.equals(tagName)) {
			lineset = new MetaRelationSet();
			resultMetaobject = lineset;
		}
		return resultMetaobject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelationNode();
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	/**
	 * 取得包含线集合
	 * @return 集合定义
	 */
	public MetaRelationSet getLineCollection() {
		return lineset;
	}
	
	/**
	 * 设置包含线集合
	 * @param lineset 集合定义
	 */
	public void setLineCollection(MetaRelationSet lineset) {
		this.lineset = lineset;
	}



}
