package com.bokesoft.yigo.meta.mobiledef;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.mobiledef.encrypt.MetaEncryptSetting;

public class MetaMobileDef extends AbstractMetaObject{
	
	/** 定义CSS文件的路径，相对于配置文件Resource目录下 */
	private String css = "";
	/** 是否有导航条。其值为“”、“false”和“true”，默认值为“”，表示依据表单自身处理。
	 * 非空情况，表单根据Form、项目和MobileDef定义的顺序来处理 */
	private String hasNavigationBar = "";
	/** 导航栏定义 */
	private MetaNavigationBar navigationBar = null;
	/** 事件触发定义集合 */
	private MetaEventDefCollection eventDefCollection = null;
	/** 震动定义 */
	private MetaVibratorDef vibratorDef = null;
	/** 声音定义 */
	private MetaSoundPool soundPool = null;
    /** 应用更新定义文件路径*/
	private String versionPath;
	/** 是否跟随系统语言，为true时程序设置语言无效 */
	private Boolean sysLanguage = true;
	/** 登录用户名/密码错误次数,0次不限制 */
	private Integer passErrorCount=0;
	/** 可重新认证的倒数时间，单位为秒 */
	private Integer passEnableTime=60;
	/** 是否禁用软件盘*/
	private Boolean disableKeyboard = null;
	/** 支持的后台服务版本号*/
	private String serverVersion = "";
    /** 动画集合 */
    private MetaAnimCollection animCollection = null;
    /** 必填图标，仅在原本支持图标的控件上生效*/
    private String requiredIcon = null;
    /** 检查通过图标，仅在原本支持图标的控件上生效*/
    private String checkRulePassIcon = null;
    /** 检查未通过图标，仅在原本支持图标的控件上生效*/
    private String checkRuleErrorIcon = null;
    /** 全屏类型*/
    private Integer fullscreenType = -1;
    /** 状态栏颜色*/
    private String statusBarColor;
    /** 数据传输加密算法的相关设置*/
    private MetaEncryptSetting encryptSetting;
    /** 水印*/
    private MetaWatermark watermark;
    /** Android端使用的相关参数，包括：推送参数，应用参数等等。*/
    private MetaAppParas appParas;
    /** 扩展类定义集合*/
    private MetaExtClassCollection extClassCollection;
    
    /**
     * 获取定义CSS文件的路径
     * @return 定义CSS文件的路径
     */
	public String getCss() {
		return css;
	}

	/**
	 * 设置定义CSS文件的路径
	 * @param css 定义CSS文件的路径
	 */
	public void setCss(String css) {
		this.css = css;
	}

	/**
	 * 获取是否有导航条
	 * @return 是否有导航条
	 */
	public String getHasNavigationBar() {
		return hasNavigationBar;
	}

	/**
	 * 设置是否有导航条
	 * @param hasNavigationBar 是否有导航条
	 */
	public void setHasNavigationBar(String hasNavigationBar) {
		this.hasNavigationBar = hasNavigationBar;
	}

	/**
	 * 获取导航栏定义
	 * @return 导航栏定义
	 */
	public MetaNavigationBar getNavigationBar() {
		return navigationBar;
	}

	/**
	 * 设置导航栏定义
	 * @param navigationBar 导航栏定义
	 */
	public void setNavigationBar(MetaNavigationBar navigationBar) {
		this.navigationBar = navigationBar;
	}

	/**
	 * 获取事件触发定义集合
	 * @return 事件触发定义集合
	 */
	public MetaEventDefCollection getEventDefCollection() {
		return eventDefCollection;
	}

	/**
	 * 设置事件触发定义集合
	 * @param eventDefCollection 事件触发定义集合
	 */
	public void setEventDefCollection(MetaEventDefCollection eventDefCollection) {
		this.eventDefCollection = eventDefCollection;
	}

	/**
	 * 获取设备震动定义
	 * @return 震动定义
	 */
	public MetaVibratorDef getVibratorDef() {
		return vibratorDef;
	}

	/**
	 * 设置设备震动定义
	 * @param vibratorDef 震动定义
	 */
	public void setVibratorDef(MetaVibratorDef vibratorDef) {
		this.vibratorDef = vibratorDef;
	}

	/**
	 * 获取声音定义
	 * @return 声音定义
	 */
	public MetaSoundPool getSoundPool() {
		return soundPool;
	}

	/**
	 * 设置声音定义
	 * @param soundPool 声音定义
	 */
	public void setSoundPool(MetaSoundPool soundPool) {
		this.soundPool = soundPool;
	}

	/**
	 * 获取应用更新定义文件路径
	 * @return 应用更新定义文件路径
	 */
	public String getVersionPath() {
		return versionPath;
	}

	/**
	 * 设置应用更新定义文件路径
	 * @param versionPath 应用更新定义文件路径
	 */
	public void setVersionPath(String versionPath) {
		this.versionPath = versionPath;
	}

	/**
	 * 获取是否跟随系统语言，为true时程序设置语言无效 
	 * @return 是否跟随系统语言，为true时程序设置语言无效 
	 */
	public Boolean isSysLanguage() {
		return sysLanguage;
	}

	/**
	 * 设置是否跟随系统语言，为true时程序设置语言无效 
	 * @param sysLanguage 是否跟随系统语言，为true时程序设置语言无效 
	 */
	public void setSysLanguage(Boolean sysLanguage) {
		this.sysLanguage = sysLanguage;
	}

	/**
	 * 获取登录用户名/密码错误次数,0次不限制
	 * @return 登录用户名/密码错误次数,0次不限制
	 */
	public Integer getPassErrorCount() {
		return passErrorCount;
	}

	/**
	 * 设置登录用户名/密码错误次数,0次不限制
	 * @param passErrorCount 登录用户名/密码错误次数,0次不限制
	 */
	public void setPassErrorCount(Integer passErrorCount) {
		this.passErrorCount = passErrorCount;
	}

	/**
	 * 获取可重新认证的倒数时间，单位为秒
	 * @return 可重新认证的倒数时间，单位为秒
	 */
	public Integer getPassEnableTime() {
		return passEnableTime;
	}

	/**
	 * 设置可重新认证的倒数时间，单位为秒
	 * @param passEnableTime 可重新认证的倒数时间，单位为秒
	 */
	public void setPassEnableTime(Integer passEnableTime) {
		this.passEnableTime = passEnableTime;
	}

	/**
	 * 获取动画集合
	 * @return 动画集合
	 */
	public MetaAnimCollection getAnimCollection() {
		return animCollection;
	}
	
	/**
	 * 设置动画集合
	 * @param animCollection 动画集合
	 */
	public void setAnimCollection(MetaAnimCollection animCollection) {
		this.animCollection = animCollection;
	}
	
	/**
	 * 设置是否禁用软件盘
	 * @param disableKeyboard 是否禁用软件盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.disableKeyboard = disableKeyboard;
	}
	
	/**
	 * 获取是否禁用软件盘
	 * @return 是否禁用软件盘
	 */
	public Boolean isDisableKeyboard() {
		return disableKeyboard;
	}

	/**
	 * 设置支持的后台服务版本号
	 * @param serverVersion 支持的后台服务版本号
	 */
	public void setServerVersion(String serverVersion) {
		this.serverVersion = serverVersion;
	}
	
	/**
	 * 获取支持的后台服务版本号
	 * @return 支持的后台服务版本号
	 */
	public String getServerVersion() {
		return serverVersion;
	}
	
	/**
	 * 获取必填图标，仅在原本支持图标的控件上生效
	 * @return 必填图标，仅在原本支持图标的控件上生效
	 */
	public String getRequiredIcon() {
		return requiredIcon;
	}

	/**
	 * 设置必填图标，仅在原本支持图标的控件上生效
	 * @param requiredIcon 必填图标，仅在原本支持图标的控件上生效
	 */
	public void setRequiredIcon(String requiredIcon) {
		this.requiredIcon = requiredIcon;
	}

	/**
	 * 获取检查通过图标，仅在原本支持图标的控件上生效
	 * @return 检查通过图标，仅在原本支持图标的控件上生效
	 */
	public String getCheckRulePassIcon() {
		return checkRulePassIcon;
	}

	/**
	 * 设置检查通过图标，仅在原本支持图标的控件上生效
	 * @param checkRulePassIcon 检查通过图标，仅在原本支持图标的控件上生效
	 */
	public void setCheckRulePassIcon(String checkRulePassIcon) {
		this.checkRulePassIcon = checkRulePassIcon;
	}

	/**
	 * 获取检查未通过图标，仅在原本支持图标的控件上生效
	 * @return 检查未通过图标，仅在原本支持图标的控件上生效
	 */
	public String getCheckRuleErrorIcon() {
		return checkRuleErrorIcon;
	}

	/**
	 * 设置检查未通过图标，仅在原本支持图标的控件上生效
	 * @param checkRuleErrorIcon 检查未通过图标，仅在原本支持图标的控件上生效
	 */
	public void setCheckRuleErrorIcon(String checkRuleErrorIcon) {
		this.checkRuleErrorIcon = checkRuleErrorIcon;
	}

	/**
	 * 获取全屏类型
	 * @return 全屏类型
	 */
	public Integer getFullscreenType() {
		return fullscreenType;
	}

	/**
	 * 设置全屏类型
	 * @param fullscreenType 全屏类型
	 */
	public void setFullscreenType(Integer fullscreenType) {
		this.fullscreenType = fullscreenType;
	}

	/**
	 * 获取设备状态栏的颜色
	 * @return 状态栏的颜色
	 */
	public String getStatusBarColor() {
		return statusBarColor;
	}

	/**
	 * 设置设备状态栏颜色
	 * @param statusBarColor 设备状态栏的颜色
	 */
	public void setStatusBarColor(String statusBarColor) {
		this.statusBarColor = statusBarColor;
	}

	/**
	 * 获取数据传输加密算法的相关设置
	 * @return 数据传输加密算法的相关设置
	 */
	public MetaEncryptSetting getEncryptSetting() {
		return encryptSetting;
	}

	/**
	 * 设置数据传输加密算法的相关设置
	 * @param encryptSetting 数据传输加密算法的相关设置
	 */
	public void setEncryptSetting(MetaEncryptSetting encryptSetting) {
		this.encryptSetting = encryptSetting;
	}
	
	/**
	 * 获取水印
	 * @return 水印
	 */
	public MetaWatermark getWatermark() {
		return watermark;
	}

	/**
	 * 设置水印
	 * @param MetaWatermark 水印
	 */
	public void setWatermark(MetaWatermark watermark) {
		this.watermark = watermark;
	}
	
	/**
	 * 获取android端参数集合
	 * @return 参数集合
	 */
	public MetaAppParas getAppParas() {
		return appParas;
	}
	
	/**
	 * 设置android端参数集合
	 * @param appParas 参数集合
	 */
	public void setAppParas(MetaAppParas appParas) {
		this.appParas = appParas;
	}

	public MetaExtClassCollection getExtClassCollection() {
		return extClassCollection;
	}

	public void setExtClassCollection(MetaExtClassCollection extClassCollection) {
		this.extClassCollection = extClassCollection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {
				navigationBar, eventDefCollection, vibratorDef, soundPool, 
				animCollection, encryptSetting, watermark, appParas, extClassCollection
		});
	}

	public static final String TAG_NAME = "MobileDef";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaNavigationBar.TAG_NAME.equalsIgnoreCase(tagName)) {
			navigationBar = new MetaNavigationBar();
			metaObject = navigationBar;
		} else if (MetaEventDefCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			eventDefCollection = new MetaEventDefCollection();
			metaObject = eventDefCollection;
		} else if (MetaVibratorDef.TAG_NAME.equalsIgnoreCase(tagName)) {
			vibratorDef = new MetaVibratorDef();
			metaObject = vibratorDef;
		} else if (MetaSoundPool.TAG_NAME.equalsIgnoreCase(tagName)) {
			soundPool = new MetaSoundPool();
			metaObject = soundPool;
		} else if (MetaAnimCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
            animCollection = new MetaAnimCollection();
            metaObject = animCollection;
        } else if (MetaEncryptSetting.TAG_NAME.equalsIgnoreCase(tagName)) {
            encryptSetting = new MetaEncryptSetting();
            metaObject = encryptSetting;
        } else if (MetaWatermark.TAG_NAME.equalsIgnoreCase(tagName)) {
            watermark = new MetaWatermark();
            metaObject = watermark;
        } else if (MetaAppParas.TAG_NAME.equalsIgnoreCase(tagName)) {
            appParas = new MetaAppParas();
            metaObject = appParas;
        } else if (MetaExtClassCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
            extClassCollection = new MetaExtClassCollection();
            metaObject = extClassCollection;
        }
		return metaObject;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		if(navigationBar != null){
			navigationBar.doPostProcess(flag, callback);
		}
		if(eventDefCollection == null){
			eventDefCollection = new MetaEventDefCollection();
		}
		eventDefCollection.doPostProcess(flag, callback);
		if(vibratorDef != null){
			vibratorDef.doPostProcess(flag, callback);
		}
		if(soundPool != null){
			soundPool.doPostProcess(flag, callback);
		}
		if(animCollection != null){
			animCollection.doPostProcess(flag, callback);
		}
		if(encryptSetting != null){
			encryptSetting.doPostProcess(flag, callback);
		} 
		if (watermark != null) {
			watermark.doPostProcess(flag, callback);
		}
		if (appParas != null) {
			appParas.doPostProcess(flag, callback);
		}
		if(extClassCollection != null){
			extClassCollection.doPostProcess(flag, callback);
		}
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMobileDef meta = new MetaMobileDef();
		meta.setCss(css);
		meta.setHasNavigationBar(hasNavigationBar);
		meta.setNavigationBar(navigationBar == null ? null : (MetaNavigationBar)navigationBar.clone());
		meta.setEventDefCollection(eventDefCollection == null ? null : (MetaEventDefCollection)eventDefCollection.clone());
		meta.setVibratorDef(vibratorDef == null ? null : (MetaVibratorDef)vibratorDef.clone());
		meta.setSoundPool(soundPool == null ? null : (MetaSoundPool )soundPool.clone());
		meta.setVersionPath(versionPath);
		meta.setSysLanguage(sysLanguage);
		meta.setPassEnableTime(passEnableTime);
		meta.setPassErrorCount(passErrorCount);
		meta.setDisableKeyboard(disableKeyboard);
		meta.setServerVersion(serverVersion);
		meta.setAnimCollection(animCollection == null ? null : animCollection.clone());
		meta.setEncryptSetting(encryptSetting == null ? null : encryptSetting.clone());
		meta.setRequiredIcon(requiredIcon);
		meta.setCheckRuleErrorIcon(checkRuleErrorIcon);
		meta.setCheckRulePassIcon(checkRulePassIcon);
		meta.setFullscreenType(fullscreenType);
		meta.setStatusBarColor(statusBarColor);
		meta.setWatermark(watermark == null ? null : (MetaWatermark)watermark.clone());
		meta.setAppParas(appParas == null ? null : (MetaAppParas)appParas.clone());
		meta.setExtClassCollection(extClassCollection == null ? null : (MetaExtClassCollection)extClassCollection.clone());
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMobileDef();
	}
}
