package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTableLayout extends MetaComponentLayout<MetaLayoutSpan> {
	/** 列定义 */
	private MetaLayoutColumnCollection columnCollection = null;
	/** 行定义 */
	private MetaLayoutRowCollection rowCollection = null;
	
	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_TABLE;
	}
	
	/**
	 * 设置布局列集合
	 * @param columnCollection 布局列集合
	 */
	public void setColumnCollection(MetaLayoutColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}
	
	/**
	 * 取得布局列集合
	 * @return 布局列集合
	 */
	public MetaLayoutColumnCollection getColumnCollection() {
		return this.columnCollection;
	}
	
	/**
	 * 设置布局行集合
	 * @param rowCollection 布局行集合
	 */
	public void setRowCollection(MetaLayoutRowCollection rowCollection) {
		this.rowCollection = rowCollection;
	}
	
	/**
	 * 取得布局行集合
	 * @return 布局行集合
	 */
	public MetaLayoutRowCollection getRowCollection() {
		return this.rowCollection;
	}

	public static final String TAG_NAME = LayoutType.STR_LAYOUT_TABLE;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableLayout();
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaLayoutSpan.TAG_NAME.equals(tagName) ) {
			MetaLayoutSpan metaLayoutSpan = new MetaLayoutSpan();
			metaLayoutSpan.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaLayoutSpan);
			resultMetaObject = metaLayoutSpan;
		} else if ( MetaLayoutColumnCollection.TAG_NAME.equals(tagName) ) {
			columnCollection = new MetaLayoutColumnCollection();
			resultMetaObject = columnCollection;
		} else if ( MetaLayoutRowCollection.TAG_NAME.equals(tagName) ) {
			rowCollection = new MetaLayoutRowCollection();
			resultMetaObject = rowCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaTableLayout newLayout = (MetaTableLayout) super.clone();
		newLayout.setColumnCollection(columnCollection == null ? null : (MetaLayoutColumnCollection) columnCollection.clone());
		newLayout.setRowCollection(rowCollection == null ? null : (MetaLayoutRowCollection) rowCollection.clone());
		return newLayout;
	}

}
