package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaSplitLayout extends MetaComponentLayout<MetaLayoutSplitItem> {
	private Integer orientation = OrientationType.Horizontal;
	public MetaSplitLayout() {
		super();
	}
	
	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_SPLIT;
	}

	public static final String TAG_NAME = "SplitLayout";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSplitLayout();
	}
	
	public void setOrientation(Integer orientation) {
		this.orientation = orientation;
	}
	
	public Integer getOrientation() {
		return this.orientation;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaLayoutSplitItem.TAG_NAME.equals(tagName) ) {
			MetaLayoutSplitItem item = new MetaLayoutSplitItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaSplitLayout newLayout = (MetaSplitLayout) super.clone();
		newLayout.setOrientation(orientation);
		return newLayout;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for (MetaLayoutSplitItem splitItem : this) {
			if (splitItem == null || splitItem.getSize() == null) {
				throw new MetaException(MetaException.NO_DEFINITION_OF_SIZE,
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDefinitionOfSize), getKey(), splitItem.getKey()));
			}
		}
	}
}
