package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;

public class MetaLinearLayout extends MetaComponentLayout<MetaLinearItem> {
	public static final String TAG_NAME = LayoutType.STR_LAYOUT_LINEAR;
	
	/** 方向 */
	private Integer orientation = OrientationType.Horizontal;
	
	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_LINEAR;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置方向
	 * @param orientation 方向
	 */
	public void setOrientation(Integer orientation) {
		this.orientation = orientation;
	}
	
	/**
	 * 获取方向
	 * @return 方向
	 */
	public Integer getOrientation() {
		return this.orientation;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLinearLayout();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLinearLayout newObject = (MetaLinearLayout)super.clone();
		newObject.setOrientation(orientation);
		return newObject;
	}
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ("LinearItem".equals(tagName)) {
			MetaLinearItem item = new MetaLinearItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

}
