package com.bokesoft.yigo.meta.form.component.view.layout;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaLayoutSpan extends MetaLayoutItem {
	/** 列位置 */
	private Integer x = -1;
	/** 行位置 */
	private Integer y = -1;
	/** 列跨度 */
	private Integer xSpan = 1;
	/** 行跨度 */
	private Integer ySpan = 1;
	/** 高度 */
	private DefSize height = null;
	/** 宽度 */
	private DefSize width = null;
	/** 控件类型 */
	private int controlType ;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}
	
	/**
	 * 设置列位置
	 * @param x 列位置
	 */
	public void setX(Integer x) {
		this.x = x;
	}
	
	/**
	 * 取得列位置
	 * @return 列位置
	 */
	public Integer getX() {
		return this.x;
	}
	
	/**
	 * 设置行位置
	 * @param y 行位置
	 */
	public void setY(Integer y) {
		this.y = y;
	}
	
	/**
	 * 取得行位置
	 * @return 行位置
	 */
	public Integer getY() {
		return this.y;
	}
	
	/**
	 * 设置列跨度
	 * @param xSpan 列跨度
	 */
	public void setXSpan(Integer xSpan) {
		this.xSpan = xSpan;
	}
	
	/**
	 * 取得列跨度
	 * @return 列跨度
	 */
	public Integer getXSpan() {
		return this.xSpan;
	}
	
	/**
	 * 设置行跨度
	 * @param ySpan 行跨度
	 */
	public void setYSpan(Integer ySpan) {
		this.ySpan = ySpan;
	}
	
	/**
	 * 取得行跨度
	 * @return 行跨度
	 */
	public Integer getYSpan() {
		return this.ySpan;
	}
	
	/**
	 * 设置高度
	 * @param height 高度
	 */
	public void setHeight(DefSize height) {
		this.height = height;
	}
	
	/**
	 * 获取高度
	 * @return 高度
	 */
	public DefSize getHeight() {
		return height;
	}
	
	/**
	 * 设置宽度
	 * @param width 宽度
	 */
	public void setWidth(DefSize width) {
		this.width = width;
	}
	
	/**
	 * 获取宽度
	 * @return 宽度
	 */
	public DefSize getWidth() {
		return width;
	}
	
	/**
	 * 设置控件类型
	 * @param controlType 控件类型
	 */
	public void setControlType(int controlType) {
		this.controlType = controlType;
	}
	
	/**
	 * 获取控件类型
	 * @return 控件类型
	 */
	public int getControlType() {
		return controlType;
	}
	

	public static final String TAG_NAME = "LayoutSpan";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLayoutSpan newObject = (MetaLayoutSpan)super.clone();
		newObject.setX(x);
		newObject.setY(y);
		newObject.setXSpan(xSpan);
		newObject.setYSpan(ySpan);
		newObject.setHeight(height);
		newObject.setWidth(width);
		newObject.setControlType(controlType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLayoutSpan();
	}

}
