package com.bokesoft.yigo.meta.form.component.panel.gridpanel;/*
 *文件名: MetaGroupCollection
 *创建者: zhangk
 *创建时间:2022/9/10 15:03
 */

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

import java.util.LinkedList;

public class MetaGroupCollection extends GenericKeyCollection<MetaGroup> implements Cloneable, IPropertyMerger<MetaGroupCollection> {
	/**
	 * 标签名
	 */
	public static final String TAG_NAME = "GroupCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaGroup metaGroup = null;
		if (MetaGroup.TAG_NAME.equals(tagName)) {
			metaGroup = new MetaGroup();
			metaGroup.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaGroup);

		}
		return metaGroup;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGroupCollection();
	}

	@Override
	public void merge(MetaGroupCollection metaGroups) {
		for (MetaGroup metaGroup : metaGroups) {
			String key = metaGroup.getKey();
			MetaGroup metaGroup1 = this.get(key);
			// 如果不包括当前表则整体添加
			if (metaGroup1 == null) {
				this.add(metaGroup);
			} else {
				metaGroup1.merge(metaGroup);
			}
		}
	}


}
