package com.bokesoft.yigo.meta.form.component.panel.collapsepanel;
import java.util.ArrayList;
import java.util.LinkedList;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

/**
 * 折叠项对象
 * 
 * @author MY
 */
public class MetaCollapseItem extends MetaComponent{
	
    public static final String TAG_NAME = "CollapseItem";
    
	/** 折叠事件 */
	private MetaBaseScript collapseClick = null;
	
	/** 展开事件 */
	private MetaBaseScript expandClick = null;
	
	/** 显示标题 */
	private String caption;
	
	/** 图标 */
	private String icon;
	
	/** 右侧展开图标 */
	private String expandIcon;
	
	/** 右侧折叠图标 */
	private String collapseIcon;

	/** 折叠展开部分高度 */
	private DefSize collapseHeight;
	
	/** 是否默认展开 */
	private Boolean isExpand = false;
	
	/** 内部组件集合*/
	private ArrayList<MetaComponent> compList = new ArrayList<>();
	
	/** 右侧展开显示文字 */
	private String textOn;

	/** 右侧关闭显示文字 */
	private String textOff;
	
	/** 图片方位*/
	private Integer iconLocation = IconLocationType.LEFT;

	
	public Boolean getIsExpand() {
		return isExpand;
	}

	public void setIsExpand(Boolean isExpand) {
		this.isExpand = isExpand;
	}
	
	public Integer getIconLocation() {
		return iconLocation;
	}

	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}

	public String getTextOn() {
		return textOn;
	}

	public void setTextOn(String textOn) {
		this.textOn = textOn;
	}

	public String getTextOff() {
		return textOff;
	}

	public void setTextOff(String textOff) {
		this.textOff = textOff;
	}
	
	public MetaBaseScript getCollapseClick() {
		return collapseClick;
	}

	public void setCollapseClick(MetaBaseScript collapseClick) {
		this.collapseClick = collapseClick;
	}

	public MetaBaseScript getExpandClick() {
		return expandClick;
	}

	public void setExpandClick(MetaBaseScript expandClick) {
		this.expandClick = expandClick;
	}
	
	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	public String getExpandIcon() {
		return expandIcon;
	}
	
	public void setExpandIcon(String expandIcon) {
		this.expandIcon = expandIcon;
	}
	
	public String getCollapseIcon() {
		return collapseIcon;
	}
	
	public void setCollapseIcon(String collapseIcon) {
		this.collapseIcon = collapseIcon;
	}
	
	public DefSize getCollapseHeight() {
		return collapseHeight;
	}
	
	public void setCollapseHeight(DefSize collapseHeight) {
		this.collapseHeight = collapseHeight;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public void setCompList(ArrayList<MetaComponent> compList) {
		this.compList = compList;
	}

	public ArrayList<MetaComponent> getCompList() {
		return compList;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {collapseClick, expandClick});
		list.addAll(compList);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public boolean isStandaloneNode() {
		return true;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCollapseItem();
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if(resultMetaObject!=null){
			return resultMetaObject;
		}
        if (MetaConstants.COLLAPSE_ONCOLLAPSE.equals(tagName)) {
			collapseClick = new MetaBaseScript(MetaConstants.COLLAPSE_ONCOLLAPSE);
			resultMetaObject = collapseClick;
		} else if (MetaConstants.COLLAPSE_ONEXPAND.equals(tagName)) {
			expandClick = new MetaBaseScript(MetaConstants.COLLAPSE_ONEXPAND);
			resultMetaObject = expandClick;
		} else{
			MetaComponent component = MetaComponentFactory.getInstance().newComponent(tagName);
			if(component != null){
				component.preProcessMetaObject(env, doc, node, flag, runType);
				resultMetaObject = component;
				compList.add(component);
			}
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCollapseItem newObject = (MetaCollapseItem)super.clone();
		newObject.setCaption(caption);
		newObject.setIcon(icon);
		newObject.setIconLocation(iconLocation);
		newObject.setTextOn(textOn);
		newObject.setTextOff(textOff);
		newObject.setCollapseIcon(collapseIcon);
		newObject.setExpandIcon(expandIcon);
		newObject.setCollapseHeight(collapseHeight == null ? null : collapseHeight.clone());
		newObject.setCollapseClick(collapseClick == null ? null : (MetaBaseScript)collapseClick.clone());
		newObject.setExpandClick(expandClick == null ? null : (MetaBaseScript)expandClick.clone());
		ArrayList<MetaComponent> newList = new ArrayList<>();
		for (int i = 0; i < compList.size(); i++) {
			MetaComponent metaComponent = compList.get(i);
			newList.add((MetaComponent)metaComponent.clone());
		}
		newObject.setCompList(newList);
		return newObject;
	}

	@Override
	public int getControlType() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}
}
