package com.bokesoft.yigo.meta.form.component.panel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import org.apache.commons.lang3.StringUtils;

/**
 * 布局面板基础类，其他面板都是从此派生
 *
 * @author chenzs
 * @since YES1.0
 */
public abstract class MetaPanel extends MetaComponent {

    protected StringHashMap<MetaComponent> componentMap = null;
    /** 子控件集合，包含该控件范围内的所有子控件 */
    protected ArrayList<MetaComponent> componentArray = null;
    /** 水平滚动条处理方式 */
    private Integer overflowX = ScrollType.Visible;
    /** 垂直滚动条处理方式 */
    private Integer overflowY = ScrollType.Visible;
    /** 背景图片 */
    private String backImage = "";
    /** 背景图片位置 */
    private Integer backImagePosition = -1;
    /** 背景图片是否水平重复填充 */
    private Boolean backImageRepeatX = false;
    /** 背景图片是否垂直重复填充 */
    private Boolean backImageRepeatY = false;
    /**拉伸缩放类型 ImageScaleType*/
    private Integer backImageScaleType = -1;
    /** 布局动画 */
    private String layoutAnim = "";

    public MetaPanel() {
        super();
        componentArray = new ArrayList<MetaComponent>();
        componentMap = new StringHashMap<MetaComponent>();
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        list.add(componentArray);
        if( check != null ) {
            list.add(check);
        } else if(leave != null) {
            list.add(leave);
        }
    }

    @Override
    public abstract String getTagName();

    /** 检查事件 */
    private MetaBaseScript check = null;
    /** 离开事件 */
    private MetaBaseScript leave = null;

    /**
     * 生成一个当前面板的布局
     * @return 布局
     */
    public abstract MetaComponentLayout<?> newLayout();

    public MetaBaseScript getCheck() {
        return check;
    }

    public void setCheck(MetaBaseScript check) {
        this.check = check;
    }

    public MetaBaseScript getLeave() {
        return leave;
    }

    public void setLeave(MetaBaseScript leave) {
        this.leave = leave;
    }

    @Override
    public boolean receiveFocus() {
        return false;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
                                                    String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject obj = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        if(obj != null){
            return obj;
        }
        AbstractMetaObject resultMetaObject = null;
        if ( MetaConstants.Event_Check.equals(tagName) ) {
            check = new MetaBaseScript(MetaConstants.Event_Check);
            resultMetaObject = check;
        } else if( MetaConstants.Event_Leave.equals(tagName) ) {
            leave = new MetaBaseScript(MetaConstants.Event_Leave);
            resultMetaObject = leave;
        }
        if(resultMetaObject != null) {
            return resultMetaObject;
        }
        MetaComponent control = MetaComponentFactory.getInstance().newComponent(tagName);
        control.preProcessMetaObject(env, doc, node, flag, runType);
        this.addComponent(control);
        return control;
    }

    @Override
    public void addComponent(MetaComponent component) {
        if (Objects.isNull(component) || componentArray.contains(component)) {
            return;
        }
        if (StringUtils.isNotBlank(component.getKey()) && componentMap.containsKey(component.getKey())) {
            return;
        }
        componentArray.add(component);
        componentMap.put(component.getKey(), component);
    }

    public void addComponent(int index, MetaComponent component) {
        if (Objects.isNull(component) || componentArray.contains(component)) {
            return;
        }
        if (StringUtils.isNotBlank(component.getKey()) && componentMap.containsKey(component.getKey())) {
            return;
        }

        if (index < 0) {
            componentArray.add(0, component);
        } else if (index > componentArray.size() - 1) {
            componentArray.add(component);
        } else {
            componentArray.add(index, component);
        }
        componentMap.put(component.getKey(), component);
    }

    @Override
    public int getComponentCount() {
        return componentArray.size();
    }

    public void clear() {
        this.componentArray.clear();
        this.componentMap.clear();
    }

    @Override
    public MetaComponent getComponent(int index) {
        return componentArray.get(index);
    }

    public MetaComponent getComponent(String key) {
        return componentMap.get(key);
    }

    public boolean containsComponent(String key) {
        return componentMap.containsKey(key);
    }

    public Iterator<MetaComponent> iteratorComponent() {
        return componentArray.iterator();
    }

    public ArrayList<MetaComponent> getComponentArray(){
        return componentArray;
    }

    public void setComponentArray(ArrayList<MetaComponent> componentArray) {
        this.componentArray = componentArray;
    }

    /**
     * 设置水平滚动条处理方式
     * @param overflowX 处理方式
     */
    public void setOverflowX(Integer overflowX) {
        this.overflowX = overflowX;
    }

    /**
     * 取得水平滚动劫条处理方式
     * @return 处理方式
     */
    public Integer getOverflowX() {
        return this.overflowX;
    }

    /**
     * 设置垂直滚动条处理方式
     * @param overflowY 处理方式
     */
    public void setOverflowY(Integer overflowY) {
        this.overflowY = overflowY;
    }

    /**
     * 取得垂直滚动条处理方式
     * @return 处理方式
     */
    public Integer getOverflowY() {
        return this.overflowY;
    }

    /**
     * 设置背景图片
     * @param backImage 背景图片
     */
    public void setBackImage(String backImage) {
        this.backImage = backImage;
    }

    /**
     * 取得背景图片
     * @return 背景图片
     */
    public String getBackImage() {
        return this.backImage;
    }

    /**
     * 设置背景图片位置
     * @param backImagePosition 背景图片位置
     */
    public void setBackImagePosition(Integer backImagePosition) {
        this.backImagePosition = backImagePosition;
    }

    /**
     * 取得背景图片位置
     * @return 背景图片位置
     */
    public Integer getBackImagePosition() {
        return this.backImagePosition;
    }

    /**
     * 设置是否水平重复填充背景图片
     * @param backImageRepeatX 重复标志
     */
    public void setBackImageRepeatX(Boolean backImageRepeatX) {
        this.backImageRepeatX = backImageRepeatX;
    }

    /**
     * 取得是否水平重复填充背景图片
     * @return 重复标志
     */
    public Boolean isBackImageRepeatX() {
        return this.backImageRepeatX;
    }

    /**
     * 设置是否垂直重复填充背景图片
     * @param backImageRepeatY 重复标志
     */
    public void setBackImageRepeatY(Boolean backImageRepeatY) {
        this.backImageRepeatY = backImageRepeatY;
    }

    /**
     * 取得是否垂直填充背景图片
     * @return 重复标志
     */
    public Boolean isBackImageRepeatY() {
        return this.backImageRepeatY;
    }
    
    /**
     * 设置背景图片拉伸缩类型
     * @param backImageScaleType 拉伸缩类型
     */
    public void setBackImageScaleType(Integer backImageScaleType) {
		this.backImageScaleType = backImageScaleType;
	}
    
    /**
     * 获取背景图片拉伸缩类型
     * @return 拉伸缩类型
     */
    public Integer getBackImageScaleType() {
		return backImageScaleType;
	}

    /**
     * 设置布局动画
     * @param layoutAnim 布局动画
     */
    public void setLayoutAnim(String layoutAnim) {
        this.layoutAnim = layoutAnim;
    }

    /**
     * 获取布局动画
     * @return 布局动画
     */
    public String getLayoutAnim() {
        return layoutAnim;
    }

    @Override
    public boolean isPanel() {
        return true;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaPanel newObject = (MetaPanel)super.clone();
        if (componentArray != null) {
            Iterator<MetaComponent> it = componentArray.iterator();
            MetaComponent metaComponent = null;
            while ( it.hasNext() ) {
                metaComponent = it.next();
                MetaComponent newMetaComponent = (MetaComponent)metaComponent.clone();
                newObject.addComponent(newMetaComponent);
            }
        }

        newObject.setOverflowX(overflowX);
        newObject.setOverflowY(overflowY);
        newObject.setBackImage(backImage);
        newObject.setBackImagePosition(backImagePosition);
        newObject.setBackImageRepeatX(backImageRepeatX);
        newObject.setBackImageRepeatY(backImageRepeatY);
        newObject.setBackImageScaleType(backImageScaleType);
        newObject.setLayoutAnim(layoutAnim);
        return newObject;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        Iterator<MetaComponent> it = componentArray.iterator();
        MetaComponent metaComponent = null;
        while ( it.hasNext() ) {
            metaComponent = it.next();
            metaComponent.doPostProcess(flag, callback);
        }
    }

    /**
     * 移除控件
     * @param component 控件
     */
    public void removeComponent(MetaComponent component) {
        componentArray.remove(component);
        componentMap.remove(component.getKey());
    }

    /**
     * 根据标识移除控件
     * @param key
     */
    public void removeComponent(String key) {
        MetaComponent comp = componentMap.get(key);
        componentArray.remove(comp);
        componentMap.remove(key);
    }

    @Override
    public void merge(MetaComponent meta) {
        super.merge(meta);
        MetaPanel metaPanel = (MetaPanel)meta;
        if( this.overflowX == -1 ) {
            this.overflowX = metaPanel.getOverflowX();
        }
        if( this.overflowY == -1 ) {
            this.overflowY = metaPanel.getOverflowY();
        }
        if( this.backImage == null ) {
            this.backImage = metaPanel.getBackImage();
        }
        if( this.backImagePosition == -1 ) {
            this.backImagePosition = metaPanel.getBackImagePosition();
        }
        if( this.backImageRepeatX == null ) {
            this.backImageRepeatX = metaPanel.isBackImageRepeatX();
        }
        if( this.backImageRepeatY == null ) {
            this.backImageRepeatY = metaPanel.isBackImageRepeatY();
        }
        if( this.backImageScaleType == -1 ) {
            this.backImageScaleType = metaPanel.getBackImageScaleType();
        }
        if(layoutAnim == null){
            this.layoutAnim = metaPanel.getLayoutAnim();
        }
    }
}
