package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridRowArea定义行区域，派生对象
 * @author 王元和
 *
 */
public class MetaGridRowArea extends AbstractMetaObject implements IMetaGridRowObject {
	/** 区域中对象集合 */
	private ArrayList<IMetaGridRowObject> objectArray = null;
	/** 区域中分组对象的集合(按层次顺序存储) */
	private ArrayList<MetaGridRowGroup> groupArray = null;
	
	public MetaGridRowArea() {
		super();
		objectArray = new ArrayList<IMetaGridRowObject>();
		groupArray = new ArrayList<MetaGridRowGroup>();
	}
	
	@Override
	public int getObjectType() {
		return IMetaGridRowObject.Area;
	}

	@Override
	public void printDebugInfo(int level) {
		LogSvr.getInstance().info("row area ----> " + level);
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		IMetaGridRowObject row = null;
		while ( it.hasNext() ) {
			row = it.next();
			row.printDebugInfo(level + 1);
		}
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "RowArea";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	public void addObject(IMetaGridRowObject row) {
		this.objectArray.add(row);
	}
	
	public int getObjectCount() {
		return this.objectArray.size();
	}
	
	public IMetaGridRowObject getObject(int index) {
		return this.objectArray.get(index);
	}
	
	public void remove(int index){
		this.objectArray.remove(index);
	}
	
	public void add(int index,IMetaGridRowObject obj){
		this.objectArray.add(index, obj);
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGridRowArea rowArea = (MetaGridRowArea) this.newInstance();
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		IMetaGridRowObject obj = null;
		while(it.hasNext()){
			obj = it.next();
			if( obj.getObjectType() == IMetaGridRowObject.Row ){
				MetaGridRow metaRow = (MetaGridRow)obj;
				rowArea.addObject((IMetaGridRowObject) metaRow.clone());
			}else if( obj.getObjectType() == IMetaGridRowObject.Group ){
				MetaGridRowGroup rowGroup = (MetaGridRowGroup)obj;
				rowArea.addObject((IMetaGridRowObject) rowGroup.clone());
			}
		}
		rowArea.extract();
		return rowArea;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridRowArea();
	}

	@Override
	public void getAll(int objectType, ArrayList<IMetaGridRowObject> list) {
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		IMetaGridRowObject rowObject = null;
		while ( it.hasNext() ) {
			rowObject = it.next();
			if ( rowObject.getObjectType() == objectType ) {
				list.add(rowObject);
			}
			rowObject.getAll(objectType, list);
		}
	}
	
	public void extract() {
		ArrayList<IMetaGridRowObject> groupArray = new ArrayList<IMetaGridRowObject>();
		getAll(IMetaGridRowObject.Group, groupArray);
		for( int i = 0,size = groupArray.size();i < size;i++ ) {
			MetaGridRowGroup rowGroup = (MetaGridRowGroup) groupArray.get(i);
			this.groupArray.add(rowGroup);
		}
	}
	
	public MetaGridRowGroup getGroup(int index) {
		return groupArray.get(index);
	}
}
