package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridColumnArea定义列区域，派生对象
 * @author 王元和
 *
 */
public class MetaGridColumnArea extends AbstractMetaObject implements
		IMetaGridColumnObject {
	private ArrayList<IMetaGridColumnObject> objectArray = null;

	public MetaGridColumnArea() {
		super();
		objectArray = new ArrayList<IMetaGridColumnObject>();
	}
	
	@Override
	public int getObjectType() {
		return IMetaGridColumnObject.Area;
	}

	@Override
	public void printDebugInfo(int level) {
		LogSvr.getInstance().info("column area ----> " + level);
		Iterator<IMetaGridColumnObject> it = objectArray.iterator();
		IMetaGridColumnObject column = null;
		while ( it.hasNext() ) {
			column = it.next();
			column.printDebugInfo(level + 1);
		}
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "ColumnArea";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 增加列对象
	 * @param column 列对象
	 */
	public void addObject(IMetaGridColumnObject column) {
		this.objectArray.add(column);
	}
	
	/**
	 * 取得列对象的数量
	 * @return 列对象数量
	 */
	public int getObjectCount() {
		return objectArray.size();
	}
	
	/**
	 * 根据位置取得列对象
	 * @param index 位置
	 * @return 对应位置的列对象
	 */
	public IMetaGridColumnObject getObject(int index) {
		return objectArray.get(index);
	}

	@Override
	public void getAll(int objectType, ArrayList<IMetaGridColumnObject> list) {
		Iterator<IMetaGridColumnObject> it = objectArray.iterator();
		IMetaGridColumnObject column = null;
		while ( it.hasNext() ) {
			column = it.next();
			if ( column.getObjectType() == objectType ) {
				list.add(column);
			}
			column.getAll(objectType, list);
		}
	}
	
	/** 当前区域包含的最左列 */
	private int left = -1;
	/** 当前区域包含的最右列 */
	private int right = -1;
	
	/**
	 * 设置最左列
	 * @param left 列序号
	 */
	public void setLeft(int left) {
		this.left = left;
	}
	
	/**
	 * 取得最左列
	 * @return 列序号
	 */
	public int getLeft() {
		return this.left;
	}
	
	/**
	 * 设置最右列(不包括汇总列)
	 * @param right 列序号
	 */
	public void setRight(int right) {
		this.right = right;
	}
	
	/**
	 * 取得最右列(不包括汇总列)
	 * @return 列序号
	 */
	public int getRight() {
		return this.right;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}
}
