package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Arrays;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ColumnExpandType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.GridTreeType;
import com.bokesoft.yigo.common.def.GroupType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.SelectionMode;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.properties.*;

/**
 * MetaGrid定义表格的元数据描述，除了一般组件的属性外，表格的元数据还包括列定义的集合和行定义的集合；一个表格由多列、多行组成，每行中均具有相同的
 * 单元格数量(由列集合定义)。 列集合的定义参见{@link MetaGridColumnCollection}，行集合的定义参见
 * {@link MetaGridRowCollection}。
 *
 * @author 王元和
 * @author 陈瑞
 * @see MetaComponent
 * @see MetaGridColumnCollection
 * @see MetaGridRowCollection
 */
public class MetaGrid extends MetaComponent implements IGridComponent {
	/**
	 *
     */
    private static final long serialVersionUID = 1L;
    public static final String TAG_NAME = ControlType.STR_GRID;
    /** 列元数据集合 */
    private MetaGridColumnCollection columnCollection = null;
    /** 行元数据集合 */
    private MetaGridRowCollection rowCollection = null;
    /** 追溯集合*/
    private MetaTraceCollection traceCollection = null;
    /** 编辑时是否隐藏分组行 */
    private Boolean hideGroup4Editing = false;
    /** 在编辑状态下是否新增一个空行*/
    private String newEmptyRow = "true";
    /** 额外配置的操作集合*/
    private MetaExtOptCollection extOpts = null;

    /** 列是否可拖动排序*/
    private Boolean sortable = null;
    /** 是否可根据条件定位行*/
    private Boolean locate = null;
    /** 打开是否默认最佳列宽*/
    private Boolean defaultFitWidth = null;
    /** 是否显示总行数*/
    private Boolean showTotalRowCount = null;
    /** 操作定义*/
    private String option = null;
    /** 不需要的操作定义*/
    private String disabledOption = null;
    /** 行编辑表单标识*/
    private String editRowFormKey = "";

    /** 表格的选择模式,默认是范围模式,-1表示未定义*/
    private Integer selectMode = SelectionMode.RANGE;
    /** 分页类型,默认不分页,-1表示未定义*/
    private Integer pageLoadType = PageLoadType.NONE;
    /** 分页时 每页显示行数*/
    private Integer pageRowCount = 50;
    /** 分页时 显示最大页码*/
    private Integer pageIndicatorCount = 5;
    /** 分页时,每页显示行数列表*/
    private String rowRange = "";
    /** 表格排序公式定义*/
    private String gridDefaultSortField = "";
    /** 锁定的行数*/
    private Integer freezeRowCount = 0;
    /** 锁定的列数(左边)*/
    private Integer freezeLeftColCount = 0;
    /** 锁定的列数(右边)*/
    private Integer freezeRightColCount = 0;
    /** 行点击事件 */
    private MetaBaseScript rowClick = null;
    /** 行双击事件 */
    private MetaBaseScript rowDblClick = null;
    /** 焦点行改变事件 */
    private MetaBaseScript focusRowChanged = null;
    /** 行添加前事件*/
    private MetaBaseScript beforeRowInsert = null;
    /** 行添加事件*/
    private MetaBaseScript rowInsert = null;
    /** 行删除后事件*/
    private MetaBaseScript rowDelete = null;
    /** 行删除事件*/
    private MetaBaseScript onRowDelete = null;
    /** 是否显示行头序号列*/
    private Boolean showRowHead = true;
    /** 数据过滤条件*/
    private MetaGridFilter filter = null;
    /** 行区域拓展*/
    private MetaRowAreaExpand rowAreaExpand = null;
    /** 序列号是否连续*/
    private Boolean serialSeq = false;
    /** 翻页序号是否连续*/
    private Boolean serialRowNum = false;
    /** 方向键直接结束编辑*/
    private Boolean endEditByNav = false;
    /** 插行时是否同步插入数据行*/
    private Boolean addDataRow = false;

    //-----------------------后期处理获得的属性---------------------------
    /** 树形的位置*/
    private Integer treeIndex = -1;
    /** 行拓展的位置*/
    private Integer rowExpandIndex = -1;
    /** 子叶列集合 */
    private List<MetaGridColumn> leafColumns = new ArrayList<MetaGridColumn>();
    /** 列与序号的映射*/
    private Map<String, Integer> leafIndexMap = new HashMap<String,Integer>();
    /** 分组单元格序号集合*/
    private List<Integer> groupIndexes = new ArrayList<Integer>();
    /** 分组的单元格标识集合*/
    private List<String> groupCells = new ArrayList<String>();
    /** 需要处理合并的单元格集合*/
    private List<String> mergeCells = new ArrayList<String>();
    /** 需要处理数据业务主键映射的表集合*/
    private List<String> tableKeys = new ArrayList<String>();
    /** 业务字段集合*/
    private List<String> primaryKeys = new ArrayList<String>();
    /** 列层次结构的根对象 */
    private MetaGridColumnLayer rootColumnLayer = null;
    /** 行层次结构的根对象 */
    private MetaGridRowLayer rootRowLayer = new MetaGridRowLayer();
    /** 明细行*/
    private MetaGridRow detailMetaRow = null;
    /** 是否列拓展 */
    private boolean hasColumnExpand = false;
    /** 是否单元格拓展*/
    private boolean hasCellExpand = false;
    /** 是否行拓展*/
    private boolean hasRowExpand = false;
    /** 是否有子明细*/
    private boolean hasSubDetail = false;
    /** 选择字段位置*/
    private int selectIndex = -1;
    /** 是否单选*/
    private boolean singleSelect = false;
    /** 是否有分组 */
    private boolean hasRowGroup = false;
    /** 是否含有汇总行*/
    private boolean hasTotalRow = false;
    /** 是否含有明细行*/
    private boolean hasDetailRow = false;
    /** 是否含有固定行*/
    private boolean hasFixRow = false;
    /** 是否有定制数据*/
    private boolean hasCustomData = false;
    /** 是否有固定行单元格合并*/
    private boolean hasFixCellMerge = false;
    /** 明细之前固定类型行(固定行和汇总行)的数量*/
    private int topFixRowCount = 0;
    /** 明细之后固定类型行(固定行和汇总行)的数量*/
    private int bottomFixRowCount = 0;
    /** 汇总行位置*/
	private boolean totalFirst = false;

	//------------以上部分为运行时计算属性，不需要在复制时处理-------------------------------------------------------------

	public boolean hasTotalRow() {
		return hasTotalRow;
	}

	public boolean hasFixCellMerge() {
		return hasFixCellMerge;
	}

	public boolean totalFirst() {
		return totalFirst;
	}

	public void setTotalFirst(boolean totalFirst) {
		this.totalFirst = totalFirst;
	}

	public boolean hasDetailCellMerge() {
		return !mergeCells.isEmpty();
	}

	public Integer getSelectMode() {
		return selectMode;
	}

	public void setSelectMode(Integer selectMode) {
		this.selectMode = selectMode;
	}

	public boolean hasFixRow() {
		return hasFixRow;
	}

	public void setHasFixRow(boolean hasFixRow) {
		this.hasFixRow = hasFixRow;
	}

	public void setHasTotalRow(boolean hasTotalRow) {
		this.hasTotalRow = hasTotalRow;
	}

	public void setHasFixCellMerge(boolean hasFixCellMerge) {
		this.hasFixCellMerge = hasFixCellMerge;
	}

	public boolean hasDetailRow() {
		return hasDetailRow;
	}

	public void setHasDetailRow(boolean hasDetailRow) {
		this.hasDetailRow = hasDetailRow;
	}

	public boolean hasSubDetail() {
		return hasSubDetail;
	}

	public void setHasSubDetail(boolean hasSubDetail) {
		this.hasSubDetail = hasSubDetail;
	}

	public Boolean getDefaultFitWidth() {
		return defaultFitWidth;
	}

	public void setDefaultFitWidth(Boolean defaultFitWidth) {
		this.defaultFitWidth = defaultFitWidth;
	}

	public void setHasTree(boolean hasTree) {
		this.hasTree = hasTree;
	}

	public List<String> getPrimaryKeys() {
		return primaryKeys;
	}

	public void setPrimaryKeys(List<String> primaryKeys) {
		this.primaryKeys = primaryKeys;
	}

	public Integer getDefaultLayer() {
		MetaGridRow detailRow = this.getDetailMetaRow();
		return detailRow == null ? null : detailRow.getDefaultLayer();
	}

	/**
	 * 设置行点击事件
	 * @param rowClick 定义
	 */
	public void setRowClick(MetaBaseScript rowClick) {
		this.rowClick = rowClick;
	}

	/**
	 * 取得行击点事件
	 * @return 定义
	 */
	public MetaBaseScript getRowClick() {
		return this.rowClick;
	}

	/**
	 * 设置行双击事件
	 * @param rowDblClick 定义
	 */
	public void setRowDblClick(MetaBaseScript rowDblClick) {
		this.rowDblClick = rowDblClick;
	}

	/**
	 * 取得行双击事件
	 * @return 定义
	 */
	public MetaBaseScript getRowDblClick() {
		return this.rowDblClick;
	}

	/**
	 * 设置焦点行改变事件
	 * @param focusRowChanged 定义
	 */
	public void setFocusRowChanged(MetaBaseScript focusRowChanged) {
		this.focusRowChanged = focusRowChanged;
	}

	/**
	 * 取得焦点行改变事件
	 * @return 定义
	 */
	public MetaBaseScript getFocusRowChanged() {
		return this.focusRowChanged;
	}

	/**
	 * 获取表格的行增加前事件
	 * @return 行增加前事件定义
	 */
	public MetaBaseScript getBeforeRowInsert() {
		return beforeRowInsert;
	}

	/**
	 * 设置表格的行增加前事件
	 * @param beforeRowInsert 行增加前事件定义
	 */
	public void setBeforeRowInsert(MetaBaseScript beforeRowInsert) {
		this.beforeRowInsert = beforeRowInsert;
	}

	/**
	 * 获取表格的行增加事件
	 * @return 行增加事件定义
	 */
	public MetaBaseScript getRowInsert() {
		return rowInsert;
	}

	/**
	 * 设置表格的行增加事件
	 * @param rowInsert 行增加事件定义
	 */
	public void setRowInsert(MetaBaseScript rowInsert) {
		this.rowInsert = rowInsert;
	}

	/**
	 * 获取表格的行删除后事件
	 * @return 行删除事件定义
	 */
	public MetaBaseScript getRowDelete() {
		return rowDelete;
	}

	/**
	 * 设置表格的行删除后事件
	 * @param rowDelete 行删除事件定义
	 */
	public void setRowDelete(MetaBaseScript rowDelete) {
		this.rowDelete = rowDelete;
	}

	/**
	 * 获取表格的行删除事件
	 */
	public MetaBaseScript getOnRowDelete() {
		return onRowDelete;
	}

	/**
	 * 设置表格的行删除事件
	 */
	public void setOnRowDelete(MetaBaseScript onRowDelete) {
		this.onRowDelete = onRowDelete;
	}

	/**
	 * 获取不需要的操作定义
	 * @return 不需要的操作定义
	 */
	public String getDisabledOption() {
		return disabledOption;
	}

	/**
	 * 设置不需要的操作定义
	 * @param disabledOption 不需要的操作定义
	 */
	public void setDisabledOption(String disabledOption) {
		this.disabledOption = disabledOption;
	}

	/**
	 * 获取需要的操作定义
	 * @return 需要的操作定义
	 */
	public String getOption() {
		return option;
	}

	/**
	 * 设置需要的操作定义
	 * @param option 需要的操作定义
	 */
	public void setOption(String option) {
		this.option = option;
	}

	/**
	 * 获取额外配置的操作集合
	 * @return 操作集合
	 */
	public MetaExtOptCollection getExtOpts() {
		return extOpts;
	}

	/**
	 * 设置额外配置的操作集合
	 * @param extOpts 操作集合
	 */
	public void setExtOpts(MetaExtOptCollection extOpts) {
		this.extOpts = extOpts;
	}

	public Boolean getSortable() {
		return sortable;
	}

	public void setSortable(Boolean sortable) {
		this.sortable = sortable;
	}

	/**
	 * 获取行编辑表单标识
	 * @return
	 */
	public String getEditRowFormKey() {
		return editRowFormKey;
	}

	/**
	 * 设置行编辑表单标识
	 * @param editRowFormKey
	 */
	public void setEditRowFormKey(String editRowFormKey) {
		this.editRowFormKey = editRowFormKey;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGrid newObject = (MetaGrid) super.clone();
		newObject.setColumnCollection(columnCollection == null ? null
				: (MetaGridColumnCollection) columnCollection.clone());
		newObject.setRowCollection(rowCollection == null ? null
				: (MetaGridRowCollection) rowCollection.clone());
		newObject.setExtOpts(extOpts == null ? null
				: (MetaExtOptCollection) extOpts.clone());
		newObject.setNewEmptyRow(newEmptyRow);
		newObject.setPageRowCount(pageRowCount);
		newObject.setRowRange(rowRange);
		newObject.setPageIndicatorCount(pageIndicatorCount);
		newObject.setSelectMode(selectMode);

		newObject.setPageLoadType(pageLoadType);
		newObject.setShowRowHead(showRowHead);
		newObject.setHideGroup4Editing(hideGroup4Editing);

		newObject.setLocate(locate);
		newObject.setGridDefaultSortField(gridDefaultSortField);

		newObject.setShowTotalRowCount(showTotalRowCount);
		newObject.setOption(option);
		newObject.setDisabledOption(disabledOption);
		newObject.setEditRowFormKey(editRowFormKey);

		newObject.setTreeIndex(treeIndex);
		newObject.setRowExpandIndex(rowExpandIndex);
		newObject.setSelectIndex(selectIndex);
		newObject.setSingleSelect(singleSelect);

		newObject.setSerialSeq(serialSeq);
		newObject.setSerialRowNum(serialRowNum);

		newObject.setEndEditByNav(endEditByNav);
		newObject.setDefaultFitWidth(defaultFitWidth);
		newObject.setAddDataRow(addDataRow);

		newObject.setFilter(filter);

		newObject.setRowClick(rowClick == null ? null : (MetaBaseScript) rowClick.clone());
		newObject.setRowDblClick(rowDblClick == null ? null : (MetaBaseScript) rowDblClick.clone());
		newObject.setFocusRowChanged(focusRowChanged == null ? null : (MetaBaseScript) focusRowChanged.clone());
		newObject.setRowInsert(rowInsert == null ? null : (MetaBaseScript) rowInsert.clone());
		newObject.setBeforeRowInsert(beforeRowInsert == null ? null : (MetaBaseScript) beforeRowInsert.clone());
		newObject.setRowDelete(rowDelete == null ? null : (MetaBaseScript) rowDelete.clone());
		newObject.setOnRowDelete(onRowDelete == null ? null : (MetaBaseScript) onRowDelete.clone());
		newObject.setRootRowLayer(rootRowLayer == null ? null : (MetaGridRowLayer) rootRowLayer.clone());
		newObject.setRootColumnLayer(rootColumnLayer == null ? null : (MetaGridColumnLayer) rootColumnLayer.clone());
		newObject.setRowAreaExpand(rowAreaExpand == null ? null : (MetaRowAreaExpand) rowAreaExpand.clone());
		newObject.setTraceCollection(traceCollection == null ? null : (MetaTraceCollection) traceCollection.clone());
		newObject.setExtOpts(extOpts == null ? null : (MetaExtOptCollection) extOpts.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaGridColumnCollection.TAG_NAME.equals(tagName)) {
			columnCollection = new MetaGridColumnCollection();
			metaObject = columnCollection;
		} else if (MetaGridRowCollection.TAG_NAME.equals(tagName)) {
			rowCollection = new MetaGridRowCollection();
			metaObject = rowCollection;
		} else if (MetaConstants.Event_RowClick.equals(tagName)) {
			rowClick = new MetaBaseScript(MetaConstants.Event_RowClick);
			metaObject = rowClick;
		} else if (MetaConstants.Event_RowDblClick.equals(tagName)) {
			rowDblClick = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			metaObject = rowDblClick;
		} else if (MetaConstants.Event_FocusRowChanged.equals(tagName)) {
			focusRowChanged = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			metaObject = focusRowChanged;
		} else if (MetaConstants.Event_BeforeRowInsert.equals(tagName)) {
			beforeRowInsert = new MetaBaseScript(MetaConstants.Event_BeforeRowInsert);
			metaObject = beforeRowInsert;
		} else if (MetaConstants.Event_RowInsert.equals(tagName)) {
			rowInsert = new MetaBaseScript(MetaConstants.Event_RowInsert);
			metaObject = rowInsert;
		} else if (MetaConstants.Event_RowDelete.equals(tagName)) {
			rowDelete = new MetaBaseScript(MetaConstants.Event_RowDelete);
			metaObject = rowDelete;
		} else if (MetaConstants.Event_OnRowDelete.equals(tagName)) {
			onRowDelete = new MetaBaseScript(MetaConstants.Event_OnRowDelete);
			metaObject = onRowDelete;
		} else if (MetaGridFilter.TAG_NAME.equals(tagName)) {
			filter = new MetaGridFilter();
			metaObject = filter;
		} else if (MetaRowAreaExpand.TAG_NAME.equals(tagName)) {
			MetaRowAreaExpand rowAreaExpand = new MetaRowAreaExpand();
			metaObject = rowAreaExpand;
			this.rowAreaExpand = rowAreaExpand;
		} else if (MetaTraceCollection.TAG_NAME.equals(tagName)) {
			MetaTraceCollection traceCollection = new MetaTraceCollection();
			metaObject = traceCollection;
			this.traceCollection = traceCollection;
		} else if (MetaExtOptCollection.TAG_NAME.equals(tagName)) {
			MetaExtOptCollection optCollection = new MetaExtOptCollection();
			metaObject = optCollection;
			this.extOpts = optCollection;
		}

		if (metaObject == null) {
			metaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}

		if (metaObject != null) {
			metaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return metaObject;
	}

	private void reset() {
		this.leafColumns.clear();
		this.leafIndexMap.clear();
		this.groupIndexes.clear();
		this.groupCells.clear();
		this.mergeCells.clear();
		this.tableKeys.clear();
		this.detailMetaRow = null;
		this.hasColumnExpand = false;
		this.hasCellExpand = false;
		this.hasRowExpand = false;
		this.selectIndex = -1;
		this.treeIndex = -1;
		this.rowExpandIndex = -1;
		this.singleSelect = false;
		this.hasRowGroup = false;
		this.hasTotalRow = false;
		this.hasDetailRow = false;
		this.hasFixRow = false;
		this.hasCustomData = false;
		this.hasFixCellMerge = false;
		this.totalFirst = false;
		this.topFixRowCount = 0;
		this.bottomFixRowCount = 0;
	}

	/**
	 * 表格元数据的后期处理，做以下处理：
	 * <ul>
	 * <li>处理单元格中的表标识
	 * <li>从行对象集合中生成行分组数据
	 * <li>从列对象集合中生成列分组数据
	 * </ul>
	 */
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);

		reset();

		process();

		if (rootRowLayer != null) {
			rootRowLayer.doPostProcess(flag, callback);
		}

		if (rowCollection != null) {
			rowCollection.doPostProcess(flag, callback);
		}

		if (columnCollection != null) {
			columnCollection.doPostProcess(flag, callback);
		}

		if (filter != null) {
			filter.doPostProcess(flag, callback);
		}

		processRelation();
	}

	/**
	 * 表格结构和数据显示依赖的组件
	 */
	private Set<String> ownDepFields = new HashSet<String>();

	/**
	 * 单元格和其依赖的组件映射
	 */
	private Map<String, List<String>> cellDepFields = new HashMap<String, List<String>>();

	/**
	 * 获取表格结构和数据显示依赖的组件集合
	 * @return 表格结构的数据显示依赖的组件集合
	 */
	public Set<String> getOwnerDepFields() {
		return ownDepFields;
	}

	/**
	 * 获取单元格依赖组件映射
	 * @return 获取单元格依赖组件映射
	 */
	public Map<String, List<String>> getCellDepFields() {
		return cellDepFields;
	}

	/**
	 * 添加单元格依赖组件
	 */
	private void addCellDepFields(String cellKey, List<String> list) {
		List<String> fields = this.cellDepFields.get(cellKey);
		if (fields == null) {
			fields = new ArrayList<String>();
			this.cellDepFields.put(cellKey, fields);
		}
		fields.addAll(list);
	}

	/**
	 * 添加单元格依赖组件
	 */
	private void addCellDepFields(String cellKey, String field) {
		List<String> fields = this.cellDepFields.get(cellKey);
		if (fields == null) {
			fields = new ArrayList<String>();
			this.cellDepFields.put(cellKey, fields);
		}
		fields.add(field);
	}

	/**
	 * 获取行区域拓展
	 * @return 行区域拓展
	 */
	public MetaRowAreaExpand getRowAreaExpand() {
		return rowAreaExpand;
	}

	/**
	 * 设置行区域拓展
	 * @param rowAreaExpand 行区域拓展
	 */
	public void setRowAreaExpand(MetaRowAreaExpand rowAreaExpand) {
		this.rowAreaExpand = rowAreaExpand;
	}

	/**
	 * 由于克隆时,拓展信息不带过去,所以在克隆后,需要做一些预处理
	 */
	private void process() {
		reset();
		processRow();            // 行预处理
		processColumn();       // 列预处理
		processCell();         // 单元格预处理
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		this.addAll(list, new Object[]{
				columnCollection,
				rowCollection,
				rowClick,
				rowDblClick,
				beforeRowInsert,
				rowInsert,
				rowDelete,
				onRowDelete,
				rowAreaExpand,
				traceCollection,
				extOpts,
				focusRowChanged,
				filter});
	}

	/**
	 * 取得列对象集合
	 *
	 * @return 列对象集合
	 * @see MetaGridColumnCollection
	 */
	public MetaGridColumnCollection getColumnCollection() {
		return this.columnCollection;
	}

	/**
	 * 取得列层次结构的根对象
	 *
	 * @return 列层次结构的根对象{@link MetaGridColumnLayer}
	 */
	public MetaGridColumnLayer getColumnLayer() {
		return this.rootColumnLayer;
	}

	/**
	 * 获取表格过滤
	 * @return 表格过滤
	 */
	public MetaGridFilter getFilter() {
		return filter;
	}

	/**
	 * 设置表格过滤
	 * @param filter 表格过滤
	 */
	public void setFilter(MetaGridFilter filter) {
		this.filter = filter;
	}

	@Override
	public int getControlType() {
		return ControlType.GRID;
	}

    /** 明细行位置*/
	private int detailRowIndex = -1;

	/**
	 * 获取明细行,如果存在多明细行,返回主明细行
	 * @return 主明细行, 没有返回NULL
	 */
	public MetaGridRow getDetailMetaRow() {
		if (detailMetaRow == null && rowCollection != null) {
			MetaGridRow metaRow = null;
			for (int i = 0, size = rowCollection.size(); i < size; i++) {
				metaRow = rowCollection.get(i);
				if (metaRow.getRowType() == RowType.Detail && metaRow.getRefKey().isEmpty()) {
					detailMetaRow = metaRow;
					detailRowIndex = i;
					break;
				}
			}
		}
		return detailMetaRow;
	}

	/**
	 * 根据行号获取行
	 * @param index 行号
	 * @return 行对象
	 */
	public MetaGridRow getMetaRow(int index) {
		return rowCollection.get(index);
	}

	/**
	 * 根据数据绑定找到明细行单元格
	 * @param columnKey 明细单元格列标识
	 * @return 单元格对象
	 */
	public MetaGridCell getMetaCellByColumnKey(String columnKey) {
		MetaGridRow detailRow = this.getDetailMetaRow();
		if (detailRow == null) {
			return null;
		}
		MetaGridCell metaCell = null;
		String _columnKey = "";
		for (int i = 0, size = detailRow.size(); i < size; i++) {
			metaCell = detailRow.get(i);
			_columnKey = metaCell.getColumnKey();
			if (_columnKey != null && _columnKey.equals(columnKey)) {
				return metaCell;
			}
		}
		return null;
	}

	/**
	 * 获取明细行序号
	 * @return 明细行的行序号
	 */
	public int getDetailMetaRowIndex() {
		this.getDetailMetaRow();
		return detailRowIndex;
	}

	public void setDetailRowIndex(int detailRowIndex) {
		this.detailRowIndex = detailRowIndex;
	}

	/**
	 * 获取根分组
	 * @return 根分组对象
	 */
	public MetaGridRowGroup getRootGroup() {
		return rootRowLayer.getRootGroup();
	}

	/**
	 * 取得分页类型
	 * @return 分页类型
	 */
	@Override
	public Integer getPageLoadType() {
		return this.pageLoadType;
	}

	/**
	 * 取得每页行数
	 * @return 行数
	 */
	public Integer getPageRowCount() {
		return this.pageRowCount;
	}

	/**
	 * 取得页码总数
	 * @return 页码总数
	 */
	public Integer getPageIndicatorCount() {
		return this.pageIndicatorCount;
	}

	/**
	 * 设置页码总数
	 * @param pageIndicatorCount 页码总数
	 */
	public void setPageIndicatorCount(Integer pageIndicatorCount) {
		this.pageIndicatorCount = pageIndicatorCount;
	}

	/**
	 * 获取每页显示的行数范围
	 * @return 行数范围
	 */
	public String getRowRange() {
		return rowRange;
	}

	/**
	 * 设置每页显示的行数范围
	 * @param rowRange 行数范围
	 */
	public void setRowRange(String rowRange) {
		this.rowRange = rowRange;
	}

	/**
	 * 取得明细上部固定行数量
	 * @return 行数
	 */
	public int getTopFixRowCount() {
		return topFixRowCount;
	}

	public void setTopFixRowCount(int topFixRowCount) {
		this.topFixRowCount = topFixRowCount;
	}

	/**
	 * 取得明细下部固定行数量，如果没有明细行，则返回0
	 * @return 行数
	 */
	public int getBottomFixRowCount() {
		return bottomFixRowCount;
	}

	public void setBottomFixRowCount(int bottomFixRowCount) {
		this.bottomFixRowCount = bottomFixRowCount;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	public Map<String, Integer> getLeafIndexMap() {
		return leafIndexMap;
	}

	public void addLeafRowIndex(String key, int index) {
		leafIndexMap.put(key, index);
	}

	/**
	 * 取得行对象集合
	 *
	 * @return 行对象集合
	 * @see MetaGridRowCollection
	 */
	public MetaGridRowCollection getRowCollection() {
		return this.rowCollection;
	}

	/**
	 * 获取追溯集合
	 * @return 追溯集合
	 */
	public MetaTraceCollection getTraceCollection() {
		return traceCollection;
	}

	/**
	 * 设置追溯集合
	 * @param traceCollection 追溯集合
	 */
	public void setTraceCollection(MetaTraceCollection traceCollection) {
		this.traceCollection = traceCollection;
	}

	/**
	 * 取得行层次对象
	 *
	 * @return 行层次对象{@link MetaGridRowLayer}
	 */
	public MetaGridRowLayer getRowLayer() {
		return this.rootRowLayer;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 获取是否单元格拓展
	 * @return 标志
	 */
	public boolean hasCellExpand() {
		return hasCellExpand;
	}

	/**
	 * 设置是否单元格拓展
	 */
	public void setHasCellExpand(boolean hasCellExpand) {
		this.hasCellExpand = hasCellExpand;
	}

	/**
	 * 设置是否行拓展
	 */
	public void setHasRowExpand(boolean hasRowExpand) {
		this.hasRowExpand = hasRowExpand;
	}

	/**
	 * 取得是否有列扩展
	 *
	 * @return 如果有列扩展，返回true，否则返回false
	 */
	public boolean hasColumnExpand() {
		return hasColumnExpand;
	}

	/**
	 * 是否有行扩展
	 * @return 如果有行扩展定义返回true，否则返回false
	 */
	public boolean hasRowExpand() {
		return this.hasRowExpand;
	}

	/**
	 * 是否有行区域拓展
	 * @return 如果行区域拓展定义返回true，否则返回false
	 */
	public boolean hasRowAreaExpand() {
		return rowAreaExpand != null;
	}

	/**
	 * 是否是树形表格
	 * @return 标志
	 */
	public boolean hasTree() {
		return this.hasTree;
	}

	/**
	 * 取得是否有行分组
	 * @return 如果有行分组，返回true，否则返回false
	 */
	public boolean hasRowGroup() {
		return hasRowGroup;
	}

	/**
	 * 获取选择字段位置
	 * @return 选择字段位置
	 */
	public int getSelectIndex() {
		return selectIndex;
	}

	/**
	 * 设置选择列位置
	 * @param selectIndex 选择列位置
	 */
	public void setSelectIndex(int selectIndex) {
		this.selectIndex = selectIndex;
	}

	/**
	 * 获取是否单选
	 * @return 是否单选
	 */
	public boolean singleSelect() {
		return singleSelect;
	}

	/**
	 * 设置是否单选
	 * @param singleSelect 是否单选
	 */
	public void setSingleSelect(Boolean singleSelect) {
		this.singleSelect = singleSelect;
	}

	/**
	 * 表格是否有某个操作,canInsert等单个方法废除,应该调用此方法
	 * <h3>optKey:</h3>
	 * <ul>
	 * <li>insert-插行</li>
	 * <li>delete-删行</li>
	 * <li>shift-交换行</li>
	 * <li>zoom-缩放</li>
	 * <li>export-导出</li>
	 * <li>bestWidth-最佳列宽</li>
	 * <li>sum-汇总</li>
	 * <li>groupSum-小计</li>
	 * <li>variantSet-设置变式</li>
	 * <li>frozenRow-冻结行</li>
	 * <li>frozenColumn-冻结列</li>
	 * <li>frozenRowColumn-冻结行列</li>
	 * </ul>
	 *
     *
	 * @return
	 */
	public Boolean hasOpt(String optKey) {
		if (this.disabledOption != null) {
			if (Arrays.asList(this.disabledOption.split(",")).contains(optKey)) {
				return false; // disabledOption里定义
			}
		}
		if (this.option != null) { // 有option定义,以option为准
			return Arrays.asList(this.option.split(",")).contains(optKey);
		}
		return true; // 默认包含
	}

	/**
	 * 获取表格排序公式定义
	 *
	 * @return 排序公式定义
	 */
	public String getGridDefaultSortField() {
		return gridDefaultSortField;
	}

	/**
	 * 设置表格排序公式定义
	 *
	 * @param gridDefaultSortField 排序公式定义
	 */
	public void setGridDefaultSortField(String gridDefaultSortField) {
		this.gridDefaultSortField = gridDefaultSortField;
	}

	/**
	 * 获取是否可根据条件定位行
	 *
	 * @return
	 */
	public Boolean getLocate() {
		return locate;
	}
	/**
	 * 设置是否可根据条件定位行
	 *
	 * @return
	 */
	public void setLocate(Boolean locate) {
		this.locate = locate;
	}

	/**
	 * 设置是否显示总行数
	 * @param showTotalRowCount 是否显示总行数
	 */
	public void setShowTotalRowCount(Boolean showTotalRowCount) {
		this.showTotalRowCount = showTotalRowCount;
	}

	/**
	 * 是否显示总行数
	 * @return 是否显示总行数
	 */
	public Boolean isShowTotalRowCount() {
		return this.showTotalRowCount;
	}

	/**
	 * 获取冻结行数量
	 * @return 冻结行数量
	 */
	public Integer getFreezeRowCount() {
		return this.freezeRowCount;
	}

	public void setFreezeRowCount(Integer freezeRowCount) {
		this.freezeRowCount = freezeRowCount;
	}

	/**
	 * 获取左边冻结列数量
	 * @return 冻结列数量
	 */
	public Integer getFreezeLeftColCount() {
		return freezeLeftColCount;
	}

	/**
	 * 设置左边冻结列数量
	 * @param freezeColCount
	 */
	public void setFreezeLeftColCount(Integer freezeColCount) {
		this.freezeLeftColCount = freezeColCount;
	}

	/**
	 * 获取右边冻结列数量
	 * @return 冻结列数量
	 */
	public Integer getFreezeRightColCount() {
		return freezeRightColCount;
	}

	/**
	 * 设置右边冻结列数量
	 * @param freezeColCount
	 */
	public void setFreezeRightColCount(Integer freezeColCount) {
		this.freezeRightColCount = freezeColCount;
	}

	/**
	 * 列预处理
	 */
	private void processColumn() {

		// 如果有明细行,列标识改成明细单元格标识
		// 没有明细行,改成第一行单元格标识
		MetaGridRow metaRow = this.getDetailMetaRow();
		if (metaRow == null) {
			metaRow = rowCollection.get(0);
		}

		MetaGridColumn metaColumn = null;
		Iterator<MetaGridColumn> it = columnCollection.iterator();
		while (it.hasNext()) {
			metaColumn = it.next();
			impl_processColumn(metaRow, metaColumn);
		}
		boolean overgap = false;

		for (int i = 0, length = leafColumns.size(); i < length; i++) {
			metaColumn = leafColumns.get(i);

			// 处理Freeze属性
			if (metaColumn.isFrozen()) {
				if (overgap) {
					this.freezeRightColCount = length - i;
				} else {
					this.freezeLeftColCount = i + 1;
				}
			} else {
				if (this.freezeLeftColCount > 0) {
					overgap = true;
				}
			}

			// 处理Fixed属性
			if ("left".equalsIgnoreCase(metaColumn.getFixed())) {
				this.freezeLeftColCount = i + 1;
			} else if ("right".equalsIgnoreCase(metaColumn.getFixed())) {
				this.freezeRightColCount = length - i;
			}
		}
	}

	private void impl_processColumn(MetaGridRow metaRow, MetaGridColumn metaColumn) {
		// 不在这里设置oldKey,当前如果是马甲,源单中有模板,模板引用的面板有表格,oldKey在马甲处理完不正确
		//metaColumn.setOldKey(metaColumn.getKey());
		MetaGridColumnCollection collection = metaColumn.getColumnCollection();
		if (collection != null && !collection.isEmpty()) {

			String metaKey = metaColumn.getMetaKey();
			if (metaKey == null || metaKey.isEmpty()) {
				metaColumn.setMetaKey(metaColumn.getKey());
			}

			for (int i = 0, size = collection.size(); i < size; i++) {
				impl_processColumn(metaRow, collection.get(i));
			}
		} else {
			this.leafColumns.add(metaColumn);
			int index = leafColumns.size() - 1;
			String newKey = metaRow.get(index).getKey();

			String orginalKey = metaColumn.getOrginalKey();
			if (orginalKey == null || orginalKey.isEmpty()) {
				metaColumn.setOrginalKey(newKey);
			}

			String metaKey = metaColumn.getMetaKey();
			if (metaKey == null || metaKey.isEmpty()) {
				metaColumn.setMetaKey(metaColumn.getKey());
			}

			metaColumn.setKey(newKey);
			this.leafIndexMap.put(metaColumn.getKey(), index);
		}
		MetaColumnExpand expand = metaColumn.getColumnExpand();
		if (expand != null) {
			this.hasColumnExpand = true;
			if (expand.getExpandType() == ColumnExpandType.DATA) {
				processColumnExpand(metaColumn, expand);
			}
		}
	}

	// 处理拓展信息
	private void processColumnExpand(IMetaColumnExpandObject metaObject, MetaColumnExpand columnExpand) {
		String columnKey = columnExpand.getColumnKey();
		if (columnKey == null || columnKey.isEmpty()) {
			throw new MetaException(MetaException.EXPAND_COLUMNKEY_UNDEFIND,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ExpandColumnKeyUndefined), metaObject.getCaption()));
		}
		MetaGridRow detailRow = this.getDetailMetaRow();
		if (detailRow == null) {
			String tableKey = columnExpand.getTableKey();
			if (tableKey != null && !tableKey.isEmpty() && !tableKeys.contains(tableKey)) {
				tableKeys.add(tableKey);
			}
		}
	}

	/**
	 * 获取树形的位置
	 * @return 位置
	 */
	public Integer getTreeIndex() {
		return treeIndex;
	}


	/**
	 * 设置树形列的位置
	 * @param treeIndex 树形列位置
	 */
	public void setTreeIndex(Integer treeIndex) {
		this.treeIndex = treeIndex;
	}

	/**
	 * 获取行拓展位置
	 * @return 行拓展位置
	 */
	public Integer getRowExpandIndex() {
		return rowExpandIndex;
	}

	/**
	 * 设置行拓展位置
	 * @param rowExpandIndex 行拓展位置
	 */
	public void setRowExpandIndex(Integer rowExpandIndex) {
		this.rowExpandIndex = rowExpandIndex;
	}

	private boolean hasTree = false;

	/**
	 * 单元格预处理
	 */
	private void processCell() {
		MetaGridRow detailRow = this.getDetailMetaRow();
		if (detailRow == null) {
			return;
		}

		MetaGridCell metaCell = null;
		for (int i = 0, size = detailRow.size(); i < size; i++) {
			metaCell = detailRow.get(i);

			// 选择字段
			if (metaCell.isSelect()) {
				this.selectIndex = i;
				this.singleSelect = metaCell.singleSelect();
			}

			// 获取treeIndex
			if (this.hasTree && this.treeIndex == -1) {
				MetaRowTree rowTree = detailRow.getRowTree();
				String cellKey = metaCell.getKey();
				if (cellKey != null && !cellKey.isEmpty() && cellKey.equals(rowTree.getCellKey())) {
					this.treeIndex = i;
				}
			}

			// 获取rowExpandIndex
			if (this.hasRowExpand && this.rowExpandIndex == -1) {
				MetaRowExpand rowExpand = detailRow.getRowExpand();
				String cellKey = metaCell.getKey();
				if (cellKey != null && !cellKey.isEmpty() && cellKey.equals(rowExpand.getCellKey())) {
					this.rowExpandIndex = i;
				}
			}

			// 合并相同值单元格
			if (metaCell.isMerge()) {
				this.mergeCells.add(metaCell.getKey());
			}

			//定制数据
			if (metaCell.getCellType() == ControlType.CUSTOM) {
				this.hasCustomData = true;
			}
		}
	}

	/**
	 * 多明细模式
	 */
	private boolean multiple = false;

	public boolean isMultiple() {
		return multiple;
	}

	public void setMultiple(boolean multiple) {
		this.multiple = multiple;
	}

	/**
	 * 行预处理:先建立分组层次关系,再循环添加行,行的添加是有顺序要求的
	 *
	 * <pre>
	 * 数据区域(MetaGridRowArea)包含：
	 * 	1.明细行
	 * 	2.分组行
	 * 	3.汇总行
	 * 固定行在数据区域之外
	 * </pre>
	 *
	 * @throws MetaException
	 */
	private void processRow() {
		this.rootRowLayer = new MetaGridRowLayer();

		MetaGridRow detailRow = this.getDetailMetaRow();
		if (detailRow != null) {
			this.hasDetailRow = true;

			// 行拓展
			MetaRowExpand rowExpand = detailRow.getRowExpand();
			if (rowExpand != null) {
				this.hasRowExpand = true;
				this.newEmptyRow = "false";
			}

			//树形表格
			MetaRowTree rowTree = detailRow.getRowTree();
			if (rowTree != null && rowTree.getTreeType() != GridTreeType.NONE) {
				this.hasTree = true;
				this.newEmptyRow = "false";
			}
		}
		MetaGridRow metaRow = null;
		MetaGridCell metaCell = null;
		Iterator<MetaGridRow> it = rowCollection.iterator();
		while (it.hasNext()) { // 处理明细引用,现在默认都引用主明细
			metaRow = it.next();
			switch (metaRow.getRowType()) {
				case RowType.Detail:
					String refKey = metaRow.getRefKey();
					if (refKey != null && !refKey.isEmpty()) {
						if (detailRow != null) {
							for (int i = 0, size = detailRow.size(); i < size; i++) {
								MetaGridCell clone = (MetaGridCell) detailRow.get(i).clone();
								MetaGridCell temp = metaRow.set(i, clone);
								clone.setKey(temp.getKey());
							}
							metaRow.setTableKey(detailRow.getTableKey());
							multiple = true;
						} else {
							throw new RuntimeException("配置错误...多明细模式主明细未定义");
						}
					}
					break;
				case RowType.Fix:
					for (int i = 0, size = metaRow.size(); i < size; i++) {
						metaCell = metaRow.get(i);
						if (metaCell.isMerged() && metaCell.isMergedHead()) {
							this.hasFixCellMerge = true;
						}
						MetaColumnExpand columnExpand = metaCell.getColumnExpand();
						if (columnExpand != null) {
							this.hasCellExpand = true;
							if (columnExpand.getExpandType() == ColumnExpandType.DATA) {
								processColumnExpand(metaCell, columnExpand);
							}
						}
					}
					break;
				default:
					break;
			}
		}
		if (multiple) {
			impl_processMultiple();
		} else {
			impl_processNormal();
		}
	}

	private void impl_processRelation(MetaGridRow metaRow) {
		for (int i = 0, size = metaRow.size(); i < size; i++) {
			MetaGridCell metaCell = metaRow.get(i);
			String cellKey = metaCell.getKey();
			if (cellKey != null && !cellKey.isEmpty()) {
				switch (metaCell.getCellType()) {
					case ControlType.COMBOBOX: {
						MetaComboBoxProperties properties = (MetaComboBoxProperties) metaCell.getProperties();
						addCellDepFields(cellKey, properties.getDependedFields());
					}
					break;
					case ControlType.CHECKLISTBOX: {
						MetaCheckListBoxProperties properties = (MetaCheckListBoxProperties) metaCell.getProperties();
						addCellDepFields(cellKey, properties.getDependedFields());
					}
					break;
					case ControlType.DICT:
					case ControlType.COMPDICT:
					case ControlType.DYNAMICDICT: {
						MetaDictProperties properties = (MetaDictProperties) metaCell.getProperties();
						String root = properties.getRoot();
						if (root != null && !root.isEmpty()) {
							addCellDepFields(cellKey, root);
						}
						if (metaCell.getCellType() == ControlType.DYNAMICDICT) {
							String refDataElementKey = properties.getRefDataElementKey();
							if (refDataElementKey != null && !refDataElementKey.isEmpty()) {
								addCellDepFields(cellKey, refDataElementKey);
							} else {
								String refKey = properties.getRefKey();
								if (refKey != null && !refKey.isEmpty()) {
									addCellDepFields(cellKey, refKey);
								}
							}
						}
						MetaItemFilterCollection itemFilters = properties.getFilters();
						if (itemFilters != null) {
							for (MetaItemFilter itemFilter : itemFilters) {
								Iterator<MetaFilter> ite = itemFilter.iterator();
								while (ite.hasNext()) {
									addCellDepFields(cellKey, ite.next().getDependedFields());
								}
							}
						}
					}
					break;
				}
			}
		}
	}

	// 处理Relation依赖关系
	private void processRelation() {

		// 表格过滤依赖
		if (filter != null) {
			this.ownDepFields.addAll(filter.getDependentFields());
		}

		// 单元格依赖
		Iterator<MetaGridRow> it = rowCollection.iterator();
		while (it.hasNext()) {
			MetaGridRow metaRow = it.next();
			switch (metaRow.getRowType()) {
				case RowType.Detail:
					String refKey = metaRow.getRefKey();
					if (refKey == null || refKey.isEmpty()) {
						impl_processRelation(metaRow);
					}
					break;
				case RowType.Fix:
					impl_processRelation(metaRow);
					break;
				default:
					break;
			}
		}
	}

	// 普通模式
	private void impl_processNormal() {
		// 根分组
		MetaGridRowGroup rootGroup = null;
		// 子叶分组
		MetaGridRowGroup leafGroup = null;

		StringHashMap<MetaGridRowGroup> groupMap = new StringHashMap<MetaGridRowGroup>();

		// 明细不为空,处理分组信息
		if (detailMetaRow != null) {
			for (int i = detailMetaRow.size() - 1; i >= 0; i--) {
				MetaGridCell metaCell = detailMetaRow.get(i);
				if (metaCell.getCellGroupType() == GroupType.RowGroup) {

					String cellKey = metaCell.getKey();

					MetaGridRowGroup group = new MetaGridRowGroup(cellKey);

					groupMap.put(cellKey, group);

					if (leafGroup == null) {
						leafGroup = group;
					}

					if (rootGroup != null) {
						group.addObject(rootGroup);
					}

					rootGroup = group;
					groupIndexes.add(0, i);
					groupCells.add(0, cellKey);
				}
			}
		}

		// 如果没有根分组,新建根分组
		if (rootGroup == null) {
			rootGroup = new MetaGridRowGroup("root");
		}

		// 如果没有分组,那么子叶分组等于根分组
		if (leafGroup == null) {
			leafGroup = rootGroup;
		}

		// 建立明细数据区域
		MetaGridRowArea rowArea = new MetaGridRowArea();

		//添加根分组
		rowArea.addObject(rootGroup);

		// 添加行信息
		int index = 0;
		MetaGridRow metaRow = null;
		Iterator<MetaGridRow> it = rowCollection.iterator();
		boolean isAfterDetail = false;
		while (it.hasNext()) {
			metaRow = it.next();
			switch (metaRow.getRowType()) {
				case RowType.Fix:// 固定行
					rootRowLayer.addObject(metaRow);
					if (isAfterDetail) {
						bottomFixRowCount++;
					} else {
						topFixRowCount++;
					}
					this.hasFixRow = true;
					break;
				case RowType.Group:
					hasRowGroup = true;
					MetaGridRowGroup group = groupMap.get(metaRow.getGroupKey());
					if (isAfterDetail) {
						metaRow.setGroupTail(true);// 分组尾
					} else {
						metaRow.setGroupHead(true);// 分组头
					}
					group.addRow(metaRow);
					break;
				case RowType.TreeRow:
					leafGroup.addObject(metaRow);
					break;
				case RowType.Detail:
					leafGroup.addObject(metaRow);
					rootRowLayer.addObject(rowArea); // 添加明细数据区域
					isAfterDetail = true;
					break;
				case RowType.Total:
					rootRowLayer.addObject(metaRow);
					if (isAfterDetail) {
						bottomFixRowCount++;
					} else {
						topFixRowCount++;
					}
					this.hasTotalRow = true;
					break;
			}
			if (metaRow.isFrozen()) {
				this.freezeRowCount = index + 1;
			}
			index++;
		}
		rowArea.extract();
	}

	// 多明细行模式
	private void impl_processMultiple() {
		// 构造一个数据区域
		MetaGridRowArea rowArea = new MetaGridRowArea();
		// 构造一个根分组
		MetaGridRowGroup rootGroup = new MetaGridRowGroup("");
		// 添加根分组
		rowArea.addObject(rootGroup);
		// 添加数据区域
		rootRowLayer.addObject(rowArea);

		// 添加行信息
		Iterator<MetaGridRow> it = rowCollection.iterator();
		MetaGridRow metaRow = null;
		MetaGridRow tempRow = null;
		String detailKey = "";
		int index = 0;
		while (it.hasNext()) {
			metaRow = it.next();
			switch (metaRow.getRowType()) {
				case RowType.Fix:
					rootGroup.addObject(metaRow);
					this.hasFixRow = true;
					break;
				case RowType.Detail: // 只需要关注区域头和区域尾,因为跟插明细行的位置有关
					rootGroup.addObject(metaRow);
					if (index - 1 >= 0) {
						tempRow = rowCollection.get(index - 1);
						detailKey = tempRow.getDetailKey();
						if (detailKey != null && detailKey.equals(metaRow.getKey())) {
							tempRow.setDetailHead(true);
							tempRow.setDetailIndex(index);
						}
					}
					if (index + 1 < rowCollection.size()) {
						tempRow = rowCollection.get(index + 1);
						detailKey = tempRow.getDetailKey();
						if (detailKey != null && detailKey.equals(metaRow.getKey())) {
							tempRow.setDetailTail(true);
							tempRow.setDetailIndex(index);
						}
					}
					break;
				case RowType.Total:
					rootGroup.addObject(metaRow);
					this.hasTotalRow = true;
					break;
			}
			index++;
		}
	}

	/**
	 * 获取子叶列位置
	 * @param key 列标识
	 * @return 列序号
	 */
	public Integer getColumnIndex(String key) {
		return this.leafIndexMap.get(key);
	}

	/**
	 * 获取指定索引的子叶列
	 * @param index 索引号
	 * @return 列定义
	 */
	public MetaGridColumn getLeafColumn(int index) {
		return this.leafColumns.get(index);
	}

	/**
	 * 获取子叶列集合
	 * @return
	 */
	public List<MetaGridColumn> getLeafColumns() {
		return this.leafColumns;
	}

	/**
	 * 取得是否在编辑时隐藏分组行
	 * @return 标志
	 */
	public Boolean isHideGroup4Editing() {
		return this.hideGroup4Editing;
	}

	/**
	 * 取得是否在编辑状态下新增一空行的标志
	 *
	 * @return 标志
	 */
	public String getNewEmptyRow() {
		return this.newEmptyRow;
	}

	/**
	 * 表格是否显示行头
	 * @return 标志
	 */
	public Boolean isShowRowHead() {
		return this.showRowHead;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGrid();
	}

	@Override
	public String getTableKey() {
		detailMetaRow = getDetailMetaRow();
		return detailMetaRow == null ? "" : detailMetaRow.getTableKey();
	}

	/**
	 * 设置列对象集合
	 *
     * @param columnCollection
     *            列对象集合
	 */
	public void setColumnCollection(MetaGridColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}

	/**
	 * 设置动态列扩展标志
	 * @param hasColumnExpand 标志
	 */
	public void setHasColumnExpand(boolean hasColumnExpand) {
		this.hasColumnExpand = hasColumnExpand;
	}

	/**
	 * 设置是否存在行数标志
	 * @param hasRowGroup 标志
	 */
	public void setHasRowGroup(boolean hasRowGroup) {
		this.hasRowGroup = hasRowGroup;
	}



	/**
	 * 设置是否在编辑时隐藏分组行
	 * @param hideGroup4Editing 标志
	 */
	public void setHideGroup4Editing(Boolean hideGroup4Editing) {
		this.hideGroup4Editing = hideGroup4Editing;
	}

	/**
	 * 设置是否在编辑状态下新增一空行标志
	 *
     * @param newEmptyRow
     *            标志
	 */
	public void setNewEmptyRow(String newEmptyRow) {
		this.newEmptyRow = newEmptyRow;
	}

	/**
	 * 是否有选择字段
	 * @return 如果有选择字段则返回true，否则返回false
	 */
	@Override
	public boolean hasSelectField() {
		return selectIndex != -1;
	}

	/**
	 * 设置分页类型
	 *
	 * @param type 分页类型
	 */
	public void setPageLoadType(Integer type) {
		this.pageLoadType = type;
	}

	/**
	 * 是否有定制数据
	 * @return 是否有定制数据标志
	 */
	public boolean hasCustomData() {
		return hasCustomData;
	}

	/**
	 * 设值是否有定制数据
	 * @param hasCustomData 是否有定制数据标志
	 */
	public void setHasCustomData(boolean hasCustomData) {
		this.hasCustomData = hasCustomData;
	}

	/**
	 * 设置每页行数
	 * @param count 行数
	 */
	public void setPageRowCount(Integer count) {
		this.pageRowCount = count;
	}

	private void setRootColumnLayer(MetaGridColumnLayer rootColumnLayer) {
		this.rootColumnLayer = rootColumnLayer;
	}

	/**
	 * 设置根行层次定义
	 * @param rootRowLayer 行层次定义
	 */
	public void setRootRowLayer(MetaGridRowLayer rootRowLayer) {
		this.rootRowLayer = rootRowLayer;
	}

	/**
	 * 设置行对象集合
	 *
     * @param rowCollection
     *            行对象集合
	 */
	public void setRowCollection(MetaGridRowCollection rowCollection) {
		this.rowCollection = rowCollection;
	}

	/**
	 * 设置显示行头标志
	 * @param showRowHead 标志
	 */
	public void setShowRowHead(Boolean showRowHead) {
		this.showRowHead = showRowHead;
	}

	/**
	 * 获取需要处理业务组件数据映射的表集合
	 * @return 表集合
	 */
	public List<String> getTableKeys() {
		return this.tableKeys;
	}

	public void addTableKey(String tableKey) {
		this.tableKeys.add(tableKey);
	}

	/**
	 * 获取分组单元格序号集合
	 * @return 序号集合
	 */
	public List<Integer> getGroupIndexes() {
		return groupIndexes;
	}

	public void addGroupIndex(int index) {
		groupIndexes.add(index);
	}

	public List<String> getGroupCells() {
		return groupCells;
	}

	public void addGroupCell(String cellKey) {
		groupCells.add(cellKey);
	}

	/**
	 * 获取需要处理合并的单元格集合
	 * @return
	 */
	public List<String> getMergeCells() {
		return mergeCells;
	}

	public void addMergeCell(String cellKey) {
		mergeCells.add(cellKey);
	}

	/**
	 * 获取单元格所对应的分组位置
	 * @param cellKey 单元格标识
	 * @return 分组位置
	 */
	public int getGroupIndex(String cellKey) {
		return this.groupCells.indexOf(cellKey);
	}

	/**
	 * 序列号是否连续
	 * @return 序列号是否连续标志
	 */
	public Boolean isSerialSeq() {
		return this.serialSeq;
	}

	/**
	 * 设置序列号是否连续
	 * @param serialSeq 序列号是否连续标志
	 */
	public void setSerialSeq(Boolean serialSeq) {
		this.serialSeq = serialSeq;
	}

	/**
	 * 获取翻页行序号是否连续
	 * @return 标志
	 */
	public Boolean isSerialRowNum() {
		return this.serialRowNum;
	}

	/**
	 * 设置翻页行序号是否连续
	 * @param serialRowNum 标志
	 */
	public void setSerialRowNum(Boolean serialRowNum) {
		this.serialRowNum = serialRowNum;
	}

	/**
	 * 获取是否方向键直接结束编辑
	 * @return 是否方向键直接结束编辑
	 */
	public Boolean isEndEditByNav() {
		return endEditByNav;
	}

	/**
	 * 设置是否方向键直接结束编辑
	 * @param endEditByNav 是否方向键直接结束编辑
	 */
	public void setEndEditByNav(Boolean endEditByNav) {
		this.endEditByNav = endEditByNav;
	}

	/**
	 * 获取是否同步插入数据行
	 * @return
	 */
	public Boolean getAddDataRow() {
		return addDataRow;
	}

	/**
	 * 设置否同步插入数据行
	 * @param addDataRow
	 */
	public void setAddDataRow(Boolean addDataRow) {
		this.addDataRow = addDataRow;
	}

	/**
	 * 根据标识寻找一个行
	 * @param rowKey 行标识
	 * @return 行定义
	 */
	public MetaGridRow findRowByKey(String rowKey) {
		for (MetaGridRow row : rowCollection) {
			if (row.getKey() != null && row.getKey().equals(rowKey)) {
				return row;
			}
		}
		return null;
	}

	/**
	 * 根据标识寻找一个列
	 * @param colKey 列标识,替换前的真实的key
	 * @return 列定义
	 */
	public MetaGridColumn findColumnByKey(String colKey) {
		return this.impl_findColumn(columnCollection, colKey);
	}

	public MetaGridColumn impl_findColumn(MetaGridColumnCollection collection, String colKey) {
		MetaGridColumn result = null;
		String columnKey = null;
		for (MetaGridColumn column : collection) {

			columnKey = column.getMetaKey();
			if (columnKey == null || columnKey.isEmpty()) {
				columnKey = column.getKey();
			}

			if (columnKey.equals(colKey)) {
				result = column;
				break;
			} else if (column.hasChildren()) {
				result = impl_findColumn(column.getColumnCollection(), colKey);
			}

			if (result != null) {
				break;
			}
		}
		return result;
	}

	@Override
	public void merge(MetaComponent meta) {

		super.merge(meta);

		MetaGrid extGrid = (MetaGrid) meta;

		if (this.hideGroup4Editing == null) {
			this.hideGroup4Editing = extGrid.isHideGroup4Editing();
		}
		if (this.newEmptyRow == null) {
			this.newEmptyRow = extGrid.getNewEmptyRow();
		}
		if (this.locate == null) {
			this.locate = extGrid.getLocate();
		}
		if (this.gridDefaultSortField == null) {
			this.gridDefaultSortField = extGrid.getGridDefaultSortField();
		}

		if (this.editRowFormKey == null) {
			this.editRowFormKey = extGrid.getEditRowFormKey();
		}
		if (this.selectMode == -1) {
			this.selectMode = extGrid.getSelectMode();
		}
		if (this.pageLoadType == -1) {
			this.pageLoadType = extGrid.getPageLoadType();
		}
		if (this.pageRowCount == -1) {
			this.pageRowCount = extGrid.getPageRowCount();
		}
		if (this.pageIndicatorCount == -1) {
			this.pageIndicatorCount = extGrid.getPageIndicatorCount();
		}
		if (this.rowRange == null) {
			this.rowRange = extGrid.getRowRange();
		}
		if (this.rowClick == null) {
			this.rowClick = extGrid.getRowClick();
		}
		if (this.rowDblClick == null) {
			this.rowDblClick = extGrid.getRowDblClick();
		}
		if (this.focusRowChanged == null) {
			this.focusRowChanged = extGrid.getFocusRowChanged();
		}
		if (this.beforeRowInsert == null) {
			this.beforeRowInsert = extGrid.getBeforeRowInsert();
		}
		if (this.rowInsert == null) {
			this.rowInsert = extGrid.getRowInsert();
		}
		if (this.rowDelete == null) {
			this.rowDelete = extGrid.getRowDelete();
		}
		if (this.onRowDelete == null) {
			this.onRowDelete = extGrid.getOnRowDelete();
		}
		if (this.showTotalRowCount == null) {
			this.showTotalRowCount = extGrid.isShowTotalRowCount();
		}
		if (this.option == null) {
			this.option = extGrid.getOption();
		}
		if (this.disabledOption == null) {
			this.disabledOption = extGrid.getDisabledOption();
		}
		if (this.showRowHead == null) {
			this.showRowHead = extGrid.isShowRowHead();
		}
		MetaGridFilter filter = extGrid.getFilter();
		if (this.filter == null) {

			if (filter != null) {
				this.filter = (MetaGridFilter) filter.clone();
			}
		} else {
			if (filter != null) {
				for (MetaFilterValue metaFilterValue : filter) {
					if (this.filter.containsKey(metaFilterValue.getKey())) {
						this.filter.get(metaFilterValue.getKey()).merge(metaFilterValue);
					} else {
						this.filter.add(metaFilterValue);
					}
				}
			}
		}
		if (this.serialSeq == null) {
			this.serialSeq = extGrid.isSerialSeq();
		}
		if (this.serialRowNum == null) {
			this.serialRowNum = extGrid.isSerialRowNum();
		}
		if (this.endEditByNav == null) {
			this.endEditByNav = extGrid.isEndEditByNav();
		}
		if (this.addDataRow == null) {
			this.addDataRow = extGrid.getAddDataRow();
		}
		if (this.defaultFitWidth == null) {
			this.defaultFitWidth = extGrid.getDefaultFitWidth();
		}
		if (this.traceCollection == null) {
			MetaTraceCollection traces = extGrid.getTraceCollection();
			if (traces != null) {
				this.traceCollection = (MetaTraceCollection) traces.clone();
			}
		}
		if (this.columnCollection == null) {
			MetaGridColumnCollection traces = extGrid.getColumnCollection();
			this.columnCollection = (MetaGridColumnCollection) traces.depthClone();
		} else {
			MetaGridColumnCollection extGridColumnCollection = extGrid.getColumnCollection();

			//下面这样做为了记录顺序
			mergerColumnCollection(this.getColumnCollection(), extGridColumnCollection);//合并原单内容
			MetaGridColumnCollection traces = (MetaGridColumnCollection) extGridColumnCollection.depthClone();


			toMergerColumnCollection(traces, this.columnCollection);//合并马甲内容

			this.columnCollection = traces;
			//反向合并初始化新增列
			for (MetaGridColumn gridColumn : this.columnCollection) {
				gridColumn.merge(new MetaGridColumn());
				mergerNewColumnew(gridColumn);
			}
		}


		if (this.rowCollection == null) {
			MetaGridRowCollection traces = extGrid.getRowCollection();
			this.rowCollection = (MetaGridRowCollection) traces.depthClone();
		} else {
			MetaGridRowCollection traces = (MetaGridRowCollection) extGrid.getRowCollection().depthClone();

			for (MetaGridRow metaGridRow : extGrid.getRowCollection()) {
				MetaGridRow row = this.findRowByKey(metaGridRow.getKey());
				if (row != null) {//找到源行
					row.merge(metaGridRow);
					for (MetaGridCell metaGridCell : metaGridRow) {
						MetaGridCell cellByKey = row.findCellByKey(metaGridCell.getKey());
						if (cellByKey != null) {//找到源列
							cellByKey.merge(metaGridCell);
						}
					}
				}
			}
			for (MetaGridRow metaGridRow : this.rowCollection) {
				MetaGridRow row = extGrid.findRowByKey(metaGridRow.getKey());
				int i = extGrid.getRowCollection().indexOf(row);

				if (row != null) {//找到源行
					MetaGridRow metaGridRow1 = traces.get(i);
					for (MetaGridCell metaGridCell : metaGridRow) {
						MetaGridCell cellByKey = metaGridRow1.findCellByKey(metaGridCell.getKey());
						int i1 = metaGridRow1.indexOf(cellByKey);
						if (cellByKey != null) {//找到源列
							metaGridRow1.remove(i1);
							metaGridRow1.add(i1,metaGridCell);
						} else {
							metaGridRow1.add(metaGridCell);
						}
					}
				} else {
					traces.add(metaGridRow);
				}
			}
			//反向合并初始化新增列
			this.rowCollection = traces;
			for (MetaGridRow metaGridRow : this.rowCollection) {
				MetaGridRow row = extGrid.findRowByKey(metaGridRow.getKey());
				if (row == null) {
					MetaGridRow metaRow = new MetaGridRow();
					metaRow.setRowType(metaGridRow.getRowType());
					metaGridRow.merge(metaRow);
					for (MetaGridCell metaGridCell : metaGridRow) {
						MetaGridCell metaCell = new MetaGridCell();
						metaCell.setCellType(metaGridCell.getCellType());
						metaCell.setDataBinding(new MetaDataBinding());
						metaCell.ensureProperties();
						metaGridCell.merge(metaCell);
					}
				}else {
					for (MetaGridCell metaGridCell : metaGridRow) {
						if (row.findCellByKey(metaGridCell.getKey()) == null) {
							MetaGridCell metaCell = new MetaGridCell();
							metaCell.setCellType(metaGridCell.getCellType());
							metaCell.setDataBinding(new MetaDataBinding());
							metaCell.ensureProperties();
							metaGridCell.merge(metaCell);

						}

					}


				}
			}
		}
		if (extGrid.getExtOpts() != null) {
			if (this.extOpts == null) {
				this.extOpts = (MetaExtOptCollection) extGrid.getExtOpts().clone();
			} else {
				for (MetaExtOpt extOpt : extGrid.getExtOpts()) {
					if (this.extOpts.containsKey(extOpt.getKey())) {
						MetaExtOpt metaExtOpt = this.extOpts.get(extOpt.getKey());
						metaExtOpt.merge(extOpt);
						String caption = metaExtOpt.getCaption();
						String visible = metaExtOpt.getVisible();
						String visibleDependency = metaExtOpt.getVisibleDependency();
						String enable = metaExtOpt.getEnable();
						String enableDependency = metaExtOpt.getEnableDependency();
						String icon = metaExtOpt.getIcon();
						if (caption == null) {
							metaExtOpt.setCaption(extOpt.getCaption());
						}
						if (visible == null) {
							metaExtOpt.setVisible(extOpt.getVisible());
						}
						if (visibleDependency == null) {
							metaExtOpt.setVisibleDependency(extOpt.getVisibleDependency());
						}
						if (enable == null) {
							metaExtOpt.setEnable(extOpt.getEnable());
						}
						if (enableDependency == null) {
							metaExtOpt.setEnableDependency(extOpt.getEnableDependency());
						}
						if (icon == null) {
							metaExtOpt.setIcon(extOpt.getIcon());
						}
					} else {
						this.extOpts.add((MetaExtOpt) extOpt.clone());
					}
				}
			}
		}
	}

	private static void mergerNewColumnew(MetaGridColumn gridColumn) {
		if (gridColumn.getColumnCollection()!=null){
			for (MetaGridColumn metaGridColumn : gridColumn.getColumnCollection()) {
				metaGridColumn.merge(new MetaGridColumn());
				mergerNewColumnew(metaGridColumn);
			}
		}
	}

	private void mergerColumnCollection(MetaGridColumnCollection columnCollection, MetaGridColumnCollection extcolumnCollection) {
		if (extcolumnCollection != null) {
			for (MetaGridColumn metaGridColumn : extcolumnCollection) {
				MetaGridColumn gridColumn = impl_findColumn(columnCollection, metaGridColumn.getMetaKey());
				if (gridColumn != null) {//找到源
					gridColumn.merge(metaGridColumn);
					if (gridColumn.getColumnCollection() == null) {
						gridColumn.setColumnCollection(metaGridColumn.getColumnCollection());
					} else {
						mergerColumnCollection(gridColumn.getColumnCollection(), metaGridColumn.getColumnCollection());
					}
				}
			}
		}
	}

	private static MetaGridRow sortMetaGridRow(MetaGridRow meta) throws Throwable {

		// 将有序集合转换为LinkedList
		LinkedList<String> linkedList = new LinkedList<>();
		for (MetaGridCell gridCell : meta) {
			if (gridCell.getSideKey().isEmpty()) {//认为是原单的
				linkedList.add(gridCell.getKey());
			}
			if (gridCell.getLast() != null &&gridCell.getLast() && gridCell.getFirst() != null &&gridCell.getFirst()){
				throw new Throwable("GridCell："+gridCell.getKey()+"Fist和Last属性值冲突,请修正配置");
			}

			if (gridCell.getFirst() != null && gridCell.getFirst()){
				if (meta.getFistGridCell()!=null){
					throw new Throwable("GridCell："+meta.getFistGridCell().getKey()+"Fist属性与"+gridCell.getKey()+"属性重复,请修正配置");
				}
				meta.setFistGridCell(gridCell);
				linkedList.remove(gridCell.getKey());

			}
			if (gridCell.getLast() != null && gridCell.getLast()){
				if (meta.getFistGridCell()!=null){
					throw new Throwable("GridCell："+meta.getLastGridCell().getKey()+"Fist属性与"+gridCell.getKey()+"属性重复,请修正配置");
				}
				meta.setFistGridCell(gridCell);
				linkedList.remove(gridCell.getKey());
			}

		}
		if (meta.getFistGridCell()!=null){
			linkedList.add(meta.getFistGridCell().getKey());
		}
		if (meta.getLastGridCell()!=null){
			linkedList.add(meta.getLastGridCell().getKey());
		}
		for (MetaGridCell gridCell : meta) {
			if (!gridCell.getSideKey().isEmpty()) {//认为是原单的
				if (gridCell.getInsertAfter()){
					linkedList.add(linkedList.indexOf(gridCell.getSideKey())+1, gridCell.getKey());
				} else {
					linkedList.add(linkedList.indexOf(gridCell.getSideKey()), gridCell.getKey());
				}
			}
		}
		MetaGridRow metaGridRows = (MetaGridRow) meta.depthClone();
		metaGridRows.clear();
		if (meta.getFistGridCell()!=null){
			metaGridRows.add(meta.getFistGridCell());
		}
		for (String gridCell : linkedList) {
			metaGridRows.add(meta.findCellByKey(gridCell));
		}
		if (meta.getLastGridCell()!=null){
			metaGridRows.add(meta.getLastGridCell());
		}
		return metaGridRows;
	}

	private static MetaGridColumnCollection sortMetaGridColumns(MetaGridColumnCollection columnCollection) throws Throwable {
		// 将有序集合转换为LinkedList
		LinkedList<String> linkedList = new LinkedList<>();
		for (MetaGridColumn gridColumn : columnCollection) {
			if (gridColumn.isColExpand()){
				return columnCollection;
			} else if (gridColumn.getSideKey().isEmpty()) {//认为是原单的
				linkedList.add(gridColumn.getMetaKey());
			}

			if (gridColumn.getLast() != null && gridColumn.getLast( )&& gridColumn.getFirst() != null && gridColumn.getFirst()){
				throw new Throwable("GridColumn："+gridColumn.getMetaKey()+"Fist和Last属性值冲突,请修正配置");
			}
			if (gridColumn.getFirst() != null && gridColumn.getFirst()){
				if (columnCollection.getFistColumn()!=null){
					throw new Throwable("GridColumn："+columnCollection.getFistColumn().getMetaKey()+"Fist属性与"+gridColumn.getMetaKey()+"属性重复,请修正配置");
				}
				columnCollection.setFistColumn(gridColumn);
				linkedList.remove(gridColumn.getMetaKey());

			}
			if (gridColumn.getLast() != null && gridColumn.getLast()){
				if (columnCollection.getLastColumn()!=null){
					throw new Throwable("GridColumn："+columnCollection.getLastColumn().getMetaKey()+"Fist属性与"+gridColumn.getMetaKey()+"属性重复,请修正配置");
				}
				columnCollection.setLastColumn(gridColumn);
				linkedList.remove(gridColumn.getMetaKey());
			}
		}



		if (columnCollection.getFistColumn()!=null){
			linkedList.add(0,columnCollection.getFistColumn().getMetaKey());
		}
		if (columnCollection.getLastColumn()!=null){
			linkedList.add(columnCollection.getLastColumn().getMetaKey());
		}
		for (MetaGridColumn gridColumn : columnCollection) {
			if (!gridColumn.getSideKey().isEmpty()) {//认为是新的
				if (gridColumn.getInsertAfter()){
					linkedList.add(linkedList.indexOf(gridColumn.getSideKey())+1, gridColumn.getMetaKey());
				} else {
					linkedList.add(linkedList.indexOf(gridColumn.getSideKey()), gridColumn.getMetaKey());
				}
			}
		}


		MetaGridColumnCollection metaGridColumns = new MetaGridColumnCollection();
		if (columnCollection.getFistColumn()!=null){
			metaGridColumns.add(columnCollection.getFistColumn());
		}
		for (String gridColumn : linkedList) {
			MetaGridColumn metaGridColumn = new MetaGrid().impl_findColumn(columnCollection, gridColumn);
			if (metaGridColumn.hasChildren()){
				metaGridColumn.setColumnCollection(sortMetaGridColumns(metaGridColumn.getColumnCollection()));
			}
			metaGridColumns.add(metaGridColumn);
		}
		if (metaGridColumns.getFistColumn()!=null){
			metaGridColumns.add(columnCollection.getLastColumn());
		}

		return metaGridColumns;
	}
	public MetaGrid sortGrid() throws Throwable {
		MetaGrid metaGrid = (MetaGrid) this.depthClone();
		MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
		MetaGridColumnCollection columnCollectiontmp = sortMetaGridColumns(columnCollection);

		if (columnCollectiontmp != columnCollection){
			MetaGridRowCollection clone = new MetaGridRowCollection();
			for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
				MetaGridRow gridRow = sortMetaGridRow(metaGridRow);
				clone.add(gridRow);
			}
			metaGrid.setRowCollection(clone);
			metaGrid.setColumnCollection(columnCollectiontmp) ;
		}
		return  metaGrid;
	}
	private void toMergerColumnCollection(MetaGridColumnCollection columnCollection, MetaGridColumnCollection extcolumnCollection) {
		if (extcolumnCollection != null) {
			for (MetaGridColumn metaGridColumn : extcolumnCollection) {
				MetaGridColumn gridColumn = impl_findColumn(columnCollection, metaGridColumn.getMetaKey());
				if (gridColumn != null) {//找到源
					gridColumn.toMerger(metaGridColumn);
					if (gridColumn.getColumnCollection() == null) {
						gridColumn.setColumnCollection(metaGridColumn.getColumnCollection());
					} else {
						toMergerColumnCollection(gridColumn.getColumnCollection(), metaGridColumn.getColumnCollection());
					}
				} else {
					columnCollection.add((MetaGridColumn) metaGridColumn.depthClone());
				}
			}
		}
	}
}