package com.bokesoft.yigo.meta.form.component.control.refresh;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

/**
 * 刷新组件，带下拉刷新和上拉刷新两部分
 * @author chenzs
 *
 */
public class MetaRefreshControl extends MetaComponent {

	public static final String TAG_NAME = "RefreshControl";

	/** 下拉刷新定义*/
	private MetaRefreshHeader header;
	/** 上拉刷新定义*/
	private MetaRefreshFooter footer;
	/** 刷新作用于的主组件*/
	private MetaComponent rootComp;
	/** 方向，决定下拉和上拉刷新部分的位置。取值参考{@link OrientationType}*/
	private Integer orientation = OrientationType.Vertical;

	/**
	 * 获取下拉刷新的定义
	 * @return 下拉刷新的定义
	 */
	public MetaRefreshHeader getHeader() {
		return header;
	}

	/**
	 * 设置下拉刷新的定义
	 * @param header 下拉刷新的定义
	 */
	public void setHeader(MetaRefreshHeader header) {
		this.header = header;
	}

	/**
	 * 获取上拉刷新定义
	 * @return 上拉刷新定义
	 */
	public MetaRefreshFooter getFooter() {
		return footer;
	}

	/**
	 * 设置上拉刷新定义
	 * @param footer 上拉刷新定义
	 */
	public void setFooter(MetaRefreshFooter footer) {
		this.footer = footer;
	}

	/**
	 * 获取刷新作用于的主组件
	 * @return 刷新作用于的主组件
	 */
	public MetaComponent getRootComp() {
		return rootComp;
	}

	/**
	 * 设置刷新作用于的主组件
	 * @param rootComp 刷新作用于的主组件
	 */
	public void setRootComp(MetaComponent rootComp) {
		this.rootComp = rootComp;
	}
	
	/**
	 * 获取下拉刷新定义，保证不为空
	 * @return 下拉刷新定义
	 */
	public MetaRefreshHeader ensureRefreshHeader() {
		if( header == null ) {
			header = new MetaRefreshHeader();
		}
		return this.header;
	}
	
	/**
	 * 获取上拉刷新定义，保证不为空
	 * @return 上拉刷新定义
	 */
	public MetaRefreshFooter ensureRefreshFooter() {
		if( footer == null ) {
			footer = new MetaRefreshFooter();
		}
		return this.footer;
	}
	
	/**
	 * 设置布局方向
	 * @param orientation 布局方向，取值参考{@link OrientationType}
	 */
	public void setOrientation(Integer orientation) {
		this.orientation = orientation;
	}
	
	/**
	 * 获取布局方向
	 * @return 布局方向，取值参考{@link OrientationType} 
	 */
	public Integer getOrientation() {
		return orientation;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] { header, footer, rootComp });
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(rootComp != null){
			rootComp.doPostProcess(flag, callback);
		} else {
			throw new MetaException(MetaException.NO_ROOT_CONTROL, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoRootControl), getKey()));
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (resultMetaObject == null) {
			if (MetaRefreshHeader.TAG_NAME.equals(tagName)) {
				this.header = new MetaRefreshHeader();
				resultMetaObject = this.header;
			} else if (MetaRefreshFooter.TAG_NAME.equals(tagName)) {
				this.footer = new MetaRefreshFooter();
				resultMetaObject = this.footer;
			} else {
				rootComp = MetaComponentFactory.getInstance().newComponent(tagName);
				rootComp.preProcessMetaObject(env, doc, node, flag, runType);
				resultMetaObject = rootComp;
			}
		}
		return resultMetaObject;
	}

	@Override
	public int getControlType() {
		return ControlType.REFRESHCONTROL;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRefreshControl();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRefreshControl newObject = (MetaRefreshControl) super.clone();
		newObject.setHeader(header == null ? null : (MetaRefreshHeader)header.clone());
		newObject.setFooter(footer == null ? null : (MetaRefreshFooter)footer.clone());
		newObject.setRootComp(rootComp == null ? null : (MetaComponent)rootComp.clone());
		newObject.setOrientation(orientation);
		return newObject;
	}
}
