package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;

public class MetaTextButtonProperties extends AbstractMetaObject implements IPropertyMerger<MetaTextButtonProperties>{
	/** 点击事件*/
	private MetaBaseScript onClick = null;

	/** 文本输入长度，默认255,-1表示无限制*/
	private Integer maxLength = 255;

	/** 是否以公式模式使用*/
	private Boolean useFormulaModel = false;

	/** 不允许输入的字符集合 */
	private String invalidChars = "";

	/** 大小写转换类型,-1表示未定义*/
	private Integer caseType = MetaTextEditor.CASETYPE_NONE;

	/** 文本编辑器为空时的提示信息 */
	private String promptText = "";

	/** 是否去除首尾多余空格。 */
	private Boolean trim = false;

	/** 光标进入默认全选。 */
	private Boolean selectOnFocus = true;

	/** 掩码，为固定长度字符串。 */
	private String mask = "";

	/** 右侧图标url。 */
	private String icon = "";

	/** 左侧图标url */
	private String preIcon = "";

	/** 左侧内嵌文本。 */
	private String embedText = "";

	/** 保持焦点 ,只对头控件有效,Enter键保持,Tab键下一个*/
	private Boolean holdFocus = false;

	/** 回车事件,只对头控件有效 */
	private MetaBaseScript keyEnter = null;
	
	public Boolean getUseFormulaModel() {
		return useFormulaModel;
	}

	public void setUseFormulaModel(Boolean useFormulaModel) {
		this.useFormulaModel = useFormulaModel;
	}

	/**
	 * 设置回车事件
	 * @param keyEnter 回车事件
	 */
	public void setKeyEnter(MetaBaseScript keyEnter) {
		this.keyEnter = keyEnter;
	}

	/**
	 * 取得回车事件
	 * @return 回事事件
	 */
	public MetaBaseScript getKeyEnter() {
		return this.keyEnter;
	}

	/**
	 * 设置最大输入字符长度
	 *
	 * @param length
	 *            最大输入字符长度
	 */
	public void setMaxLength(Integer length) {
		this.maxLength = length;
	}

	/**
	 * 获取最大输入字符长度
	 *
	 * @return 最大输入字符长度
	 */
	public Integer getMaxLength() {
		return maxLength;
	}

	/**
	 * 设置不允许输入的字符集合
	 *
	 * @param chars
	 *            不允许输入的字符集合
	 */
	public void setInvalidChars(String chars) {
		this.invalidChars = chars;
	}

	/**
	 * 获取不允许输入的字符集合
	 *
	 * @return 不允许输入的字符集合
	 */
	public String getInvalidChars() {
		return this.invalidChars;
	}

	/**
	 * 设置大小写转换类型
	 *
	 * @param caseType
	 *            大小写转换类型
	 */
	public void setCaseType(Integer caseType) {
		this.caseType = caseType;
	}

	/**
	 * 获取大小写转换类型
	 *
	 * @return 大小写转换类型
	 *
	 */
	public Integer getCaseType() {
		return this.caseType;
	}

	/**
	 * 设置文本为空时的提示信息
	 *
	 * @param promptText
	 *            提示信息
	 */
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}

	/**
	 * 获取文本为空时的提示信息
	 *
	 * @return 提示信息
	 */
	public String getPromptText() {
		return this.promptText;
	}

	/**
	 * 设置是否去除首尾多余空格
	 * @return 标志
	 */
	public Boolean isTrim() {
		return this.trim;
	}

	/**
	 * 获取是否去除首尾多余空格
	 * @param trim 标志
	 */
	public void setTrim(Boolean trim) {
		this.trim = trim;
	}

	/**
	 * 设置光标进入是否默认全选标志
	 * @return 标志
	 */
	public Boolean isSelectOnFocus() {
		return this.selectOnFocus;
	}

	/**
	 * 获取光标进入是否默认全选标志
	 * @param selectOnFocus 标志
	 */
	public void setSelectOnFocus(Boolean selectOnFocus) {
		this.selectOnFocus = selectOnFocus;
	}

	/**
	 * 设置掩码
	 * @return 掩码
	 */
	public String getMask() {
		return mask;
	}

	/**
	 * 获取掩码
	 * @param mask 掩码
	 */
	public void setMask(String mask) {
		this.mask = mask;
	}

	/**
	 * 设置右侧图标url
	 * @return url
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * 获取右侧图标url
	 * @param icon url
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 设置左侧图标url
	 * @param preIcon 资源路径
	 */
	public void setPreIcon(String preIcon) {
		this.preIcon = preIcon;
	}

	/**
	 * 取得左侧图标url
	 * @return 资源路径
	 */
	public String getPreIcon() {
		return this.preIcon;
	}

	/**
	 * 设置左侧内嵌文本
	 * @return 文本
	 */
	public String getEmbedText() {
		return embedText;
	}

	/**
	 * 获取左侧内嵌文本
	 * @param embedText 文本
	 */
	public void setEmbedText(String embedText) {
		this.embedText = embedText;
	}

	/**
	 * 设置保持焦点
	 * @param holdFocus 保持焦点标志
	 */
	public void setHoldFocus(Boolean holdFocus) {
		this.holdFocus = holdFocus;
	}

	/**
	 * 取得是否保持焦点
	 * @return 保持焦点标志
	 */
	public Boolean isHoldFocus() {
		return this.holdFocus;
	}

	public void setOnClick(MetaBaseScript click){
		this.onClick = click;
	}

	public MetaBaseScript getOnClick(){
		return this.onClick;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { onClick, keyEnter });
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}else if ( MetaConstants.Event_KeyEnter.equals(tagName) ) {
			this.keyEnter = new MetaBaseScript(MetaConstants.Event_KeyEnter);
			resultMetaObject = this.keyEnter;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTextButtonProperties newObject = new MetaTextButtonProperties();
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript) onClick.clone());
		newObject.setMaxLength(maxLength);
		newObject.setUseFormulaModel(useFormulaModel);
		newObject.setInvalidChars(invalidChars);
		newObject.setCaseType(caseType);
		newObject.setPromptText(promptText);
		newObject.setTrim(trim);
		newObject.setSelectOnFocus(selectOnFocus);
		newObject.setMask(mask);
		newObject.setIcon(icon);
		newObject.setEmbedText(embedText);
		newObject.setHoldFocus(holdFocus);
		newObject.setKeyEnter(keyEnter == null ? null : (MetaBaseScript)keyEnter.clone());
		newObject.setPreIcon(preIcon);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTextButtonProperties();
	}

	@Override
	public void merge(MetaTextButtonProperties properties) {
		if( this.onClick == null ) {
			this.onClick = properties.getOnClick();
		}
		if( this.maxLength == null ) {
			this.maxLength = properties.getMaxLength();
		}
		if( this.useFormulaModel == null ) {
			this.useFormulaModel = properties.getUseFormulaModel();
		}
		if( this.invalidChars == null ) {
			this.invalidChars = properties.getInvalidChars();
		}
		if( this.caseType == -1 ) {
			this.caseType = properties.getCaseType();
		}
		if( this.promptText == null ) {
			this.promptText = properties.getPromptText();
		}
		if( this.trim == null ) {
			this.trim = properties.isTrim();
		}
		if( this.selectOnFocus == null ) {
			this.selectOnFocus = properties.isSelectOnFocus();
		}
		if( this.mask == null ) {
			this.mask = properties.getMask();
		}
		if( this.icon == null ) {
			this.icon = properties.getIcon();
		}
		if( this.preIcon == null ) {
			this.preIcon = properties.getPreIcon();
		}
		if( this.embedText == null ) {
			this.embedText = properties.getEmbedText();
		}
		if( this.holdFocus == null ) {
			this.holdFocus = properties.isHoldFocus();
		}
		if( this.keyEnter == null ) {
			this.keyEnter = properties.getKeyEnter();
		}
	}
}