package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * 打分组件的属性对象，用于存储组件的具体属性
 * @author chenzs
 *
 */
public class MetaScoreBarProperties extends AbstractMetaObject implements IPropertyMerger<MetaScoreBarProperties>{
	
	/** 打分项目数*/
	private Integer count = 5;
	/**每项的未选中时的默认图标*/
	private String icon = "";
	/**每项的选中图标*/
	private String selectIcon = "";
	/**是否支持步进半分*/
	private Boolean supportHalf = true;
	
	/**
	 * 获取打分项的数量
	 * @return 打分项的数量
	 */
	public Integer getCount() {
		return count;
	}

	/**
	 * 设置打分项的数量
	 * @param count 打分项的数量
	 */
	public void setCount(Integer count) {
		this.count = count;
	}

	/**
	 * 获取打分项未选中时的图标
	 * @return 打分项未选中时的图标
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * 设置打分项未选中时的图标
	 * @param icon 打分项未选中时的图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 获取打分项选中时的图标
	 * @return 打分项选中时的图标
	 */
	public String getSelectIcon() {
		return selectIcon;
	}

	/**
	 * 设置打分项选中时的图标
	 * @param selectIcon 打分项选中时的图标
	 */
	public void setSelectIcon(String selectIcon) {
		this.selectIcon = selectIcon;
	}
	
	/**
	 * 设置是否支持半分步进
	 * @param supportHalf 是否支持半分步进
	 */
	public void setSupportHalf(Boolean supportHalf) {
		this.supportHalf = supportHalf;
	}
	
	/**
	 * 获取是否支持半分步进
	 * @return 是否支持半分步进
	 */
	public Boolean isSupportHalf() {
		return supportHalf;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaScoreBarProperties newBar = new MetaScoreBarProperties();
		newBar.setCount(count);
		newBar.setIcon(icon);
		newBar.setSelectIcon(selectIcon);
		newBar.setSupportHalf(supportHalf);
		return newBar;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaScoreBarProperties();
	}
	
	@Override
	public void merge(MetaScoreBarProperties scoreBarProperties) {
		if(count == null){
			this.count = scoreBarProperties.getCount();
		}
		if(icon == null){
			this.icon = scoreBarProperties.getIcon();
		}
		if(selectIcon == null){
			this.selectIcon = scoreBarProperties.getSelectIcon();
		}
		if(supportHalf == null){
			this.supportHalf = scoreBarProperties.isSupportHalf();
		}
	}

}
