package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaNoticeBarProperties extends AbstractMetaObject implements IPropertyMerger<MetaNoticeBarProperties>{
	/** 前置图标 */
	private String preIcon = "";
	/** 操作图标*/
	private String actionIcon = "";
	/** 是否可滚动*/
	private Boolean scrollable = true;
	/** 是否单行**/
	private Boolean singleLine = true;
	/** 滚动方向**/
	private Integer orientation = OrientationType.Horizontal;
	
	/** 操作图片点击事件*/
	private MetaBaseScript action = null;

	/**
	 * 获取前置图标
	 * @return 前置图标
	 */
	public String getPreIcon() {
		return preIcon;
	}

	/**
	 * 设置前置图标
	 * @param preIcon 前置图标
	 */
	public void setPreIcon(String preIcon) {
		this.preIcon = preIcon;
	}

	/**
	 * 获取操作图标
	 * @return 操作图标
	 */
	public String getActionIcon() {
		return actionIcon;
	}

	/**
	 * 设置操作图标
	 * @param actionIcon 操作图标
	 */
	public void setActionIcon(String actionIcon) {
		this.actionIcon = actionIcon;
	}

	/**
	 * 获取是否滚动
	 * @return 是否滚动
	 */
	public Boolean getScrollable() {
		return scrollable;
	}

	/**
	 * 设置是否滚动
	 * @param scrollable 是否滚动
	 */
	public void setScrollable(Boolean scrollable) {
		this.scrollable = scrollable;
	}

	/**
	 * 获取是否单行
	 * @return 是否单行
	 */
	public Boolean getSingleLine() {
		return singleLine;
	}

	/**
	 * 设置是否单行
	 * @param singleLine 是否单行
	 */
	public void setSingleLine(Boolean singleLine) {
		this.singleLine = singleLine;
	}

	/**
	 * 获取滚动方向
	 * @return 滚动方向
	 */
	public Integer getOrientation() {
		return orientation;
	}

	/**
	 * 设置滚动方向
	 * @param orientation 滚动方向
	 */
	public void setOrientation(Integer orientation) {
		this.orientation = orientation;
	}

	/**
	 * 获取操作事件
	 * @return 操作事件
	 */
	public MetaBaseScript getAction() {
		return action;
	}

	/**
	 * 设置操作事件
	 * @param action 操作事件
	 */
	public void setAction(MetaBaseScript action) {
		this.action = action;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( action != null ) {
			list.add(action);
		}
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_Action.equals(tagName) ) {
			action = new MetaBaseScript(MetaConstants.Event_Action);
			resultMetaObject = action;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNoticeBarProperties newObject = (MetaNoticeBarProperties)newInstance();
		newObject.setAction(action == null ? null : (MetaBaseScript)action.clone());
		newObject.setPreIcon(preIcon);
		newObject.setActionIcon(actionIcon);
		newObject.setScrollable(scrollable);
		newObject.setSingleLine(singleLine);
		newObject.setOrientation(orientation);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNoticeBarProperties();
	}

	@Override
	public void merge(MetaNoticeBarProperties properties) {
		if( this.action == null ) {
			this.action = properties.getAction();
		}
		if( this.preIcon == null ) {
			this.preIcon = properties.getPreIcon();
		}
		if(actionIcon == null){
			this.actionIcon = properties.getActionIcon();
		}
		if(scrollable == null){
			this.scrollable = properties.getScrollable();
		}
		if(singleLine == null){
			singleLine = properties.getSingleLine();
		}
		if(orientation == -1){
			orientation = properties.getOrientation();
		}
	}
}
