package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.FilterValueType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaStatementCollection;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * 这个类是字典和表格过滤公用的类
 *
 * @author zhufw
 * @author 陈瑞
 *
 */
public class MetaFilterValue extends KeyPairMetaObject implements IPropertyMerger<MetaFilterValue> {
	/** 当前字典的值域标识 */
	private String fieldKey = "";
	private String key = "";


	/** 关联的值域标识 */
	private String refValue = "";
	/** 数据集过滤SQL所需要的值*/
	private String paraValue = "";
	/** 参数的数据类型 */
	private Integer dataType = -1;
	/** 取值类型*/
	private Integer type = FilterValueType.FORMULA;
	/** 条件符号*/
	private Integer sign = CondSign.EQ;

	public MetaFilterValue() {
		super();
	}

	@Override
	public String getKey() {
		return this.key;
	}

	@Override
	public void setKey(String key) {
		this.key = key;
	}
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "FilterValue";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置值域标识
	 * @param fieldKey 值域标识
	 */
	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}

	/**
	 * 取得值域标识
	 * @return 值域标识
	 */
	public String getFieldKey() {
		return this.fieldKey;
	}

	/**
	 * 设置关联值域标识
	 * @param refValue 关联值域标识
	 */
	public void setRefValue(String refValue) {
		this.refValue = refValue;

		if(type == FilterValueType.FIELD && filter != null ){
			filter.addDependedField(refValue);
		}

	}

	/**
	 * 取得关联值域标识
	 * @return 关联值域标识
	 */
	public String getRefValueKey() {
		return this.refValue;
	}

	/**
	 * 设置数据集过滤SQL所需要的值
	 * @param paraValue  参数值
	 */
	public void setParaValue(String paraValue){
		this.paraValue = paraValue;

		if(type == FilterValueType.FIELD && filter != null){
			filter.addDependedField(paraValue);
		}

	}

	/**
	 * 获取数据集过滤SQL所需要的值
	 * @return paraValue 参数值
	 */
	public String getParaValue() {
		return this.paraValue;
	}

	/**
	 * 设置值的来源类型
	 * @param type 来源类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 取得值的来源类型
	 * @return 来源类型
	 */
	public Integer getType(){
		return this.type;
	}

	/**
	 * 获取条件符号
	 * @return 条件符号
	 */
	public Integer getSign() {
		return sign;
	}

	/**
	 * 设置条件符号
	 * @param sign 条件符号
	 */
	public void setSign(Integer sign) {
		this.sign = sign;
	}

	/**
	 * 设置数据类型
	 *
	 * @param dataType
	 *            数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	/**
	 * 取得数据类型
	 *
	 * @return 数据类型
	 */
	public Integer getDataType() {
		return dataType;
	}


	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFilterValue newObject = (MetaFilterValue)newInstance();
		newObject.setFieldKey(this.fieldKey);
		newObject.setRefValue(this.refValue);
		newObject.setParaValue(this.paraValue);
		newObject.setType(this.type);
		newObject.setFilter(this.filter);
		newObject.setDataType(this.dataType);
		newObject.setSign(this.sign);
		newObject.setKey(this.key);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFilterValue();
	}

	/** 过滤 */
	private MetaFilter filter = null;

	/**
	 * 设置过滤
	 * @param filter 过滤
	 */
	public void setFilter(MetaFilter filter) {
		this.filter = filter;
	}

	@Override
	public void merge(MetaFilterValue metaFilterValue) {
		if( this.fieldKey == null ) {
			this.fieldKey = metaFilterValue.getFieldKey();
		}
		if( this.refValue == null ) {
			this.refValue = metaFilterValue.refValue;
		}
		if( this.paraValue == null ) {
			this.paraValue = metaFilterValue.paraValue;
		}
		if( this.type == -1 ) {
			this.type = metaFilterValue.type;
		}
		if( this.dataType == -1 ) {
			this.dataType = metaFilterValue.getDataType();
		}
		if( this.sign == -1 ) {
			this.sign = metaFilterValue.getSign();
		}
	}
}
