package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaDateRangePickerProperties extends AbstractMetaObject implements IPropertyMerger<MetaDateRangePickerProperties>{
	/** 区间日期连接符 */
	private String rangeSeparator = "";
	
	/** 范围选择时开始日期的占位内容 */
	private String startPlaceholder = "";
	
	/** 范围选择时结束日期的占位内容 */
	private String endPlaceholder = "";
	
	/** 文本编辑器为空时的提示信息 */
	private String promptText = "";
	
	/** 日期时间的显示格式 */
	private String dateFormat = null;
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	
	}
	
	/**
	 * 获取区间日期连接符
	 * 
	 * @return 连接符
	 */
	public String getRangeSeparator() {
		return rangeSeparator;
	}

	/**
	 * 设置区间日期连接符
	 * 
	 * @param rangeSeparator
	 *            连接符
	 */
	public void setRangeSeparator(String rangeSeparator) {
		this.rangeSeparator = rangeSeparator;
	}

	/**
	 * 获取范围选择时开始日期的占位内容
	 * 
	 * @return 占位内容
	 */
	public String getStartPlaceholder() {
		return startPlaceholder;
	}
	
	
	/**
	 * 设置范围选择时开始日期的占位内容
	 * 
	 * @param startPlaceholder
	 * 			占位内容
	 */
	public void setStartPlaceholder(String startPlaceholder) {
		this.startPlaceholder = startPlaceholder;
	}

	/**
	 * 获取范围选择时结束日期的占位内容
	 * 
	 * @return 占位内容
	 */
	public String getEndPlaceholder() {
		return endPlaceholder;
	}

	/**
	 * 设置范围选择时结束日期的占位内容
	 * 
	 * @param endPlaceholder
	 * 			占位内容
	 */
	public void setEndPlaceholder(String endPlaceholder) {
		this.endPlaceholder = endPlaceholder;
	}
	
	/**
	 * 获取文本为空时的提示信息
	 * 
	 * @return 提示信息
	 */
	public String getPromptText() {
		return promptText;
	}

	/**
	 * 设置文本为空时的提示信息
	 * 
	 * @param promptText
	 *            提示信息
	 */
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}

	/**
	 * 获取文本为空时的提示信息
	 * 
	 * @return 提示信息
	 */
	public String getDateFormat() {
		return dateFormat;
	}

	/**
	 * 设置文本为空时的提示信息
	 * 
	 * @param promptText
	 *            提示信息
	 */
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}



	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDateRangePickerProperties newObject = new MetaDateRangePickerProperties();
		newObject.setRangeSeparator(rangeSeparator);
		newObject.setStartPlaceholder(startPlaceholder);
		newObject.setEndPlaceholder(endPlaceholder);
		newObject.setDateFormat(dateFormat);
		newObject.setPromptText(promptText);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDateRangePickerProperties();
	}

	@Override
	public void merge(MetaDateRangePickerProperties properties) {
		if( this.rangeSeparator == null ) {
			this.rangeSeparator = properties.getRangeSeparator();
		}
		if( this.startPlaceholder == null ) {
			this.startPlaceholder = properties.getStartPlaceholder();
		}
		if( this.endPlaceholder == null ) {
			this.endPlaceholder = properties.getEndPlaceholder();
		}
		if( this.dateFormat == null ) {
			this.dateFormat = properties.getDateFormat();
		}
		if( this.promptText == null ) {
			this.promptText = properties.getPromptText();
		}
	}

}
