package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ComboBoxTextShowType;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.def.SelectStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;

public class MetaCheckListBoxProperties extends AbstractMetaObject implements IPropertyMerger<MetaCheckListBoxProperties>{
    public static final int DEFAULT_COLUMN_COUNT = 3;
    /** 下拉列表项集合 */
    private MetaListBoxItemCollection items = null;

    /** 表达式表示的下拉项集合 */
    private MetaBaseScript formulaItems = null;

    /** 下拉项的依赖*/
    private String itemsDependency = "";

    /** 是否缓存下拉项,不缓存每次都会远程取得,对固定项的没意义*/
    private Boolean cache = true;

    /** 下拉所依赖的字段*/
    private List<String> dependentFields = new ArrayList<String>();

    /** 查询定义*/
    private MetaQueryDef query = null;

    /** 下拉项来源,-1代表未定义*/
    private Integer sourceType = ComboBoxSourceType.ITEMS;

    /** 当sourceType为ParaGroup时 的分组标志*/
    private String groupKey = "";

    /** 全局下拉项*/
    private String globalItems = "";

    /** 组件为空值时的提示信息*/
    private String promptText = "";

    /** 显示样式*/
    private Integer style = SelectStyle.POP;

    /** 编辑样式*/
    private Integer editType = SelectEditType.DIALOG;

    /** 平铺标签样式下的列数*/
    private Integer columnCount = DEFAULT_COLUMN_COUNT;

    /** 弹出动画*/
    private String popAnim = "";

    /**单独添加class名*/
    private String cssClass = "";

    /** 下拉项显示方式 */
    private Integer textShowType = ComboBoxTextShowType.UNDEFINED;
    
    /**下拉过滤**/
    private MetaComboFilter comboFilter = null;

    public String getGroupKey() {
        return groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public MetaCheckListBoxProperties() {
        super();
        items = new MetaListBoxItemCollection();
    }

    /**
     * 返回依赖字段，字段key小写
     * @return 依赖字段集合
     */
    public List<String> getDependedFields(){
        return this.dependentFields;
    }

    /**
     * 取得依赖字段定义
     * @return 依赖字段定义
     */
    public String getItemsDependency(){
        return this.itemsDependency;
    }

    /**
     * 获取是否动态behavior
     * @return 是否动态behavior
     */
    public boolean isDynamicBehavior() {
        return dependentFields.size() > 0;
    }

    /**
     * 获取全局下拉项
     * @return 全局下拉项
     */
    public String getGlobalItems() {
        return globalItems;
    }

    /**
     * 设值全局下拉项
     * @param globalItems 全局下拉项
     */
    public void setGlobalItems(String globalItems) {
        this.globalItems = globalItems;
    }

    /**
     * 设置依赖字段定义
     * @param dependency 依赖字段定义，以;分隔多个依赖，比如[a;b]
     */
    public void setItemsDependency(String dependency){
        this.itemsDependency = "";
        this.dependentFields.clear();
        if(dependency != null && dependency.length() > 0){
            this.itemsDependency = dependency;

            String[] fields = this.itemsDependency.split(",");

            for(String field : fields){
                dependentFields.add(field);
            }
        }
    }

    /**
     * 设值依赖字段集合
     * @param dependentFields 依赖字段集合
     */
    public void setDependentFields(List<String> dependentFields) {
        this.dependentFields = dependentFields;
    }

    /**
     * 设置表达式下拉项
     *
     * @param formulaItems
     *            脚本元数据
     */
    public void setFormulaItems(MetaBaseScript formulaItems) {
        this.formulaItems = formulaItems;
    }

    /**
     * 取得表达式下拉项
     *
     * @return 脚本元数据
     */
    public MetaBaseScript getFormulaItems() {
        return this.formulaItems;
    }

    /**
     * 获取下拉项的总数
     *
     * @return 下拉项总数
     */
    public int getItemCount() {
        return items.size();
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public String getPromptText() {
        return promptText;
    }

    public Integer getStyle() {
        return style;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getColumnCount() {
        return columnCount;
    }

    public void setColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
    }

    /**
     * 根据序号取得下拉项定义
     * @param index 序号
     * @return index所在位置的下拉项定义
     */
    public MetaDefaultItem getItem(int index) {
        return items.get(index);
    }

    /**
     * 设置下拉项集合定义
     * @param items 下拉项集合定义
     */
    public void setItems(MetaListBoxItemCollection items) {
        this.items = items;
    }

    /**
     * 设置查询定义
     * @param query 查询定义
     */
    public void setQueryDef(MetaQueryDef query) {
        this.query = query;
    }

    /**
     * 取得查询定义
     * @return 查询定义
     */
    public MetaQueryDef getQueryDef(){
        return this.query;
    }

    /**
     * 取得下拉项来源类型
     * @return 来源类型
     * @see ComboBoxSourceType
     */
    public Integer getSourceType(){
        return this.sourceType;
    }

    /**
     * 设置下拉项来源类型
     * @param type 来源类型
     * @see ComboBoxSourceType
     */
    public void setSourceType(Integer type){
        this.sourceType = type;
    }

    /**
     * 取得下拉项集合定义
     * @return 下拉项集合定义
     */
    public MetaListBoxItemCollection getItems() {
        return items;
    }

    /**
     * 获取弹出动画
     * @return 弹出动画
     */
    public String getPopAnim() {
        return popAnim;
    }

    /**
     * 设置弹出动画
     * @param popAnim 弹出动画
     */
    public void setPopAnim(String popAnim) {
        this.popAnim = popAnim;
    }

    /**
     * 获取是否缓存
     * @return 标志
     */
    public Boolean getCache() {
        return cache;
    }

    /**
     * 设置是否缓存
     * @param cache 标志
     */
    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    /**
     * 添加class
     * @return class
     */
    public String getCssClass() {
        return cssClass;
    }

    /**
     * 添加class
     * @param cssClass
     */
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    /**
     * 取得下拉项显示方式
     * @return 下拉项显示方式
     */
    public Integer getTextShowType(){
        return this.textShowType;
    }

    /**
     * 取得下拉项显示方式
     * @param type 下拉项显示方式
     */
    public void setTextShowType(Integer type){
        this.textShowType = type;
    }

    /**
     * 获取下拉项显示格式
     *
     * @return
     */
    public String getTextShowFormat() {
        return ComboBoxTextShowType.getFormatString(this.getTextShowType());
    }

    /**
     * 取得下拉过滤
     * @return 下拉过滤
     */
    public MetaComboFilter getComboFilter() {
		return comboFilter;
	}
    
    
    /**
     * 设置下拉过滤
     * @param comboFilter 下拉过滤
     */
    public void setComboFilter(MetaComboFilter comboFilter) {
		this.comboFilter = comboFilter;
	}
    

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        addAll(list, new AbstractMetaObject[] { items, formulaItems, query, comboFilter });
    }

    @Override
    public String getTagName() {

        return null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if(this.query != null){
            query.doPostProcess(flag, callback);

            List<String> list = this.query.getDependedFields();
            if(list != null){
                for(String field : list){
                    if(!this.dependentFields.contains(field)){
                        this.dependentFields.add(field);
                    }
                }
            }
        }
        if(this.comboFilter != null) {
        	this.comboFilter.doPostProcess(flag, callback);
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
                                                    Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
        if ( resultMetaObject == null ) {
            if ( tagName.equalsIgnoreCase(MetaConstants.COMBOBOX_FORMULAITEMS) ) {
                this.formulaItems = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
                resultMetaObject = formulaItems;
            }else if(tagName.equalsIgnoreCase(MetaQueryDef.TAG_NAME)){
                this.query = new MetaQueryDef();
                resultMetaObject = query;
            }else if(tagName.equalsIgnoreCase(MetaComboFilter.TAG_NAME)) {
            	this.comboFilter = new MetaComboFilter();
            	resultMetaObject = comboFilter;
            }
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaCheckListBoxProperties newObject = new MetaCheckListBoxProperties();
        newObject.setItems(items == null ? null : (MetaListBoxItemCollection)items.clone());
        newObject.setFormulaItems(formulaItems == null ? null : (MetaBaseScript)formulaItems.clone());
        newObject.setItemsDependency(itemsDependency);
        newObject.setQueryDef(query == null ? null : (MetaQueryDef)query.clone());
        newObject.setSourceType(sourceType);
        newObject.setGroupKey(groupKey);
        newObject.setGlobalItems(globalItems);
        newObject.setDependentFields(dependentFields);
        newObject.setPromptText(promptText);
        newObject.setStyle(style);
        newObject.setEditType(editType);
        newObject.setCache(cache);
        newObject.setColumnCount(columnCount);
        newObject.setPopAnim(popAnim);
        newObject.setCssClass(cssClass);
        newObject.setTextShowType(textShowType);
        newObject.setComboFilter(comboFilter == null ? null : (MetaComboFilter)comboFilter.clone());
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaCheckListBoxProperties();
    }

    @Override
    public void merge(MetaCheckListBoxProperties properties) {
        //noinspection DuplicatedCode
        if (Objects.nonNull(properties.getItems())) {
            MetaListBoxItemCollection items = (MetaListBoxItemCollection) properties.getItems().clone();
            if (Objects.nonNull(this.items)) {
                List<String> existItemKeys = new ArrayList<>();
                for (MetaDefaultItem item : items) {
                    existItemKeys.add(item.getKey());
                }
                for (MetaDefaultItem item : this.items) {
                    if (!existItemKeys.contains(item.getKey())) {
                        items.add((MetaDefaultItem) item.clone());
                    }
                }
            }
            this.items = (MetaListBoxItemCollection) items.clone();
        }

        if (this.formulaItems == null) {
            this.formulaItems = properties.getFormulaItems();
        }
        if (this.query == null) {
            this.query = properties.getQueryDef();
        }
        if (this.itemsDependency == null) {
            this.itemsDependency = properties.getItemsDependency();
        }
        if (this.sourceType == -1) {
            this.sourceType = properties.getSourceType();
        }
        if (this.cache == null) {
            this.cache = properties.getCache();
        }
        if (this.groupKey == null) {
            this.groupKey = properties.getGroupKey();
        }
        if (this.globalItems == null) {
            this.globalItems = properties.getGlobalItems();
        }
        if (this.cssClass == null) {
            this.cssClass = properties.getCssClass();
        }
        if (this.textShowType == ComboBoxTextShowType.UNDEFINED) {
            this.textShowType = properties.getTextShowType();
        }

        MetaComboFilter comboFilter = properties.getComboFilter();
        if( comboFilter != null ) {
            if( this.comboFilter == null ) {
                this.comboFilter = (MetaComboFilter) comboFilter.clone();
            } else {
                this.comboFilter.merge(comboFilter);
            }
        }

    }
}