package com.bokesoft.yigo.meta.form.component.control.listview;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;

public class MetaWaterFall extends MetaEditView {
	public static final String TAG_NAME = ControlType.STR_WATERFALL;
	public static final int WATERFALL_DEFAULT_COUNT = 2;
	/** 固定方向数量 */
	private Integer count = WATERFALL_DEFAULT_COUNT;
	/** 行间隔 */
	private Integer rowGap = 0;
	/** 单元格间隔 */
	private Integer cellGap = 0;
	 
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.WATERFALL;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaWaterFall newObject = (MetaWaterFall)super.clone();
		newObject.setCount(count);
		newObject.setRowGap(rowGap);
		newObject.setCellGap(cellGap);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWaterFall();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	/**
	 * 设置固定方向数量，比如垂直方向滚动，则该数量为水平方向的单元数量
	 * @param count 数量
	 */
	public void setCount(Integer count) {
		this.count = count;
	}
	
	/**
	 * 取得固定方向数量，比如垂直方向滚动，则该数量为水平方向的单元数量
	 * @return 数量
	 */
	public Integer getCount() {
		return this.count;
	}
	
	/**
	 * 设置行间隔
	 * @param rowGap 行间隔
	 */
	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}
	
	/**
	 * 获取行间隔
	 * @return 行间隔
	 */
	public Integer getRowGap() {
		return rowGap;
	}
	
	/**
	 * 设置单元格间隔
	 * @param cellGap 单元格间隔
	 */
	public void setCellGap(Integer cellGap) {
		this.cellGap = cellGap;
	}
	
	/**
	 * 获取单元格间隔
	 * @return 单元格间隔
	 */
	public Integer getCellGap() {
		return cellGap;
	}
}
