package com.bokesoft.yigo.meta.form.component.control.editview;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaEditViewItem extends KeyPairMetaObject {

	/**
	 * 配置文件中对应节点的标签名称
	 */
	public static final String TAG_NAME = "EditViewItem";

	/**
	 * 标识
	 */
	private String key = "";

	/**
	 * 说明
	 */
	private String caption = "";

	/**
	 * 图片相对于Resource文件夹路径
	 */
	private String image = "";
	
	/**
	 * 拉伸缩放类型
	 */
	private Integer imageScaleType = ImageScaleType.FIT_XY;

	public String getKey() {
		return this.key;
	}

	@Override
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 获取说明
	 *
	 * @return 说明，默认值为{@link #caption}
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置说明
	 *
	 * @param caption 说明，默认值为{@link #caption}
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 获取图片相对于Resource文件夹路径
	 *
	 * @return 图片路径，默认值为{@link #image}
	 */
	public String getImage() {
		return image;
	}

	/**
	 * 设置图片相对于Resource文件夹路径
	 *
	 * @param image 图片路径，默认值为{@link #image}
	 */
	public void setImage(String image) {
		this.image = image;
	}
	
	/**
	 * 获取拉伸缩放类型
	 * @return 拉伸缩放类型
	 */
	public Integer getImageScaleType() {
		return imageScaleType;
	}
	
	/**
	 * 设置拉伸缩放类型
	 * @param imageScaleType 拉伸缩放类型
	 */
	public void setImageScaleType(Integer imageScaleType) {
		this.imageScaleType = imageScaleType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	public boolean needPreLoad() {
		return true;
	}

	@Override
	public MetaEditViewItem clone() {
		MetaEditViewItem newObject = newInstance();
		newObject.setKey(key);
		newObject.setImage(image);
		newObject.setCaption(caption);
		newObject.setImageScaleType(imageScaleType);
		return newObject;
	}

	@Override
	public MetaEditViewItem newInstance() {
		return new MetaEditViewItem();
	}
}
