package com.bokesoft.yigo.meta.form.component.control.dictview;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DictLoadType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;

public class MetaDictView extends MetaComponent {
	/** 公式表示的字典标识 */
	private String formulaItemKey = "";
	/** 分页时 每页显示行数 */
	private Integer pageRowCount = 50;
	/** 行点击事件 */
	private MetaBaseScript rowClick = null;
	/** 行双击事件 */
	private MetaBaseScript rowDblClick = null;
	/** 焦点行改变事件 */
	private MetaBaseScript focusRowChanged = null;
	/** 字典过滤条件 */
	private MetaItemFilterCollection filters = null;

	/** 自定义字典显示列,优先于默认code,name,且为缓存列 */
	private MetaDictViewColumnCollection columns = null;

	/** 点击展开箭头是否只展开不触发选中*/
	private Boolean onlyExpand = false;
	/** 是否显示列头*/
	private Boolean showTitle = true;

	/**	字典加载策略 -1 代表未定义*/
	private Integer loadType = DictLoadType.R2L;

	public MetaDictView() {
		super();
	}

	public static final String TAG_NAME = ControlType.STR_DICTVIEW;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.DICTVIEW;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { rowClick, rowDblClick, focusRowChanged, columns });

		if (this.filters != null) {
			filters.getChildMetaObjects(list);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;

		if (MetaConstants.Event_RowClick.equals(tagName)) {
			rowClick = new MetaBaseScript(MetaConstants.Event_RowClick);
			resultMetaObject = rowClick;
		} else if (MetaConstants.Event_RowDblClick.equals(tagName)) {
			rowDblClick = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			resultMetaObject = rowDblClick;
		} else if (MetaConstants.Event_FocusRowChanged.equals(tagName)) {
			focusRowChanged = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			resultMetaObject = focusRowChanged;
		} else if (MetaItemFilter.TAG_NAME.equals(tagName)) {
			if (filters == null) {
				filters = new MetaItemFilterCollection();
			}
			resultMetaObject = filters.createChildMetaObject(env, doc, node, tagName, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaDictViewColumnCollection.TAG_NAME)) {
			columns = new MetaDictViewColumnCollection();
			resultMetaObject = columns;
		} else {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}

		return resultMetaObject;
	}

	/**
	 * 设置加载策略
	 * @param type 加载策略
	 */
	public void setLoadType(Integer type){
		this.loadType = type;
	}

	/**
	 * 获取加载策略
	 * @return 加载策略
	 */
	public Integer getLoadType(){
		return this.loadType;
	}

	@Override
	public boolean receiveFocus() {
		return false;
	}

	/**
	 * 设置行点击事件
	 * 
	 * @param rowClick
	 *            行点击事件
	 * @see MetaBaseScript
	 */
	public void setRowClick(MetaBaseScript rowClick) {
		this.rowClick = rowClick;
	}

	/**
	 * 取得行点击事件
	 * 
	 * @return 行点击事件
	 * @see MetaBaseScript
	 */
	public MetaBaseScript getRowClick() {
		return this.rowClick;
	}

	/**
	 * 设置行双击事件
	 * 
	 * @param rowDblClick
	 *            行双击事件
	 * @see MetaBaseScript
	 */
	public void setRowDblClick(MetaBaseScript rowDblClick) {
		this.rowDblClick = rowDblClick;
	}

	/**
	 * 取得行双击事件
	 * 
	 * @return 行点击事件
	 * @see MetaBaseScript
	 */
	public MetaBaseScript getRowDblClick() {
		return this.rowDblClick;
	}

	/**
	 * 设置焦点行改变事件
	 * 
	 * @param focusRowChanged
	 *            定义
	 */
	public void setFocusRowChanged(MetaBaseScript focusRowChanged) {
		this.focusRowChanged = focusRowChanged;
	}

	/**
	 * 取得焦点行改变事件
	 * 
	 * @return 定义
	 */
	public MetaBaseScript getFocusRowChanged() {
		return this.focusRowChanged;
	}

	public void setFormulaItemKey(String formulaItemKey) {
		this.formulaItemKey = formulaItemKey;
	}

	public String getFormulaItemKey() {
		return this.formulaItemKey;
	}

	public void setPageRowCount(Integer count) {
		this.pageRowCount = count;
	}

	public Integer getPageRowCount() {
		return this.pageRowCount;
	}

	/**
	 * 设置过滤条件
	 * 
	 * @param filters
	 *            过滤条件
	 */
	public void setFilters(MetaItemFilterCollection filters) {
		this.filters = filters;
	}

	/**
	 * 取得过滤条件
	 * 
	 * @return 过滤条件
	 */
	public MetaItemFilterCollection getFilters() {
		return this.filters;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDictView newObject = (MetaDictView) super.clone();
		;
		newObject.setRowClick(rowClick == null ? null : (MetaBaseScript) rowClick.clone());
		newObject.setRowDblClick(rowDblClick == null ? null : (MetaBaseScript) rowDblClick.clone());
		newObject.setFocusRowChanged(focusRowChanged == null ? null : (MetaBaseScript) focusRowChanged.clone());
		newObject.setFormulaItemKey(formulaItemKey);
		newObject.setPageRowCount(pageRowCount);
		newObject.setOnlyExpand(onlyExpand);
		newObject.setShowTitle(showTitle);
		newObject.setLoadType(loadType);
		newObject.setColumnCollection(
				columns == null ? null : (MetaDictViewColumnCollection) columns.clone());
		newObject.setFilters(filters == null ? null : (MetaItemFilterCollection) filters.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictView();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	public void setColumnCollection(MetaDictViewColumnCollection columnCollection) {
		this.columns = columnCollection;
	}

	public MetaDictViewColumnCollection getColumnCollection() {
		return this.columns;
	}

	public Boolean getOnlyExpand() {
		return onlyExpand;
	}

	public void setOnlyExpand(Boolean onlyExpand) {
		this.onlyExpand = onlyExpand;
	}

	public Boolean getShowTitle() {
		return showTitle;
	}

	public void setShowTitle(Boolean showTitle) {
		this.showTitle = showTitle;
	}

	@Override
	public void merge(MetaComponent meta) {
		
		super.merge(meta);
		
		MetaDictView dictView = (MetaDictView)meta;
		if( this.formulaItemKey == null ) {
			this.formulaItemKey = dictView.getFormulaItemKey();
		}
		if( this.onlyExpand == null ) {
			this.onlyExpand = dictView.getOnlyExpand();
		}
		if( this.showTitle == null ) {
			this.showTitle = dictView.getShowTitle();
		}
		if( this.loadType == -1 ) {
			this.loadType = dictView.getLoadType();
		}
		if( this.pageRowCount == -1 ) {
			this.pageRowCount = dictView.getPageRowCount();
		}
		if( this.rowClick == null ) {
			this.rowClick = dictView.getRowClick();
		}
		if( this.rowDblClick == null ) {
			this.rowDblClick = dictView.getRowDblClick();
		}
		if( this.focusRowChanged == null ) {
			this.focusRowChanged = dictView.getFocusRowChanged();
		}
		if( this.filters == null ) {
			MetaItemFilterCollection itemFilters = dictView.getFilters();
			if( itemFilters != null ) {
				this.filters = (MetaItemFilterCollection) itemFilters.clone();
			}
		} else {
			MetaItemFilterCollection itemFilters = dictView.getFilters();
			if(itemFilters != null) {
				for(MetaItemFilter filter : this.filters) {
					MetaItemFilter metaFilter = itemFilters.get(filter.getKey());
					if(metaFilter != null) {
						filter.merge(metaFilter);
					}
				}
			}
		}
		if( this.columns != null ) {
			this.columns.merge(dictView.getColumnCollection());
		}
	}
}
