package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;

public class MetaTimePicker extends MetaComponent{
	public static final String TAG_NAME = ControlType.STR_TIMEPICKER;
	
	private MetaTimePickerProperties properties = new MetaTimePickerProperties();

	
	public void setDateFormat(String dateFormat){
		this.properties.setDateFormat(dateFormat);
	}
	
	public void setSecond(Boolean isSecond){
		this.properties.setSecond(isSecond);
	}
	
	public Boolean isSecond(){
		return this.properties.isSecond();
	}
	
	public void getDateFormat(){
		this.properties.getDateFormat();
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaTimePickerProperties) properties;
	}
	

	@Override
	public int getControlType() {
		return ControlType.TIMEPICKER;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTimePicker();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTimePicker newObject = (MetaTimePicker) super.clone();
		newObject.setProperties((MetaTimePickerProperties) properties.clone());
		return newObject;
	}

}
