package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRadioButtonProperties;

/**
 * 单选框配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaRadioButton extends MetaComponent {

	private MetaRadioButtonProperties properties = new MetaRadioButtonProperties();

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_RADIOBUTTON;

	/**
	 * 设置所属组的标识
	 * 
	 * @param key
	 *            组标识
	 */
	public void setGroupKey(String key) {
		this.properties.setGroupKey(key);
	}

	/**
	 * 获取所属组的标识
	 * 
	 * @return 组标识
	 */
	public String getGroupKey() {
		return this.properties.getGroupKey();
	}

	/**
	 * 设置是否为组的主控件
	 * 
	 * @param isGroupHead
	 *            是否为组的主控件
	 */
	public void setGroupHead(Boolean isGroupHead) {
		this.properties.setGroupHead(isGroupHead);
	}

	/**
	 * 获取是否为组的主控件
	 * 
	 * @return 是否为组的主控件
	 */
	public Boolean isGroupHead() {
		return this.properties.getGroupHead();
	}

	/**
	 * 设置选中时的取值
	 * 
	 * @param value
	 *            选中时的取值
	 */
	public void setSelectedValue(String value) {
		this.properties.setSelectedValue(value);
	}

	/**
	 * 获取选中时的取值
	 * 
	 * @return 选中时的取值
	 */
	public String getSelectedValue() {
		return this.properties.getSelectedValue();
	}
	
	/**
	 * 设置默认图标
	 * @param icon 默认图标
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}
	
	/**
	 * 获取默认图标
	 * @return 默认图标
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}
	
	/**
	 * 设置选中图标
	 * @param selectedIcon 选中图标
	 */
	public void setSelectedIcon(String selectedIcon) {
		this.properties.setSelectedIcon(selectedIcon);
	}
	
	/**
	 * 获取选中图标
	 * @return 选中图标
	 */
	public String getSelectedIcon() {
		return this.properties.getSelectedIcon();
	}
	
	/**
	 * 设置图标位置
	 * @param iconLocation 图标位置
	 */
	public void setIconLocation(Integer iconLocation) {
		this.properties.setIconLocation(iconLocation);
	}
	
	/**
	 * 获取图标位置
	 * @return 图标位置
	 */
	public Integer getIconLocation() {
		return this.properties.getIconLocation();
	}
	
	/**
	 * 获取是否隐藏按钮
	 * @return 是否隐藏按钮
	 */
	public Boolean getIsHideButton() {
		return this.properties.getHideButton();
	}
	
	/**
	 * 设置是否隐藏按钮
	 * @param isHideButton 是否隐藏按钮
	 */
	public void setHideButton(Boolean isHideButton) {
		this.properties.setHideButton(isHideButton);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.RADIOBUTTON;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRadioButton newObject = (MetaRadioButton)super.clone();
		newObject.setProperties(properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRadioButton();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return this.properties;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaRadioButtonProperties) properties;
	}

}
